"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBCluster = exports.DBClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const adb_generated_1 = require("./adb.generated");
Object.defineProperty(exports, "DBClusterProperty", { enumerable: true, get: function () { return adb_generated_1.RosDBCluster; } });
/**
 * A ROS resource type:  `ALIYUN::ADB::DBCluster`
 */
class DBCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::ADB::DBCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBCluster = new adb_generated_1.RosDBCluster(this, id, {
            dbNodeStorage: props.dbNodeStorage,
            periodType: props.periodType,
            dbClusterCategory: props.dbClusterCategory,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            vpcId: props.vpcId,
            vSwitchId: props.vSwitchId,
            mode: props.mode,
            dbClusterDescription: props.dbClusterDescription,
            computeResource: props.computeResource,
            period: props.period,
            payType: props.payType,
            elasticIoResource: props.elasticIoResource,
            dbClusterVersion: props.dbClusterVersion === undefined || props.dbClusterVersion === null ? '3.0' : props.dbClusterVersion,
            dbNodeGroupCount: props.dbNodeGroupCount,
            executorCount: props.executorCount,
            dbClusterClass: props.dbClusterClass,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBCluster;
        this.attrConnectionString = rosDBCluster.attrConnectionString;
        this.attrDbClusterId = rosDBCluster.attrDbClusterId;
        this.attrOrderId = rosDBCluster.attrOrderId;
    }
}
exports.DBCluster = DBCluster;
//# sourceMappingURL=data:application/json;base64,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