# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
#
# MIT License
#
# Copyright (c) 2022 KuFlow
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
# --------------------------------------------------------------------------
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
#
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AbstractAudited(_serialization.Model):
    """AbstractAudited.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Authentication, ProcessPageItem, Process, TaskPageItem, Task

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Identifies the concrete type of the audited model. Required. Known values
     are: "PROCESS", "PROCESS_PAGE_ITEM", "TASK", "TASK_PAGE_ITEM", and "AUTHENTICATION".
    :vartype object_type: str or ~kuflow.rest.models.AuditedObjectType
    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    _subtype_map = {
        "object_type": {
            "AUTHENTICATION": "Authentication",
            "PROCESS_PAGE_ITEM": "ProcessPageItem",
            "PROCESS": "Process",
            "TASK_PAGE_ITEM": "TaskPageItem",
            "TASK": "Task",
        }
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None
        self.created_by = created_by
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_at = last_modified_at


class Authentication(AbstractAudited):
    """Authentication.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Identifies the concrete type of the audited model. Required. Known values
     are: "PROCESS", "PROCESS_PAGE_ITEM", "TASK", "TASK_PAGE_ITEM", and "AUTHENTICATION".
    :vartype object_type: str or ~kuflow.rest.models.AuditedObjectType
    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id:
    :vartype id: str
    :ivar type: Default value is "ENGINE".
    :vartype type: str
    :ivar token:
    :vartype token: str
    :ivar expired_at:
    :vartype expired_at: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
        "id": {"readonly": True},
        "token": {"readonly": True},
        "expired_at": {"readonly": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "token": {"key": "token", "type": "str"},
        "expired_at": {"key": "expiredAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        type: Optional[Literal["ENGINE"]] = None,
        **kwargs,
    ):
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword type: Default value is "ENGINE".
        :paramtype type: str
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.object_type: str = "AUTHENTICATION"
        self.id = None
        self.type = type
        self.token = None
        self.expired_at = None


class DefaultError(_serialization.Model):
    """Default error.

    All required parameters must be populated in order to send to Azure.

    :ivar timestamp: Timestamp indicating when the error happened. Required.
    :vartype timestamp: ~datetime.datetime
    :ivar status: HTTP Status. Required.
    :vartype status: int
    :ivar message: Message Status. Required.
    :vartype message: str
    :ivar errors: Related error information.
    :vartype errors: list[~kuflow.rest.models.DefaultErrorInfo]
    """

    _validation = {
        "timestamp": {"required": True},
        "status": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "int"},
        "message": {"key": "message", "type": "str"},
        "errors": {"key": "errors", "type": "[DefaultErrorInfo]"},
    }

    def __init__(
        self,
        *,
        timestamp: datetime.datetime,
        status: int,
        message: str,
        errors: Optional[List["_models.DefaultErrorInfo"]] = None,
        **kwargs,
    ):
        """
        :keyword timestamp: Timestamp indicating when the error happened. Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword status: HTTP Status. Required.
        :paramtype status: int
        :keyword message: Message Status. Required.
        :paramtype message: str
        :keyword errors: Related error information.
        :paramtype errors: list[~kuflow.rest.models.DefaultErrorInfo]
        """
        super().__init__(**kwargs)
        self.timestamp = timestamp
        self.status = status
        self.message = message
        self.errors = errors


class DefaultErrorInfo(_serialization.Model):
    """DefaultErrorInfo.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required.
    :vartype code: str
    :ivar message: Required.
    :vartype message: str
    :ivar location:
    :vartype location: str
    :ivar location_type:
    :vartype location_type: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "location_type": {"key": "locationType", "type": "str"},
    }

    def __init__(
        self, *, code: str, message: str, location: Optional[str] = None, location_type: Optional[str] = None, **kwargs
    ):
        """
        :keyword code: Required.
        :paramtype code: str
        :keyword message: Required.
        :paramtype message: str
        :keyword location:
        :paramtype location: str
        :keyword location_type:
        :paramtype location_type: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.location = location
        self.location_type = location_type


class Log(_serialization.Model):
    """Log.

    All required parameters must be populated in order to send to Azure.

    :ivar id:
    :vartype id: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar message: Required.
    :vartype message: str
    :ivar level: Required. Known values are: "INFO", "WARN", and "ERROR".
    :vartype level: str or ~kuflow.rest.models.LogLevel
    """

    _validation = {
        "message": {"required": True},
        "level": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "level": {"key": "level", "type": "str"},
    }

    def __init__(
        self,
        *,
        message: str,
        level: Union[str, "_models.LogLevel"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        created_at: Optional[datetime.datetime] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword message: Required.
        :paramtype message: str
        :keyword level: Required. Known values are: "INFO", "WARN", and "ERROR".
        :paramtype level: str or ~kuflow.rest.models.LogLevel
        """
        super().__init__(**kwargs)
        self.id = id
        self.created_at = created_at
        self.message = message
        self.level = level


class Page(_serialization.Model):
    """Page.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    PrincipalPage, ProcessPage, TaskPage

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Paged Model types. Required. Known values are: "PRINCIPAL_PAGE",
     "PROCESS_PAGE", and "TASK_PAGE".
    :vartype object_type: str or ~kuflow.rest.models.PagedObjectType
    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    """

    _validation = {
        "object_type": {"required": True},
        "metadata": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "metadata": {"key": "metadata", "type": "PageMetadata"},
    }

    _subtype_map = {
        "object_type": {"PRINCIPAL_PAGE": "PrincipalPage", "PROCESS_PAGE": "ProcessPage", "TASK_PAGE": "TaskPage"}
    }

    def __init__(self, *, metadata: "_models.PageMetadata", **kwargs):
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None
        self.metadata = metadata


class PageMetadata(_serialization.Model):
    """PageMetadata.

    All required parameters must be populated in order to send to Azure.

    :ivar size: Required.
    :vartype size: int
    :ivar page: Required.
    :vartype page: int
    :ivar total_elements: Required.
    :vartype total_elements: int
    :ivar total_pages: Required.
    :vartype total_pages: int
    """

    _validation = {
        "size": {"required": True, "minimum": 0},
        "page": {"required": True, "minimum": 0},
        "total_elements": {"required": True},
        "total_pages": {"required": True},
    }

    _attribute_map = {
        "size": {"key": "size", "type": "int"},
        "page": {"key": "page", "type": "int"},
        "total_elements": {"key": "totalElements", "type": "int"},
        "total_pages": {"key": "totalPages", "type": "int"},
    }

    def __init__(self, *, size: int, page: int, total_elements: int, total_pages: int, **kwargs):
        """
        :keyword size: Required.
        :paramtype size: int
        :keyword page: Required.
        :paramtype page: int
        :keyword total_elements: Required.
        :paramtype total_elements: int
        :keyword total_pages: Required.
        :paramtype total_pages: int
        """
        super().__init__(**kwargs)
        self.size = size
        self.page = page
        self.total_elements = total_elements
        self.total_pages = total_pages


class Principal(_serialization.Model):
    """Principal.

    :ivar id:
    :vartype id: str
    :ivar type: Known values are: "USER", "APPLICATION", and "SYSTEM".
    :vartype type: str or ~kuflow.rest.models.PrincipalType
    :ivar name:
    :vartype name: str
    :ivar user:
    :vartype user: ~kuflow.rest.models.PrincipalUser
    :ivar application:
    :vartype application: ~kuflow.rest.models.PrincipalApplication
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "user": {"key": "user", "type": "PrincipalUser"},
        "application": {"key": "application", "type": "PrincipalApplication"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[Union[str, "_models.PrincipalType"]] = None,
        name: Optional[str] = None,
        user: Optional["_models.PrincipalUser"] = None,
        application: Optional["_models.PrincipalApplication"] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword type: Known values are: "USER", "APPLICATION", and "SYSTEM".
        :paramtype type: str or ~kuflow.rest.models.PrincipalType
        :keyword name:
        :paramtype name: str
        :keyword user:
        :paramtype user: ~kuflow.rest.models.PrincipalUser
        :keyword application:
        :paramtype application: ~kuflow.rest.models.PrincipalApplication
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.user = user
        self.application = application


class PrincipalApplication(_serialization.Model):
    """PrincipalApplication.

    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id:
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrincipalPage(Page):
    """PrincipalPage.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Paged Model types. Required. Known values are: "PRINCIPAL_PAGE",
     "PROCESS_PAGE", and "TASK_PAGE".
    :vartype object_type: str or ~kuflow.rest.models.PagedObjectType
    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.Principal]
    """

    _validation = {
        "object_type": {"required": True},
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[Principal]"},
    }

    def __init__(self, *, metadata: "_models.PageMetadata", content: List["_models.Principal"], **kwargs):
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.Principal]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.object_type: str = "PRINCIPAL_PAGE"
        self.content = content


class PrincipalUser(_serialization.Model):
    """PrincipalUser.

    :ivar id:
    :vartype id: str
    :ivar email:
    :vartype email: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(
        self, *, id: Optional[str] = None, email: Optional[str] = None, **kwargs  # pylint: disable=redefined-builtin
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword email:
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.email = email


class Process(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """Process.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Identifies the concrete type of the audited model. Required. Known values
     are: "PROCESS", "PROCESS_PAGE_ITEM", "TASK", "TASK_PAGE_ITEM", and "AUTHENTICATION".
    :vartype object_type: str or ~kuflow.rest.models.AuditedObjectType
    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Process ID.
    :vartype id: str
    :ivar subject: Process subject.
    :vartype subject: str
    :ivar state: Process state. Known values are: "RUNNING", "COMPLETED", and "CANCELLED".
    :vartype state: str or ~kuflow.rest.models.ProcessState
    :ivar process_definition: Required.
    :vartype process_definition: ~kuflow.rest.models.ProcessDefinitionSummary
    :ivar element_values: Process element values, an ElementValueDocument is not allowed.
    :vartype element_values: dict[str, list[~kuflow.rest.models.ProcessElementValue]]
    :ivar initiator:
    :vartype initiator: ~kuflow.rest.models.Principal
    :ivar related_process:
    :vartype related_process: ~kuflow.rest.models.RelatedProcess
    """

    _validation = {
        "object_type": {"required": True},
        "subject": {"max_length": 255, "min_length": 1},
        "process_definition": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "process_definition": {"key": "processDefinition", "type": "ProcessDefinitionSummary"},
        "element_values": {"key": "elementValues", "type": "{[ProcessElementValue]}"},
        "initiator": {"key": "initiator", "type": "Principal"},
        "related_process": {"key": "relatedProcess", "type": "RelatedProcess"},
    }

    def __init__(
        self,
        *,
        process_definition: "_models.ProcessDefinitionSummary",
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subject: Optional[str] = None,
        state: Optional[Union[str, "_models.ProcessState"]] = None,
        element_values: Optional[Dict[str, List["_models.ProcessElementValue"]]] = None,
        initiator: Optional["_models.Principal"] = None,
        related_process: Optional["_models.RelatedProcess"] = None,
        **kwargs,
    ):
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Process ID.
        :paramtype id: str
        :keyword subject: Process subject.
        :paramtype subject: str
        :keyword state: Process state. Known values are: "RUNNING", "COMPLETED", and "CANCELLED".
        :paramtype state: str or ~kuflow.rest.models.ProcessState
        :keyword process_definition: Required.
        :paramtype process_definition: ~kuflow.rest.models.ProcessDefinitionSummary
        :keyword element_values: Process element values, an ElementValueDocument is not allowed.
        :paramtype element_values: dict[str, list[~kuflow.rest.models.ProcessElementValue]]
        :keyword initiator:
        :paramtype initiator: ~kuflow.rest.models.Principal
        :keyword related_process:
        :paramtype related_process: ~kuflow.rest.models.RelatedProcess
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.object_type: str = "PROCESS"
        self.id = id
        self.subject = subject
        self.state = state
        self.process_definition = process_definition
        self.element_values = element_values
        self.initiator = initiator
        self.related_process = related_process


class ProcessChangeInitiatorCommand(_serialization.Model):
    """Command to change the process initiator, only one option is required.

    :ivar principal_id:
    :vartype principal_id: str
    :ivar email:
    :vartype email: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(self, *, principal_id: Optional[str] = None, email: Optional[str] = None, **kwargs):
        """
        :keyword principal_id:
        :paramtype principal_id: str
        :keyword email:
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.email = email


class ProcessDefinitionSummary(_serialization.Model):
    """ProcessDefinitionSummary.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar version:
    :vartype version: str
    :ivar name:
    :vartype name: str
    """

    _validation = {
        "id": {"required": True},
        "name": {"max_length": 50, "min_length": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword version:
        :paramtype version: str
        :keyword name:
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.version = version
        self.name = name


class ProcessDeleteElementCommand(_serialization.Model):
    """ProcessDeleteElementCommand.

    All required parameters must be populated in order to send to Azure.

    :ivar element_definition_code: Code of task element to delete. Required.
    :vartype element_definition_code: str
    """

    _validation = {
        "element_definition_code": {"required": True},
    }

    _attribute_map = {
        "element_definition_code": {"key": "elementDefinitionCode", "type": "str"},
    }

    def __init__(self, *, element_definition_code: str, **kwargs):
        """
        :keyword element_definition_code: Code of task element to delete. Required.
        :paramtype element_definition_code: str
        """
        super().__init__(**kwargs)
        self.element_definition_code = element_definition_code


class ProcessElementValue(_serialization.Model):
    """ProcessElementValue.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ProcessElementValueNumber, ProcessElementValueString

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Process element value types. Required. Known values are: "STRING" and "NUMBER".
    :vartype type: str or ~kuflow.rest.models.ProcessElementValueType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"NUMBER": "ProcessElementValueNumber", "STRING": "ProcessElementValueString"}}

    def __init__(self, *, valid: bool = True, **kwargs):
        """
        :keyword valid:
        :paramtype valid: bool
        """
        super().__init__(**kwargs)
        self.valid = valid
        self.type: Optional[str] = None


class ProcessElementValueNumber(ProcessElementValue):
    """ProcessElementValueNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Process element value types. Required. Known values are: "STRING" and "NUMBER".
    :vartype type: str or ~kuflow.rest.models.ProcessElementValueType
    :ivar value:
    :vartype value: float
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, valid: bool = True, value: Optional[float] = None, **kwargs):
        """
        :keyword valid:
        :paramtype valid: bool
        :keyword value:
        :paramtype value: float
        """
        super().__init__(valid=valid, **kwargs)
        self.type: str = "NUMBER"
        self.value = value


class ProcessElementValueString(ProcessElementValue):
    """ProcessElementValueString.

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Process element value types. Required. Known values are: "STRING" and "NUMBER".
    :vartype type: str or ~kuflow.rest.models.ProcessElementValueType
    :ivar value:
    :vartype value: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, valid: bool = True, value: Optional[str] = None, **kwargs):
        """
        :keyword valid:
        :paramtype valid: bool
        :keyword value:
        :paramtype value: str
        """
        super().__init__(valid=valid, **kwargs)
        self.type: str = "STRING"
        self.value = value


class ProcessPage(Page):
    """ProcessPage.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Paged Model types. Required. Known values are: "PRINCIPAL_PAGE",
     "PROCESS_PAGE", and "TASK_PAGE".
    :vartype object_type: str or ~kuflow.rest.models.PagedObjectType
    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.ProcessPageItem]
    """

    _validation = {
        "object_type": {"required": True},
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[ProcessPageItem]"},
    }

    def __init__(self, *, metadata: "_models.PageMetadata", content: List["_models.ProcessPageItem"], **kwargs):
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.ProcessPageItem]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.object_type: str = "PROCESS_PAGE"
        self.content = content


class ProcessPageItem(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """ProcessPageItem.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Identifies the concrete type of the audited model. Required. Known values
     are: "PROCESS", "PROCESS_PAGE_ITEM", "TASK", "TASK_PAGE_ITEM", and "AUTHENTICATION".
    :vartype object_type: str or ~kuflow.rest.models.AuditedObjectType
    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id: Process ID.
    :vartype id: str
    :ivar subject: Process subject.
    :vartype subject: str
    :ivar state: Process state. Known values are: "RUNNING", "COMPLETED", and "CANCELLED".
    :vartype state: str or ~kuflow.rest.models.ProcessState
    :ivar process_definition: Required.
    :vartype process_definition: ~kuflow.rest.models.ProcessDefinitionSummary
    :ivar element_values: Process element values, an ElementValueDocument is not allowed.
    :vartype element_values: dict[str, list[~kuflow.rest.models.ProcessElementValue]]
    :ivar initiator:
    :vartype initiator: ~kuflow.rest.models.Principal
    """

    _validation = {
        "object_type": {"required": True},
        "subject": {"max_length": 255, "min_length": 1},
        "process_definition": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "process_definition": {"key": "processDefinition", "type": "ProcessDefinitionSummary"},
        "element_values": {"key": "elementValues", "type": "{[ProcessElementValue]}"},
        "initiator": {"key": "initiator", "type": "Principal"},
    }

    def __init__(
        self,
        *,
        process_definition: "_models.ProcessDefinitionSummary",
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subject: Optional[str] = None,
        state: Optional[Union[str, "_models.ProcessState"]] = None,
        element_values: Optional[Dict[str, List["_models.ProcessElementValue"]]] = None,
        initiator: Optional["_models.Principal"] = None,
        **kwargs,
    ):
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id: Process ID.
        :paramtype id: str
        :keyword subject: Process subject.
        :paramtype subject: str
        :keyword state: Process state. Known values are: "RUNNING", "COMPLETED", and "CANCELLED".
        :paramtype state: str or ~kuflow.rest.models.ProcessState
        :keyword process_definition: Required.
        :paramtype process_definition: ~kuflow.rest.models.ProcessDefinitionSummary
        :keyword element_values: Process element values, an ElementValueDocument is not allowed.
        :paramtype element_values: dict[str, list[~kuflow.rest.models.ProcessElementValue]]
        :keyword initiator:
        :paramtype initiator: ~kuflow.rest.models.Principal
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.object_type: str = "PROCESS_PAGE_ITEM"
        self.id = id
        self.subject = subject
        self.state = state
        self.process_definition = process_definition
        self.element_values = element_values
        self.initiator = initiator


class ProcessSaveElementCommand(_serialization.Model):
    """Command to save process element.

    All required parameters must be populated in order to send to Azure.

    :ivar element_definition_code: Required.
    :vartype element_definition_code: str
    :ivar element_values:
    :vartype element_values: list[~kuflow.rest.models.ProcessElementValue]
    """

    _validation = {
        "element_definition_code": {"required": True},
    }

    _attribute_map = {
        "element_definition_code": {"key": "elementDefinitionCode", "type": "str"},
        "element_values": {"key": "elementValues", "type": "[ProcessElementValue]"},
    }

    def __init__(
        self,
        *,
        element_definition_code: str,
        element_values: Optional[List["_models.ProcessElementValue"]] = None,
        **kwargs,
    ):
        """
        :keyword element_definition_code: Required.
        :paramtype element_definition_code: str
        :keyword element_values:
        :paramtype element_values: list[~kuflow.rest.models.ProcessElementValue]
        """
        super().__init__(**kwargs)
        self.element_definition_code = element_definition_code
        self.element_values = element_values


class RelatedProcess(_serialization.Model):
    """RelatedProcess.

    :ivar incoming: Processes whose relationship target is the current process.
    :vartype incoming: list[str]
    :ivar outcoming: Processes to which the current process relates.
    :vartype outcoming: list[str]
    """

    _attribute_map = {
        "incoming": {"key": "incoming", "type": "[str]"},
        "outcoming": {"key": "outcoming", "type": "[str]"},
    }

    def __init__(self, *, incoming: Optional[List[str]] = None, outcoming: Optional[List[str]] = None, **kwargs):
        """
        :keyword incoming: Processes whose relationship target is the current process.
        :paramtype incoming: list[str]
        :keyword outcoming: Processes to which the current process relates.
        :paramtype outcoming: list[str]
        """
        super().__init__(**kwargs)
        self.incoming = incoming
        self.outcoming = outcoming


class Task(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """Task.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Identifies the concrete type of the audited model. Required. Known values
     are: "PROCESS", "PROCESS_PAGE_ITEM", "TASK", "TASK_PAGE_ITEM", and "AUTHENTICATION".
    :vartype object_type: str or ~kuflow.rest.models.AuditedObjectType
    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id:
    :vartype id: str
    :ivar state: Task state. Known values are: "READY", "CLAIMED", "COMPLETED", and "CANCELLED".
    :vartype state: str or ~kuflow.rest.models.TaskState
    :ivar task_definition: In creation task, one of 'id, version or code' is mandatory. Required.
    :vartype task_definition: ~kuflow.rest.models.TaskDefinitionSummary
    :ivar process_id: Required.
    :vartype process_id: str
    :ivar element_values: Task element values, en ElementValueDocument is not allowed.
    :vartype element_values: dict[str, list[~kuflow.rest.models.TaskElementValue]]
    :ivar logs:
    :vartype logs: list[~kuflow.rest.models.Log]
    :ivar owner:
    :vartype owner: ~kuflow.rest.models.Principal
    """

    _validation = {
        "object_type": {"required": True},
        "task_definition": {"required": True},
        "process_id": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "task_definition": {"key": "taskDefinition", "type": "TaskDefinitionSummary"},
        "process_id": {"key": "processId", "type": "str"},
        "element_values": {"key": "elementValues", "type": "{[TaskElementValue]}"},
        "logs": {"key": "logs", "type": "[Log]"},
        "owner": {"key": "owner", "type": "Principal"},
    }

    def __init__(
        self,
        *,
        task_definition: "_models.TaskDefinitionSummary",
        process_id: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        state: Optional[Union[str, "_models.TaskState"]] = None,
        element_values: Optional[Dict[str, List["_models.TaskElementValue"]]] = None,
        logs: Optional[List["_models.Log"]] = None,
        owner: Optional["_models.Principal"] = None,
        **kwargs,
    ):
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id:
        :paramtype id: str
        :keyword state: Task state. Known values are: "READY", "CLAIMED", "COMPLETED", and "CANCELLED".
        :paramtype state: str or ~kuflow.rest.models.TaskState
        :keyword task_definition: In creation task, one of 'id, version or code' is mandatory.
         Required.
        :paramtype task_definition: ~kuflow.rest.models.TaskDefinitionSummary
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword element_values: Task element values, en ElementValueDocument is not allowed.
        :paramtype element_values: dict[str, list[~kuflow.rest.models.TaskElementValue]]
        :keyword logs:
        :paramtype logs: list[~kuflow.rest.models.Log]
        :keyword owner:
        :paramtype owner: ~kuflow.rest.models.Principal
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.object_type: str = "TASK"
        self.id = id
        self.state = state
        self.task_definition = task_definition
        self.process_id = process_id
        self.element_values = element_values
        self.logs = logs
        self.owner = owner


class TaskAssignCommand(_serialization.Model):
    """Command to assign task, only one option is required.

    :ivar principal_id:
    :vartype principal_id: str
    :ivar email:
    :vartype email: str
    """

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(self, *, principal_id: Optional[str] = None, email: Optional[str] = None, **kwargs):
        """
        :keyword principal_id:
        :paramtype principal_id: str
        :keyword email:
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.email = email


class TaskDefinitionSummary(_serialization.Model):
    """In creation task, one of 'id, version or code' is mandatory.

    :ivar id:
    :vartype id: str
    :ivar version:
    :vartype version: str
    :ivar code:
    :vartype code: str
    :ivar name:
    :vartype name: str
    """

    _validation = {
        "name": {"max_length": 50, "min_length": 1},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        version: Optional[str] = None,
        code: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword version:
        :paramtype version: str
        :keyword code:
        :paramtype code: str
        :keyword name:
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.version = version
        self.code = code
        self.name = name


class TaskDeleteElementCommand(_serialization.Model):
    """TaskDeleteElementCommand.

    All required parameters must be populated in order to send to Azure.

    :ivar element_definition_code: Code of task element to delete. Required.
    :vartype element_definition_code: str
    """

    _validation = {
        "element_definition_code": {"required": True},
    }

    _attribute_map = {
        "element_definition_code": {"key": "elementDefinitionCode", "type": "str"},
    }

    def __init__(self, *, element_definition_code: str, **kwargs):
        """
        :keyword element_definition_code: Code of task element to delete. Required.
        :paramtype element_definition_code: str
        """
        super().__init__(**kwargs)
        self.element_definition_code = element_definition_code


class TaskDeleteElementValueDocumentCommand(_serialization.Model):
    """TaskDeleteElementValueDocumentCommand.

    All required parameters must be populated in order to send to Azure.

    :ivar document_id: Document ID to delete. Required.
    :vartype document_id: str
    """

    _validation = {
        "document_id": {"required": True},
    }

    _attribute_map = {
        "document_id": {"key": "documentId", "type": "str"},
    }

    def __init__(self, *, document_id: str, **kwargs):
        """
        :keyword document_id: Document ID to delete. Required.
        :paramtype document_id: str
        """
        super().__init__(**kwargs)
        self.document_id = document_id


class TaskElementValue(_serialization.Model):
    """TaskElementValue.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    TaskElementValueDocument, TaskElementValueNumber, TaskElementValueObject,
    TaskElementValuePrincipal, TaskElementValueString

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Required. Known values are: "STRING", "NUMBER", "OBJECT", "DOCUMENT", and
     "PRINCIPAL".
    :vartype type: str or ~kuflow.rest.models.TaskElementValueType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {
        "type": {
            "DOCUMENT": "TaskElementValueDocument",
            "NUMBER": "TaskElementValueNumber",
            "OBJECT": "TaskElementValueObject",
            "PRINCIPAL": "TaskElementValuePrincipal",
            "STRING": "TaskElementValueString",
        }
    }

    def __init__(self, *, valid: bool = True, **kwargs):
        """
        :keyword valid:
        :paramtype valid: bool
        """
        super().__init__(**kwargs)
        self.valid = valid
        self.type: Optional[str] = None


class TaskElementValueDocument(TaskElementValue):
    """TaskElementValueDocument.

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Required. Known values are: "STRING", "NUMBER", "OBJECT", "DOCUMENT", and
     "PRINCIPAL".
    :vartype type: str or ~kuflow.rest.models.TaskElementValueType
    :ivar value:
    :vartype value: ~kuflow.rest.models.TaskElementValueDocumentItem
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "TaskElementValueDocumentItem"},
    }

    def __init__(self, *, valid: bool = True, value: Optional["_models.TaskElementValueDocumentItem"] = None, **kwargs):
        """
        :keyword valid:
        :paramtype valid: bool
        :keyword value:
        :paramtype value: ~kuflow.rest.models.TaskElementValueDocumentItem
        """
        super().__init__(valid=valid, **kwargs)
        self.type: str = "DOCUMENT"
        self.value = value


class TaskElementValueDocumentItem(_serialization.Model):
    """TaskElementValueDocumentItem.

    :ivar id:
    :vartype id: str
    :ivar uri:
    :vartype uri: str
    :ivar name:
    :vartype name: str
    :ivar content_path:
    :vartype content_path: str
    :ivar content_type:
    :vartype content_type: str
    :ivar content_length:
    :vartype content_length: int
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "content_path": {"key": "contentPath", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "content_length": {"key": "contentLength", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        uri: Optional[str] = None,
        name: Optional[str] = None,
        content_path: Optional[str] = None,
        content_type: Optional[str] = None,
        content_length: Optional[int] = None,
        **kwargs,
    ):
        """
        :keyword id:
        :paramtype id: str
        :keyword uri:
        :paramtype uri: str
        :keyword name:
        :paramtype name: str
        :keyword content_path:
        :paramtype content_path: str
        :keyword content_type:
        :paramtype content_type: str
        :keyword content_length:
        :paramtype content_length: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.uri = uri
        self.name = name
        self.content_path = content_path
        self.content_type = content_type
        self.content_length = content_length


class TaskElementValueNumber(TaskElementValue):
    """TaskElementValueNumber.

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Required. Known values are: "STRING", "NUMBER", "OBJECT", "DOCUMENT", and
     "PRINCIPAL".
    :vartype type: str or ~kuflow.rest.models.TaskElementValueType
    :ivar value:
    :vartype value: float
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, *, valid: bool = True, value: Optional[float] = None, **kwargs):
        """
        :keyword valid:
        :paramtype valid: bool
        :keyword value:
        :paramtype value: float
        """
        super().__init__(valid=valid, **kwargs)
        self.type: str = "NUMBER"
        self.value = value


class TaskElementValueObject(TaskElementValue):
    """TaskElementValueObject.

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Required. Known values are: "STRING", "NUMBER", "OBJECT", "DOCUMENT", and
     "PRINCIPAL".
    :vartype type: str or ~kuflow.rest.models.TaskElementValueType
    :ivar value: Dictionary of :code:`<any>`.
    :vartype value: dict[str, any]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "{object}"},
    }

    def __init__(self, *, valid: bool = True, value: Optional[Dict[str, Any]] = None, **kwargs):
        """
        :keyword valid:
        :paramtype valid: bool
        :keyword value: Dictionary of :code:`<any>`.
        :paramtype value: dict[str, any]
        """
        super().__init__(valid=valid, **kwargs)
        self.type: str = "OBJECT"
        self.value = value


class TaskElementValuePrincipal(TaskElementValue):
    """TaskElementValuePrincipal.

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Required. Known values are: "STRING", "NUMBER", "OBJECT", "DOCUMENT", and
     "PRINCIPAL".
    :vartype type: str or ~kuflow.rest.models.TaskElementValueType
    :ivar value:
    :vartype value: ~kuflow.rest.models.TaskElementValuePrincipalItem
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "TaskElementValuePrincipalItem"},
    }

    def __init__(
        self, *, valid: bool = True, value: Optional["_models.TaskElementValuePrincipalItem"] = None, **kwargs
    ):
        """
        :keyword valid:
        :paramtype valid: bool
        :keyword value:
        :paramtype value: ~kuflow.rest.models.TaskElementValuePrincipalItem
        """
        super().__init__(valid=valid, **kwargs)
        self.type: str = "PRINCIPAL"
        self.value = value


class TaskElementValuePrincipalItem(_serialization.Model):
    """TaskElementValuePrincipalItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar type: Required. Known values are: "USER", "APPLICATION", and "SYSTEM".
    :vartype type: str or ~kuflow.rest.models.PrincipalType
    :ivar name:
    :vartype name: str
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: Union[str, "_models.PrincipalType"],
        name: Optional[str] = None,
        **kwargs,
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword type: Required. Known values are: "USER", "APPLICATION", and "SYSTEM".
        :paramtype type: str or ~kuflow.rest.models.PrincipalType
        :keyword name:
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name


class TaskElementValueString(TaskElementValue):
    """TaskElementValueString.

    All required parameters must be populated in order to send to Azure.

    :ivar valid:
    :vartype valid: bool
    :ivar type: Required. Known values are: "STRING", "NUMBER", "OBJECT", "DOCUMENT", and
     "PRINCIPAL".
    :vartype type: str or ~kuflow.rest.models.TaskElementValueType
    :ivar value:
    :vartype value: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "valid": {"key": "valid", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, valid: bool = True, value: Optional[str] = None, **kwargs):
        """
        :keyword valid:
        :paramtype valid: bool
        :keyword value:
        :paramtype value: str
        """
        super().__init__(valid=valid, **kwargs)
        self.type: str = "STRING"
        self.value = value


class TaskPage(Page):
    """TaskPage.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Paged Model types. Required. Known values are: "PRINCIPAL_PAGE",
     "PROCESS_PAGE", and "TASK_PAGE".
    :vartype object_type: str or ~kuflow.rest.models.PagedObjectType
    :ivar metadata: Required.
    :vartype metadata: ~kuflow.rest.models.PageMetadata
    :ivar content: Required.
    :vartype content: list[~kuflow.rest.models.TaskPageItem]
    """

    _validation = {
        "object_type": {"required": True},
        "metadata": {"required": True},
        "content": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "metadata": {"key": "metadata", "type": "PageMetadata"},
        "content": {"key": "content", "type": "[TaskPageItem]"},
    }

    def __init__(self, *, metadata: "_models.PageMetadata", content: List["_models.TaskPageItem"], **kwargs):
        """
        :keyword metadata: Required.
        :paramtype metadata: ~kuflow.rest.models.PageMetadata
        :keyword content: Required.
        :paramtype content: list[~kuflow.rest.models.TaskPageItem]
        """
        super().__init__(metadata=metadata, **kwargs)
        self.object_type: str = "TASK_PAGE"
        self.content = content


class TaskPageItem(AbstractAudited):  # pylint: disable=too-many-instance-attributes
    """TaskPageItem.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: Identifies the concrete type of the audited model. Required. Known values
     are: "PROCESS", "PROCESS_PAGE_ITEM", "TASK", "TASK_PAGE_ITEM", and "AUTHENTICATION".
    :vartype object_type: str or ~kuflow.rest.models.AuditedObjectType
    :ivar created_by: Who create this model.
    :vartype created_by: str
    :ivar created_at: When this model was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: Who was last update this model.
    :vartype last_modified_by: str
    :ivar last_modified_at: When this model type was last updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar id:
    :vartype id: str
    :ivar state: Task state. Known values are: "READY", "CLAIMED", "COMPLETED", and "CANCELLED".
    :vartype state: str or ~kuflow.rest.models.TaskState
    :ivar task_definition: In creation task, one of 'id, version or code' is mandatory. Required.
    :vartype task_definition: ~kuflow.rest.models.TaskDefinitionSummary
    :ivar process_id: Required.
    :vartype process_id: str
    :ivar element_values: Task element values, en ElementValueDocument is not allowed.
    :vartype element_values: dict[str, list[~kuflow.rest.models.TaskElementValue]]
    :ivar owner:
    :vartype owner: ~kuflow.rest.models.Principal
    """

    _validation = {
        "object_type": {"required": True},
        "task_definition": {"required": True},
        "process_id": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "created_by": {"key": "createdBy", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "task_definition": {"key": "taskDefinition", "type": "TaskDefinitionSummary"},
        "process_id": {"key": "processId", "type": "str"},
        "element_values": {"key": "elementValues", "type": "{[TaskElementValue]}"},
        "owner": {"key": "owner", "type": "Principal"},
    }

    def __init__(
        self,
        *,
        task_definition: "_models.TaskDefinitionSummary",
        process_id: str,
        created_by: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        state: Optional[Union[str, "_models.TaskState"]] = None,
        element_values: Optional[Dict[str, List["_models.TaskElementValue"]]] = None,
        owner: Optional["_models.Principal"] = None,
        **kwargs,
    ):
        """
        :keyword created_by: Who create this model.
        :paramtype created_by: str
        :keyword created_at: When this model was created.
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: Who was last update this model.
        :paramtype last_modified_by: str
        :keyword last_modified_at: When this model type was last updated.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword id:
        :paramtype id: str
        :keyword state: Task state. Known values are: "READY", "CLAIMED", "COMPLETED", and "CANCELLED".
        :paramtype state: str or ~kuflow.rest.models.TaskState
        :keyword task_definition: In creation task, one of 'id, version or code' is mandatory.
         Required.
        :paramtype task_definition: ~kuflow.rest.models.TaskDefinitionSummary
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword element_values: Task element values, en ElementValueDocument is not allowed.
        :paramtype element_values: dict[str, list[~kuflow.rest.models.TaskElementValue]]
        :keyword owner:
        :paramtype owner: ~kuflow.rest.models.Principal
        """
        super().__init__(
            created_by=created_by,
            created_at=created_at,
            last_modified_by=last_modified_by,
            last_modified_at=last_modified_at,
            **kwargs,
        )
        self.object_type: str = "TASK_PAGE_ITEM"
        self.id = id
        self.state = state
        self.task_definition = task_definition
        self.process_id = process_id
        self.element_values = element_values
        self.owner = owner


class TaskSaveElementCommand(_serialization.Model):
    """TaskSaveElementCommand.

    All required parameters must be populated in order to send to Azure.

    :ivar element_definition_code: Required.
    :vartype element_definition_code: str
    :ivar element_values:
    :vartype element_values: list[~kuflow.rest.models.TaskElementValue]
    """

    _validation = {
        "element_definition_code": {"required": True},
    }

    _attribute_map = {
        "element_definition_code": {"key": "elementDefinitionCode", "type": "str"},
        "element_values": {"key": "elementValues", "type": "[TaskElementValue]"},
    }

    def __init__(
        self,
        *,
        element_definition_code: str,
        element_values: Optional[List["_models.TaskElementValue"]] = None,
        **kwargs,
    ):
        """
        :keyword element_definition_code: Required.
        :paramtype element_definition_code: str
        :keyword element_values:
        :paramtype element_values: list[~kuflow.rest.models.TaskElementValue]
        """
        super().__init__(**kwargs)
        self.element_definition_code = element_definition_code
        self.element_values = element_values


class WebhookEvent(_serialization.Model):
    """WebhookEvent.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WebhookEventProcessStateChanged, WebhookEventTaskStateChanged

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar type: Type of the Event. Required. Known values are: "PROCESS.STATE_CHANGED" and
     "TASK.STATE_CHANGED".
    :vartype type: str or ~kuflow.rest.models.WebhookType
    :ivar timestamp: Required.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "timestamp": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    _subtype_map = {
        "type": {
            "PROCESS.STATE_CHANGED": "WebhookEventProcessStateChanged",
            "TASK.STATE_CHANGED": "WebhookEventTaskStateChanged",
        }
    }

    def __init__(self, *, id: str, timestamp: datetime.datetime, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword timestamp: Required.
        :paramtype timestamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.id = id
        self.type: Optional[str] = None
        self.timestamp = timestamp


class WebhookEventProcessStateChanged(WebhookEvent):
    """Process Events.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar type: Type of the Event. Required. Known values are: "PROCESS.STATE_CHANGED" and
     "TASK.STATE_CHANGED".
    :vartype type: str or ~kuflow.rest.models.WebhookType
    :ivar timestamp: Required.
    :vartype timestamp: ~datetime.datetime
    :ivar data: Required.
    :vartype data: ~kuflow.rest.models.WebhookEventProcessStateChangedData
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "timestamp": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "data": {"key": "data", "type": "WebhookEventProcessStateChangedData"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        timestamp: datetime.datetime,
        data: "_models.WebhookEventProcessStateChangedData",
        **kwargs,
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword timestamp: Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword data: Required.
        :paramtype data: ~kuflow.rest.models.WebhookEventProcessStateChangedData
        """
        super().__init__(id=id, timestamp=timestamp, **kwargs)
        self.type: str = "PROCESS.STATE_CHANGED"
        self.data = data


class WebhookEventProcessStateChangedData(_serialization.Model):
    """WebhookEventProcessStateChangedData.

    All required parameters must be populated in order to send to Azure.

    :ivar process_id: Required.
    :vartype process_id: str
    :ivar process_state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
     "CANCELLED".
    :vartype process_state: str or ~kuflow.rest.models.ProcessState
    """

    _validation = {
        "process_id": {"required": True},
        "process_state": {"required": True},
    }

    _attribute_map = {
        "process_id": {"key": "processId", "type": "str"},
        "process_state": {"key": "processState", "type": "str"},
    }

    def __init__(self, *, process_id: str, process_state: Union[str, "_models.ProcessState"], **kwargs):
        """
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword process_state: Process state. Required. Known values are: "RUNNING", "COMPLETED", and
         "CANCELLED".
        :paramtype process_state: str or ~kuflow.rest.models.ProcessState
        """
        super().__init__(**kwargs)
        self.process_id = process_id
        self.process_state = process_state


class WebhookEventTaskStateChanged(WebhookEvent):
    """Process Events.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required.
    :vartype id: str
    :ivar type: Type of the Event. Required. Known values are: "PROCESS.STATE_CHANGED" and
     "TASK.STATE_CHANGED".
    :vartype type: str or ~kuflow.rest.models.WebhookType
    :ivar timestamp: Required.
    :vartype timestamp: ~datetime.datetime
    :ivar data: Required.
    :vartype data: ~kuflow.rest.models.WebhookEventTaskStateChangedData
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
        "timestamp": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "data": {"key": "data", "type": "WebhookEventTaskStateChangedData"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        timestamp: datetime.datetime,
        data: "_models.WebhookEventTaskStateChangedData",
        **kwargs,
    ):
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword timestamp: Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword data: Required.
        :paramtype data: ~kuflow.rest.models.WebhookEventTaskStateChangedData
        """
        super().__init__(id=id, timestamp=timestamp, **kwargs)
        self.type: str = "TASK.STATE_CHANGED"
        self.data = data


class WebhookEventTaskStateChangedData(_serialization.Model):
    """WebhookEventTaskStateChangedData.

    All required parameters must be populated in order to send to Azure.

    :ivar process_id: Required.
    :vartype process_id: str
    :ivar task_id: Required.
    :vartype task_id: str
    :ivar task_code: Required.
    :vartype task_code: str
    :ivar task_state: Task state. Required. Known values are: "READY", "CLAIMED", "COMPLETED", and
     "CANCELLED".
    :vartype task_state: str or ~kuflow.rest.models.TaskState
    """

    _validation = {
        "process_id": {"required": True},
        "task_id": {"required": True},
        "task_code": {"required": True},
        "task_state": {"required": True},
    }

    _attribute_map = {
        "process_id": {"key": "processId", "type": "str"},
        "task_id": {"key": "taskId", "type": "str"},
        "task_code": {"key": "taskCode", "type": "str"},
        "task_state": {"key": "taskState", "type": "str"},
    }

    def __init__(
        self, *, process_id: str, task_id: str, task_code: str, task_state: Union[str, "_models.TaskState"], **kwargs
    ):
        """
        :keyword process_id: Required.
        :paramtype process_id: str
        :keyword task_id: Required.
        :paramtype task_id: str
        :keyword task_code: Required.
        :paramtype task_code: str
        :keyword task_state: Task state. Required. Known values are: "READY", "CLAIMED", "COMPLETED",
         and "CANCELLED".
        :paramtype task_state: str or ~kuflow.rest.models.TaskState
        """
        super().__init__(**kwargs)
        self.process_id = process_id
        self.task_id = task_id
        self.task_code = task_code
        self.task_state = task_state
