# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
#
# MIT License
#
# Copyright (c) 2022 KuFlow
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
#
# --------------------------------------------------------------------------
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
#
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, Iterator, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import _format_url_section

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_find_tasks_request(
    *,
    size: int = 25,
    page: int = 0,
    sort: Optional[List[str]] = None,
    process_id: Optional[List[str]] = None,
    state: Optional[List[Union[str, _models.TaskState]]] = None,
    task_definition_code: Optional[List[str]] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks"

    # Construct parameters
    if size is not None:
        _params["size"] = _SERIALIZER.query("size", size, "int", maximum=1000, minimum=0)
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=0)
    if sort is not None:
        _params["sort"] = [_SERIALIZER.query("sort", q, "str") if q is not None else "" for q in sort]
    if process_id is not None:
        _params["processId"] = [_SERIALIZER.query("process_id", q, "str") if q is not None else "" for q in process_id]
    if state is not None:
        _params["state"] = [_SERIALIZER.query("state", q, "str") if q is not None else "" for q in state]
    if task_definition_code is not None:
        _params["taskDefinitionCode"] = [
            _SERIALIZER.query("task_definition_code", q, "str") if q is not None else "" for q in task_definition_code
        ]

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_task_request(*, activity_token: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks"

    # Construct parameters
    if activity_token is not None:
        _params["activityToken"] = _SERIALIZER.query("activity_token", activity_token, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_retrieve_task_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_actions_task_claim_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/claim"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_actions_task_assign_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/assign"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_actions_task_save_element_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/save-element"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_actions_task_save_element_value_document_request(
    id: str,
    *,
    file_content_type: str,
    file_name: str,
    element_definition_code: str,
    content: IO,
    element_value_id: Optional[str] = None,
    element_value_valid: bool = True,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/save-element-value-document"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["fileContentType"] = _SERIALIZER.query("file_content_type", file_content_type, "str")
    _params["fileName"] = _SERIALIZER.query("file_name", file_name, "str")
    _params["elementDefinitionCode"] = _SERIALIZER.query("element_definition_code", element_definition_code, "str")
    if element_value_id is not None:
        _params["elementValueId"] = _SERIALIZER.query("element_value_id", element_value_id, "str")
    if element_value_valid is not None:
        _params["elementValueValid"] = _SERIALIZER.query("element_value_valid", element_value_valid, "bool")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, content=content, **kwargs)


def build_actions_task_delete_element_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/delete-element"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_actions_task_delete_element_value_document_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/delete-element-value-document"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_actions_task_download_element_value_document_request(
    id: str, *, document_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/octet-stream, application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/download-element-value-document"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["documentId"] = _SERIALIZER.query("document_id", document_id, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_actions_task_download_element_value_rendered_request(
    id: str, *, element_definition_code: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/pdf, application/zip, application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/download-element-value-form-rendered"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["elementDefinitionCode"] = _SERIALIZER.query("element_definition_code", element_definition_code, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_actions_task_complete_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/complete"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_actions_task_append_log_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/tasks/{id}/~actions/append-log"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


class TaskOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~kuflow.rest.KuFlowRestClient`'s
        :attr:`task` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def find_tasks(
        self,
        *,
        size: int = 25,
        page: int = 0,
        sort: Optional[List[str]] = None,
        process_id: Optional[List[str]] = None,
        state: Optional[List[Union[str, _models.TaskState]]] = None,
        task_definition_code: Optional[List[str]] = None,
        **kwargs: Any,
    ) -> _models.TaskPage:
        """Find all accessible Tasks.

        List all Tasks that have been created and the credentials has access.

        Available sort query values: id, createdAt, lastModifiedAt, claimedAt, completedAt,
        cancelledAt.

        :keyword size: The number of records returned within a single API call. Default value is 25.
        :paramtype size: int
        :keyword page: The page number of the current page in the returned records, 0 is the first
         page. Default value is 0.
        :paramtype page: int
        :keyword sort: Sorting criteria in the format: property{,asc|desc}. Example: createdAt,desc

         Default sort order is ascending. Multiple sort criteria are supported.

         Please refer to the method description for supported properties. Default value is None.
        :paramtype sort: list[str]
        :keyword process_id: Filter by an array of process ids. Default value is None.
        :paramtype process_id: list[str]
        :keyword state: Filter by an array of task states. Default value is None.
        :paramtype state: list[str or ~kuflow.rest.models.TaskState]
        :keyword task_definition_code: Filter by an array of task definition codes. Default value is
         None.
        :paramtype task_definition_code: list[str]
        :return: TaskPage
        :rtype: ~kuflow.rest.models.TaskPage
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TaskPage] = kwargs.pop("cls", None)

        request = build_find_tasks_request(
            size=size,
            page=page,
            sort=sort,
            process_id=process_id,
            state=state,
            task_definition_code=task_definition_code,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("TaskPage", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def create_task(
        self,
        task: _models.Task,
        *,
        activity_token: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.Task:
        """Create a new Task in the selected Process.

        Create a Task and optionally fill its elements. We can fill in any type of element except
        documents.

        If you want to add document type elements, you can pass a reference to an existing document
        type element indicating its 'uri'. This will copy that document into the element. In case you
        want to add a new document, please use the corresponding API method.

        If you want that the task created is claimed you can a valid owner using the following options:


        * If you know the ``principal ID`` you can assign it to ``owner.id``
        * If you know the ``user ID`` you can assign it to ``owner.user.id``
        * If you know the ``user email`` you can assign it to ``owner.user.email``
        * If you know the ``application ID`` you can assign it to ``owner.application.id``

        If you want the method to be idempotent, please specify the ``id`` field in the request body.

        :param task: Task to be created. Required.
        :type task: ~kuflow.rest.models.Task
        :keyword activity_token: When create a Kuflow Task backed with a Temporal.io servers, this
         value is required and must be set with the context task token of Temporal.io activity. Default
         value is None.
        :paramtype activity_token: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_task(
        self, task: IO, *, activity_token: Optional[str] = None, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Create a new Task in the selected Process.

        Create a Task and optionally fill its elements. We can fill in any type of element except
        documents.

        If you want to add document type elements, you can pass a reference to an existing document
        type element indicating its 'uri'. This will copy that document into the element. In case you
        want to add a new document, please use the corresponding API method.

        If you want that the task created is claimed you can a valid owner using the following options:


        * If you know the ``principal ID`` you can assign it to ``owner.id``
        * If you know the ``user ID`` you can assign it to ``owner.user.id``
        * If you know the ``user email`` you can assign it to ``owner.user.email``
        * If you know the ``application ID`` you can assign it to ``owner.application.id``

        If you want the method to be idempotent, please specify the ``id`` field in the request body.

        :param task: Task to be created. Required.
        :type task: IO
        :keyword activity_token: When create a Kuflow Task backed with a Temporal.io servers, this
         value is required and must be set with the context task token of Temporal.io activity. Default
         value is None.
        :paramtype activity_token: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_task(
        self, task: Union[_models.Task, IO], *, activity_token: Optional[str] = None, **kwargs: Any
    ) -> _models.Task:
        """Create a new Task in the selected Process.

        Create a Task and optionally fill its elements. We can fill in any type of element except
        documents.

        If you want to add document type elements, you can pass a reference to an existing document
        type element indicating its 'uri'. This will copy that document into the element. In case you
        want to add a new document, please use the corresponding API method.

        If you want that the task created is claimed you can a valid owner using the following options:


        * If you know the ``principal ID`` you can assign it to ``owner.id``
        * If you know the ``user ID`` you can assign it to ``owner.user.id``
        * If you know the ``user email`` you can assign it to ``owner.user.email``
        * If you know the ``application ID`` you can assign it to ``owner.application.id``

        If you want the method to be idempotent, please specify the ``id`` field in the request body.

        :param task: Task to be created. Is either a model type or a IO type. Required.
        :type task: ~kuflow.rest.models.Task or IO
        :keyword activity_token: When create a Kuflow Task backed with a Temporal.io servers, this
         value is required and must be set with the context task token of Temporal.io activity. Default
         value is None.
        :paramtype activity_token: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(task, (IO, bytes)):
            _content = task
        else:
            _json = self._serialize.body(task, "Task")

        request = build_create_task_request(
            activity_token=activity_token,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Task", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def retrieve_task(self, id: str, **kwargs: Any) -> _models.Task:
        """Get a task given it ID.

        Allow to get a task by ID.

        :param id: The resource ID. Required.
        :type id: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        request = build_retrieve_task_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def actions_task_claim(self, id: str, **kwargs: Any) -> _models.Task:
        """Claim a task.

        Allow to claim a task.

        :param id: The resource ID. Required.
        :type id: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        request = build_actions_task_claim_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def actions_task_assign(
        self, id: str, command: _models.TaskAssignCommand, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Assign a task.

        Allow to assign a task to a user or application. Only one option will be necessary.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to change the task owner. Required.
        :type command: ~kuflow.rest.models.TaskAssignCommand
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def actions_task_assign(
        self, id: str, command: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Assign a task.

        Allow to assign a task to a user or application. Only one option will be necessary.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to change the task owner. Required.
        :type command: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def actions_task_assign(
        self, id: str, command: Union[_models.TaskAssignCommand, IO], **kwargs: Any
    ) -> _models.Task:
        """Assign a task.

        Allow to assign a task to a user or application. Only one option will be necessary.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to change the task owner. Is either a model type or a IO type.
         Required.
        :type command: ~kuflow.rest.models.TaskAssignCommand or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(command, (IO, bytes)):
            _content = command
        else:
            _json = self._serialize.body(command, "TaskAssignCommand")

        request = build_actions_task_assign_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def actions_task_save_element(
        self, id: str, command: _models.TaskSaveElementCommand, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Save an element.

        Allow to save an element i.e., a field, a decision, a form, a principal or document.

        In the case of document type elements, this method only allows references to be made to other
        existing document type elements for the purpose of copying that file into the element. To do
        this you need to pass a reference to the document using the 'uri' attribute. In case you want
        to add a new document, please use the corresponding API method. If values already exist for the
        provided element code, it replaces them with the new ones, otherwise it creates them. The
        values of the previous elements that no longer exist will be deleted. To remove an element, use
        the appropriate API method.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to save an element. Required.
        :type command: ~kuflow.rest.models.TaskSaveElementCommand
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def actions_task_save_element(
        self, id: str, command: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Save an element.

        Allow to save an element i.e., a field, a decision, a form, a principal or document.

        In the case of document type elements, this method only allows references to be made to other
        existing document type elements for the purpose of copying that file into the element. To do
        this you need to pass a reference to the document using the 'uri' attribute. In case you want
        to add a new document, please use the corresponding API method. If values already exist for the
        provided element code, it replaces them with the new ones, otherwise it creates them. The
        values of the previous elements that no longer exist will be deleted. To remove an element, use
        the appropriate API method.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to save an element. Required.
        :type command: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def actions_task_save_element(
        self, id: str, command: Union[_models.TaskSaveElementCommand, IO], **kwargs: Any
    ) -> _models.Task:
        """Save an element.

        Allow to save an element i.e., a field, a decision, a form, a principal or document.

        In the case of document type elements, this method only allows references to be made to other
        existing document type elements for the purpose of copying that file into the element. To do
        this you need to pass a reference to the document using the 'uri' attribute. In case you want
        to add a new document, please use the corresponding API method. If values already exist for the
        provided element code, it replaces them with the new ones, otherwise it creates them. The
        values of the previous elements that no longer exist will be deleted. To remove an element, use
        the appropriate API method.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to save an element. Is either a model type or a IO type. Required.
        :type command: ~kuflow.rest.models.TaskSaveElementCommand or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(command, (IO, bytes)):
            _content = command
        else:
            _json = self._serialize.body(command, "TaskSaveElementCommand")

        request = build_actions_task_save_element_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def actions_task_save_element_value_document(
        self,
        id: str,
        file: IO,
        *,
        file_content_type: str,
        file_name: str,
        element_definition_code: str,
        element_value_id: Optional[str] = None,
        element_value_valid: bool = True,
        **kwargs: Any,
    ) -> _models.Task:
        """Save an element document.

        Allow to save an element document uploading the content.

        If it is a multiple element, and the ID referenced in the body does not exist or is empty, the
        document will be added to the element. If the element already exists (the ID referenced in the
        body corresponds to an existing one), it updates it.

        :param id: The resource ID. Required.
        :type id: str
        :param file: Command to save a document element value. Required.
        :type file: IO
        :keyword file_content_type: Document content type. Required.
        :paramtype file_content_type: str
        :keyword file_name: Document name. Required.
        :paramtype file_name: str
        :keyword element_definition_code: Element Definition Code. Required.
        :paramtype element_definition_code: str
        :keyword element_value_id: Element Value ID. Default value is None.
        :paramtype element_value_id: str
        :keyword element_value_valid: Element Value ID. Default value is True.
        :paramtype element_value_valid: bool
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/octet-stream"))
        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        _content = file

        request = build_actions_task_save_element_value_document_request(
            id=id,
            file_content_type=file_content_type,
            file_name=file_name,
            element_definition_code=element_definition_code,
            element_value_id=element_value_id,
            element_value_valid=element_value_valid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def actions_task_delete_element(
        self,
        id: str,
        command: _models.TaskDeleteElementCommand,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.Task:
        """Delete an element by code.

        Allow to delete task element by specifying the item definition code.

        Remove all the element values.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to delete an element. Required.
        :type command: ~kuflow.rest.models.TaskDeleteElementCommand
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def actions_task_delete_element(
        self, id: str, command: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Delete an element by code.

        Allow to delete task element by specifying the item definition code.

        Remove all the element values.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to delete an element. Required.
        :type command: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def actions_task_delete_element(
        self, id: str, command: Union[_models.TaskDeleteElementCommand, IO], **kwargs: Any
    ) -> _models.Task:
        """Delete an element by code.

        Allow to delete task element by specifying the item definition code.

        Remove all the element values.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to delete an element. Is either a model type or a IO type. Required.
        :type command: ~kuflow.rest.models.TaskDeleteElementCommand or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(command, (IO, bytes)):
            _content = command
        else:
            _json = self._serialize.body(command, "TaskDeleteElementCommand")

        request = build_actions_task_delete_element_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def actions_task_delete_element_value_document(
        self,
        id: str,
        command: _models.TaskDeleteElementValueDocumentCommand,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.Task:
        """Delete an element document value.

        Allow to delete a specific document from an element of document type using its id.

        Note: If it is a multiple item, it will only delete the specified document. If it is a single
        element, in addition to the document, it will also delete the element.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to delete a document elemente value. Required.
        :type command: ~kuflow.rest.models.TaskDeleteElementValueDocumentCommand
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def actions_task_delete_element_value_document(
        self, id: str, command: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Delete an element document value.

        Allow to delete a specific document from an element of document type using its id.

        Note: If it is a multiple item, it will only delete the specified document. If it is a single
        element, in addition to the document, it will also delete the element.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to delete a document elemente value. Required.
        :type command: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def actions_task_delete_element_value_document(
        self, id: str, command: Union[_models.TaskDeleteElementValueDocumentCommand, IO], **kwargs: Any
    ) -> _models.Task:
        """Delete an element document value.

        Allow to delete a specific document from an element of document type using its id.

        Note: If it is a multiple item, it will only delete the specified document. If it is a single
        element, in addition to the document, it will also delete the element.

        :param id: The resource ID. Required.
        :type id: str
        :param command: Command to delete a document elemente value. Is either a model type or a IO
         type. Required.
        :type command: ~kuflow.rest.models.TaskDeleteElementValueDocumentCommand or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(command, (IO, bytes)):
            _content = command
        else:
            _json = self._serialize.body(command, "TaskDeleteElementValueDocumentCommand")

        request = build_actions_task_delete_element_value_document_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def actions_task_download_element_value_document(
        self, id: str, *, document_id: str, **kwargs: Any
    ) -> Iterator[bytes]:
        """Download document.

        Given a task, download a document from an element of document type.

        :param id: The resource ID. Required.
        :type id: str
        :keyword document_id: Document ID to download. Required.
        :paramtype document_id: str
        :return: Iterator of the response bytes
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        request = build_actions_task_download_element_value_document_request(
            id=id,
            document_id=document_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=True, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def actions_task_download_element_value_rendered(
        self, id: str, *, element_definition_code: str, **kwargs: Any
    ) -> Iterator[bytes]:
        """Download a Form rendered as PDF or Zip of PDFs (when the element is multiple).

        Given a task, generate a PDF from a Form type element with the data filled in, if any. If there
        are multiple form values, they are packed into a ZIP.

        Important!: To use this feature, please contact to kuflow@kuflow.com.

        :param id: The resource ID. Required.
        :type id: str
        :keyword element_definition_code: Element definition code of a Form Element to download.
         Required.
        :paramtype element_definition_code: str
        :return: Iterator of the response bytes
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        request = build_actions_task_download_element_value_rendered_request(
            id=id,
            element_definition_code=element_definition_code,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=True, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def actions_task_complete(self, id: str, **kwargs: Any) -> _models.Task:
        """Complete a task.

        Allow to complete a claimed task by the principal.

        :param id: The resource ID. Required.
        :type id: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        request = build_actions_task_complete_request(
            id=id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def actions_task_append_log(
        self, id: str, log: _models.Log, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Append a log to the task.

        A log entry is added to the task. If the number of log entries is reached, the oldest log entry
        is removed.

        :param id: The resource ID. Required.
        :type id: str
        :param log: Log to be created. Required.
        :type log: ~kuflow.rest.models.Log
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def actions_task_append_log(
        self, id: str, log: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.Task:
        """Append a log to the task.

        A log entry is added to the task. If the number of log entries is reached, the oldest log entry
        is removed.

        :param id: The resource ID. Required.
        :type id: str
        :param log: Log to be created. Required.
        :type log: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def actions_task_append_log(self, id: str, log: Union[_models.Log, IO], **kwargs: Any) -> _models.Task:
        """Append a log to the task.

        A log entry is added to the task. If the number of log entries is reached, the oldest log entry
        is removed.

        :param id: The resource ID. Required.
        :type id: str
        :param log: Log to be created. Is either a model type or a IO type. Required.
        :type log: ~kuflow.rest.models.Log or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: Task
        :rtype: ~kuflow.rest.models.Task
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Task] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(log, (IO, bytes)):
            _content = log
        else:
            _json = self._serialize.body(log, "Log")

        request = build_actions_task_append_log_request(
            id=id,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("Task", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
