from granola._version import get_versions
from granola.breakfast_cereal import Cereal, PortNotOpenError
from granola.command_readers import (
    BaseCommandReaders,
    CannedQueries,
    GettersAndSetters,
    RandomizeResponse,
    SerialCmds,
)
from granola.enums import HookTypes, SetRelationship
from granola.hooks.base_hook import BaseHook
from granola.hooks.hooks import (
    ApproachHook,
    LoopCannedQueries,
    StickCannedQueries,
    register_hook,
)
from granola.main import MockSerial  # deprecated
from granola.serial_sniffer import SerialSniffer

__version__ = get_versions()["version"]
del get_versions


__all__ = [
    "__version__",
    "RandomizeResponse",
    "BaseCommandReaders",
    "SerialCmds",
    "Cereal",
    "MockSerial",  # deprecated
    "PortNotOpenError",
    "GettersAndSetters",
    "CannedQueries",
    "SerialSniffer",
    "BaseHook",
    "ApproachHook",
    "LoopCannedQueries",
    "StickCannedQueries",
    "SetRelationship",
    "HookTypes",
    "register_hook",
]
