# OsmRx

A geographic Python library to extract Open Street Map roads (and POIs) from a location or a bounding box, in order to create a graph thanks to Rustworkx. OsmRx is able to clean a network based on Linestring geometries and connect Point geometries. The graph built is able to process graph-analysis (shortest-path, isochrones...)

Capabilities:
* load data from a location name or a bounding box (roads and pois)
* graph creation (and topology processing and cleaning)
* shortest path
* isochrone builder

[![CI](https://github.com/amauryval/osmrx/actions/workflows/main.yml/badge.svg?branch=master)](https://github.com/amauryval/osmrx/actions/workflows/main.yml)
[![codecov](https://codecov.io/gh/amauryval/osmrx/branch/master/graph/badge.svg)](https://codecov.io/gh/amauryval/osmrx)

[![PyPI version](https://badge.fury.io/py/osmrx.svg)](https://badge.fury.io/py/osmrx)

Check the demo [here](https://amauryval.github.io/gdf2bokeh/)


## How to install it ?

### with pip

```bash
pip install osmrx
```

## How to use it ?

Check the jupyter notebook here : TODO
Check the wiki: TODO

### Get POIs

TODO

```python

```

### Get Roads

TODO

```python

```


### Compute a shortest path

TODO

```python

```


### Compute an Isochrone

TODO

```python

```
