# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-04-15 10:41


from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(blank=True, max_length=200, unique=True)),
                ('title_ru', models.CharField(blank=True, max_length=255)),
                ('text_ru', models.TextField(blank=True)),
                ('title_en', models.CharField(blank=True, max_length=255)),
                ('text_en', models.TextField(blank=True)),
                ('published', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('updated', models.DateTimeField(auto_now=True)),
                ('comments_hidden', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='ArticleUpload',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('upload', models.FileField(upload_to=b'uploads')),
                ('article', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='uploads', to='marcus.Article')),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(blank=True, unique=True)),
                ('title_ru', models.CharField(blank=True, max_length=255)),
                ('description_ru', models.TextField(blank=True)),
                ('count_articles_ru', models.PositiveIntegerField(default=0)),
                ('title_en', models.CharField(blank=True, max_length=255)),
                ('description_en', models.TextField(blank=True)),
                ('count_articles_en', models.PositiveIntegerField(default=0)),
                ('essential', models.BooleanField(db_index=True, default=False)),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='marcus.Category')),
            ],
            options={
                'verbose_name': 'category',
                'verbose_name_plural': 'categories',
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[(b'comment', 'Comment'), (b'pingback', 'Pingback')], max_length=20)),
                ('text', models.TextField(verbose_name='Text')),
                ('language', models.CharField(choices=[(b'ru', 'Russian'), (b'en', 'English')], max_length=2, verbose_name='Language')),
                ('guest_name', models.CharField(blank=True, max_length=255)),
                ('guest_email', models.CharField(blank=True, default=b'', max_length=200)),
                ('guest_url', models.URLField(blank=True)),
                ('ip', models.GenericIPAddressField(default=b'127.0.0.1')),
                ('spam_status', models.CharField(blank=True, default=b'', max_length=20)),
                ('created', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('approved', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('noteworthy', models.BooleanField(default=False)),
                ('followup', models.BooleanField(default=False, help_text='Receive by email further comments in this conversation')),
                ('article', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='marcus.Article')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(blank=True, unique=True)),
                ('title_ru', models.CharField(blank=True, max_length=255)),
                ('description_ru', models.TextField(blank=True)),
                ('count_articles_ru', models.PositiveIntegerField(default=0)),
                ('title_en', models.CharField(blank=True, max_length=255)),
                ('description_en', models.TextField(blank=True)),
                ('count_articles_en', models.PositiveIntegerField(default=0)),
            ],
        ),
        migrations.AddField(
            model_name='article',
            name='categories',
            field=models.ManyToManyField(to='marcus.Category'),
        ),
        migrations.AddField(
            model_name='article',
            name='tags',
            field=models.ManyToManyField(to='marcus.Tag'),
        ),
    ]
