import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [snowball](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowball.html).
 *
 * @experimental
 */
export declare class Snowball extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [snowball](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowball.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Cancels a cluster job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelCluster.html
     *
     * @experimental
     */
    toCancelCluster(): this;
    /**
     * (experimental) Cancels the specified job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelJob.html
     *
     * @experimental
     */
    toCancelJob(): this;
    /**
     * (experimental) Creates an address for a Snowball to be shipped to.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateAddress.html
     *
     * @experimental
     */
    toCreateAddress(): this;
    /**
     * (experimental) Creates an empty cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateCluster.html
     *
     * @experimental
     */
    toCreateCluster(): this;
    /**
     * (experimental) Creates a job to import or export data between Amazon S3 and your on-premises data center.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateJob.html
     *
     * @experimental
     */
    toCreateJob(): this;
    /**
     * (experimental) Creates a shipping label that will be used to return the Snow device to AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateReturnShippingLabel.html
     *
     * @experimental
     */
    toCreateReturnShippingLabel(): this;
    /**
     * (experimental) Takes an AddressId and returns specific details about that address in the form of an Address object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddress.html
     *
     * @experimental
     */
    toDescribeAddress(): this;
    /**
     * (experimental) Returns a specified number of ADDRESS objects.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddresses.html
     *
     * @experimental
     */
    toDescribeAddresses(): this;
    /**
     * (experimental) Returns information about a specific cluster including shipping information, cluster status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeCluster.html
     *
     * @experimental
     */
    toDescribeCluster(): this;
    /**
     * (experimental) Returns information about a specific job including shipping information, job status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeJob.html
     *
     * @experimental
     */
    toDescribeJob(): this;
    /**
     * (experimental) Information on the shipping label of a Snow device that is being returned to AWS.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeReturnShippingLabel.html
     *
     * @experimental
     */
    toDescribeReturnShippingLabel(): this;
    /**
     * (experimental) Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified JobId value.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobManifest.html
     *
     * @experimental
     */
    toGetJobManifest(): this;
    /**
     * (experimental) Returns the UnlockCode code value for the specified job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobUnlockCode.html
     *
     * @experimental
     */
    toGetJobUnlockCode(): this;
    /**
     * (experimental) Returns information about the Snowball service limit for your account, and also the number of Snowballs your account has in use.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSnowballUsage.html
     *
     * @experimental
     */
    toGetSnowballUsage(): this;
    /**
     * (experimental) Returns an Amazon S3 presigned URL for an update file associated with a specified JobId.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSoftwareUpdates.html
     *
     * @experimental
     */
    toGetSoftwareUpdates(): this;
    /**
     * (experimental) Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusterJobs.html
     *
     * @experimental
     */
    toListClusterJobs(): this;
    /**
     * (experimental) Returns an array of ClusterListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusters.html
     *
     * @experimental
     */
    toListClusters(): this;
    /**
     * (experimental) This action returns a list of the different Amazon EC2 Amazon Machine Images (AMIs) that are owned by your AWS account that would be supported for use on a Snow device.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListCompatibleImages.html
     *
     * @experimental
     */
    toListCompatibleImages(): this;
    /**
     * (experimental) Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListJobs.html
     *
     * @experimental
     */
    toListJobs(): this;
    /**
     * (experimental) While a cluster's ClusterState value is in the AwaitingQuorum state, you can update some of the information associated with a cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateCluster.html
     *
     * @experimental
     */
    toUpdateCluster(): this;
    /**
     * (experimental) While a job's JobState value is New, you can update some of the information associated with a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJob.html
     *
     * @experimental
     */
    toUpdateJob(): this;
    /**
     * (experimental) Updates the state when a the shipment states changes to a different state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJobShipmentState.html
     *
     * @experimental
     */
    toUpdateJobShipmentState(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
