"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Account = exports.AccountProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "AccountProperty", { enumerable: true, get: function () { return polardb_generated_1.RosAccount; } });
/**
 * A ROS resource type:  `ALIYUN::POLARDB::Account`
 */
class Account extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::POLARDB::Account`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccount = new polardb_generated_1.RosAccount(this, id, {
            accountDescription: props.accountDescription,
            accountPrivilege: props.accountPrivilege,
            dbClusterId: props.dbClusterId,
            dbName: props.dbName,
            accountType: props.accountType,
            accountName: props.accountName,
            accountPassword: props.accountPassword,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccount;
    }
}
exports.Account = Account;
//# sourceMappingURL=data:application/json;base64,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