"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosDBNodes = exports.RosDBInstance = exports.RosDBClusterEndpointAddress = exports.RosDBClusterEndpoint = exports.RosDBClusterAccessWhiteList = exports.RosDBCluster = exports.RosAccountPrivilege = exports.RosAccount = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosAccountProps`
 *
 * @param properties - the TypeScript properties of a `RosAccountProps`
 *
 * @returns the result of the validation.
 */
function RosAccountPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.accountDescription && (Array.isArray(properties.accountDescription) || (typeof properties.accountDescription) === 'string')) {
        errors.collect(ros.propertyValidator('accountDescription', ros.validateLength)({
            data: properties.accountDescription.length,
            min: 2,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('accountDescription', ros.validateString)(properties.accountDescription));
    errors.collect(ros.propertyValidator('accountPrivilege', ros.validateString)(properties.accountPrivilege));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    if (properties.accountType && (typeof properties.accountType) !== 'object') {
        errors.collect(ros.propertyValidator('accountType', ros.validateAllowedValues)({
            data: properties.accountType,
            allowedValues: ["Normal", "Super"],
        }));
    }
    errors.collect(ros.propertyValidator('accountType', ros.validateString)(properties.accountType));
    errors.collect(ros.propertyValidator('accountName', ros.requiredValidator)(properties.accountName));
    if (properties.accountName && (Array.isArray(properties.accountName) || (typeof properties.accountName) === 'string')) {
        errors.collect(ros.propertyValidator('accountName', ros.validateLength)({
            data: properties.accountName.length,
            min: 1,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('accountName', ros.validateString)(properties.accountName));
    errors.collect(ros.propertyValidator('accountPassword', ros.requiredValidator)(properties.accountPassword));
    if (properties.accountPassword && (Array.isArray(properties.accountPassword) || (typeof properties.accountPassword) === 'string')) {
        errors.collect(ros.propertyValidator('accountPassword', ros.validateLength)({
            data: properties.accountPassword.length,
            min: 8,
            max: 32,
        }));
    }
    errors.collect(ros.propertyValidator('accountPassword', ros.validateString)(properties.accountPassword));
    return errors.wrap('supplied properties not correct for "RosAccountProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::Account` resource
 *
 * @param properties - the TypeScript properties of a `RosAccountProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::Account` resource.
 */
// @ts-ignore TS6133
function rosAccountPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAccountPropsValidator(properties).assertSuccess();
    }
    return {
        AccountName: ros.stringToRosTemplate(properties.accountName),
        AccountPassword: ros.stringToRosTemplate(properties.accountPassword),
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        AccountDescription: ros.stringToRosTemplate(properties.accountDescription),
        AccountPrivilege: ros.stringToRosTemplate(properties.accountPrivilege),
        AccountType: ros.stringToRosTemplate(properties.accountType),
        DBName: ros.stringToRosTemplate(properties.dbName),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::Account`
 */
class RosAccount extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::Account`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAccount.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.accountName = props.accountName;
        this.accountPassword = props.accountPassword;
        this.dbClusterId = props.dbClusterId;
        this.accountDescription = props.accountDescription;
        this.accountPrivilege = props.accountPrivilege;
        this.accountType = props.accountType;
        this.dbName = props.dbName;
    }
    get rosProperties() {
        return {
            accountName: this.accountName,
            accountPassword: this.accountPassword,
            dbClusterId: this.dbClusterId,
            accountDescription: this.accountDescription,
            accountPrivilege: this.accountPrivilege,
            accountType: this.accountType,
            dbName: this.dbName,
        };
    }
    renderProperties(props) {
        return rosAccountPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAccount = RosAccount;
/**
 * The resource type name for this resource class.
 */
RosAccount.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::Account";
/**
 * Determine whether the given properties match those of a `RosAccountPrivilegeProps`
 *
 * @param properties - the TypeScript properties of a `RosAccountPrivilegeProps`
 *
 * @returns the result of the validation.
 */
function RosAccountPrivilegePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('accountPrivilege', ros.requiredValidator)(properties.accountPrivilege));
    if (properties.accountPrivilege && (Array.isArray(properties.accountPrivilege) || (typeof properties.accountPrivilege) === 'string')) {
        errors.collect(ros.propertyValidator('accountPrivilege', ros.validateLength)({
            data: properties.accountPrivilege.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('accountPrivilege', ros.validateString)(properties.accountPrivilege));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    if (properties.dbName && (Array.isArray(properties.dbName) || (typeof properties.dbName) === 'string')) {
        errors.collect(ros.propertyValidator('dbName', ros.validateLength)({
            data: properties.dbName.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    errors.collect(ros.propertyValidator('accountName', ros.requiredValidator)(properties.accountName));
    if (properties.accountName && (Array.isArray(properties.accountName) || (typeof properties.accountName) === 'string')) {
        errors.collect(ros.propertyValidator('accountName', ros.validateLength)({
            data: properties.accountName.length,
            min: 1,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('accountName', ros.validateString)(properties.accountName));
    return errors.wrap('supplied properties not correct for "RosAccountPrivilegeProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::AccountPrivilege` resource
 *
 * @param properties - the TypeScript properties of a `RosAccountPrivilegeProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::AccountPrivilege` resource.
 */
// @ts-ignore TS6133
function rosAccountPrivilegePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosAccountPrivilegePropsValidator(properties).assertSuccess();
    }
    return {
        AccountName: ros.stringToRosTemplate(properties.accountName),
        AccountPrivilege: ros.stringToRosTemplate(properties.accountPrivilege),
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        DBName: ros.stringToRosTemplate(properties.dbName),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::AccountPrivilege`
 */
class RosAccountPrivilege extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::AccountPrivilege`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosAccountPrivilege.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.accountName = props.accountName;
        this.accountPrivilege = props.accountPrivilege;
        this.dbClusterId = props.dbClusterId;
        this.dbName = props.dbName;
    }
    get rosProperties() {
        return {
            accountName: this.accountName,
            accountPrivilege: this.accountPrivilege,
            dbClusterId: this.dbClusterId,
            dbName: this.dbName,
        };
    }
    renderProperties(props) {
        return rosAccountPrivilegePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosAccountPrivilege = RosAccountPrivilege;
/**
 * The resource type name for this resource class.
 */
RosAccountPrivilege.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::AccountPrivilege";
/**
 * Determine whether the given properties match those of a `RosDBClusterProps`
 *
 * @param properties - the TypeScript properties of a `RosDBClusterProps`
 *
 * @returns the result of the validation.
 */
function RosDBClusterPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.autoRenewPeriod && (typeof properties.autoRenewPeriod) !== 'object') {
        errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateAllowedValues)({
            data: properties.autoRenewPeriod,
            allowedValues: [1, 2, 3, 6, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('autoRenewPeriod', ros.validateNumber)(properties.autoRenewPeriod));
    errors.collect(ros.propertyValidator('defaultTimeZone', ros.validateString)(properties.defaultTimeZone));
    errors.collect(ros.propertyValidator('tdeStatus', ros.validateBoolean)(properties.tdeStatus));
    errors.collect(ros.propertyValidator('cloneDataPoint', ros.validateString)(properties.cloneDataPoint));
    errors.collect(ros.propertyValidator('gdnId', ros.validateString)(properties.gdnId));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('zoneId', ros.validateString)(properties.zoneId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    if (properties.backupRetentionPolicyOnClusterDeletion && (typeof properties.backupRetentionPolicyOnClusterDeletion) !== 'object') {
        errors.collect(ros.propertyValidator('backupRetentionPolicyOnClusterDeletion', ros.validateAllowedValues)({
            data: properties.backupRetentionPolicyOnClusterDeletion,
            allowedValues: ["ALL", "LATEST", "NONE"],
        }));
    }
    errors.collect(ros.propertyValidator('backupRetentionPolicyOnClusterDeletion', ros.validateString)(properties.backupRetentionPolicyOnClusterDeletion));
    if (properties.renewalStatus && (typeof properties.renewalStatus) !== 'object') {
        errors.collect(ros.propertyValidator('renewalStatus', ros.validateAllowedValues)({
            data: properties.renewalStatus,
            allowedValues: ["AutoRenewal", "Normal", "NotRenewal"],
        }));
    }
    errors.collect(ros.propertyValidator('renewalStatus', ros.validateString)(properties.renewalStatus));
    if (properties.dbClusterDescription && (Array.isArray(properties.dbClusterDescription) || (typeof properties.dbClusterDescription) === 'string')) {
        errors.collect(ros.propertyValidator('dbClusterDescription', ros.validateLength)({
            data: properties.dbClusterDescription.length,
            min: 2,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('dbClusterDescription', ros.validateString)(properties.dbClusterDescription));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('sourceResourceId', ros.validateString)(properties.sourceResourceId));
    errors.collect(ros.propertyValidator('dbType', ros.requiredValidator)(properties.dbType));
    if (properties.dbType && (typeof properties.dbType) !== 'object') {
        errors.collect(ros.propertyValidator('dbType', ros.validateAllowedValues)({
            data: properties.dbType,
            allowedValues: ["MySQL", "Oracle", "PostgreSQL"],
        }));
    }
    errors.collect(ros.propertyValidator('dbType', ros.validateString)(properties.dbType));
    errors.collect(ros.propertyValidator('payType', ros.requiredValidator)(properties.payType));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Postpaid", "Prepaid"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    errors.collect(ros.propertyValidator('creationCategory', ros.validateString)(properties.creationCategory));
    errors.collect(ros.propertyValidator('dbNodeClass', ros.requiredValidator)(properties.dbNodeClass));
    errors.collect(ros.propertyValidator('dbNodeClass', ros.validateString)(properties.dbNodeClass));
    if (properties.creationOption && (typeof properties.creationOption) !== 'object') {
        errors.collect(ros.propertyValidator('creationOption', ros.validateAllowedValues)({
            data: properties.creationOption,
            allowedValues: ["CloneFromPolarDB", "CloneFromRDS", "MigrationFromRDS", "Normal", "CreateGdnStandby"],
        }));
    }
    errors.collect(ros.propertyValidator('creationOption', ros.validateString)(properties.creationOption));
    errors.collect(ros.propertyValidator('dbVersion', ros.requiredValidator)(properties.dbVersion));
    errors.collect(ros.propertyValidator('dbVersion', ros.validateString)(properties.dbVersion));
    if (properties.clusterNetworkType && (typeof properties.clusterNetworkType) !== 'object') {
        errors.collect(ros.propertyValidator('clusterNetworkType', ros.validateAllowedValues)({
            data: properties.clusterNetworkType,
            allowedValues: ["VPC"],
        }));
    }
    errors.collect(ros.propertyValidator('clusterNetworkType', ros.validateString)(properties.clusterNetworkType));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('securityIpList', ros.validateString)(properties.securityIpList));
    errors.collect(ros.propertyValidator('maintainTime', ros.validateString)(properties.maintainTime));
    if (properties.lowerCaseTableNames && (typeof properties.lowerCaseTableNames) !== 'object') {
        errors.collect(ros.propertyValidator('lowerCaseTableNames', ros.validateAllowedValues)({
            data: properties.lowerCaseTableNames,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('lowerCaseTableNames', ros.validateNumber)(properties.lowerCaseTableNames));
    return errors.wrap('supplied properties not correct for "RosDBClusterProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBCluster` resource
 *
 * @param properties - the TypeScript properties of a `RosDBClusterProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBCluster` resource.
 */
// @ts-ignore TS6133
function rosDBClusterPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBClusterPropsValidator(properties).assertSuccess();
    }
    return {
        DBNodeClass: ros.stringToRosTemplate(properties.dbNodeClass),
        DBType: ros.stringToRosTemplate(properties.dbType),
        DBVersion: ros.stringToRosTemplate(properties.dbVersion),
        PayType: ros.stringToRosTemplate(properties.payType),
        AutoRenewPeriod: ros.numberToRosTemplate(properties.autoRenewPeriod),
        BackupRetentionPolicyOnClusterDeletion: ros.stringToRosTemplate(properties.backupRetentionPolicyOnClusterDeletion),
        CloneDataPoint: ros.stringToRosTemplate(properties.cloneDataPoint),
        ClusterNetworkType: ros.stringToRosTemplate(properties.clusterNetworkType),
        CreationCategory: ros.stringToRosTemplate(properties.creationCategory),
        CreationOption: ros.stringToRosTemplate(properties.creationOption),
        DBClusterDescription: ros.stringToRosTemplate(properties.dbClusterDescription),
        DefaultTimeZone: ros.stringToRosTemplate(properties.defaultTimeZone),
        GDNId: ros.stringToRosTemplate(properties.gdnId),
        LowerCaseTableNames: ros.numberToRosTemplate(properties.lowerCaseTableNames),
        MaintainTime: ros.stringToRosTemplate(properties.maintainTime),
        Period: ros.numberToRosTemplate(properties.period),
        RenewalStatus: ros.stringToRosTemplate(properties.renewalStatus),
        ResourceGroupId: ros.stringToRosTemplate(properties.resourceGroupId),
        SecurityIPList: ros.stringToRosTemplate(properties.securityIpList),
        SourceResourceId: ros.stringToRosTemplate(properties.sourceResourceId),
        TDEStatus: ros.booleanToRosTemplate(properties.tdeStatus),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        ZoneId: ros.stringToRosTemplate(properties.zoneId),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBCluster`
 */
class RosDBCluster extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBCluster.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrClusterConnectionString = ros.Token.asString(this.getAtt('ClusterConnectionString'));
        this.attrClusterEndpointId = ros.Token.asString(this.getAtt('ClusterEndpointId'));
        this.attrCustomConnectionStrings = ros.Token.asString(this.getAtt('CustomConnectionStrings'));
        this.attrCustomEndpointIds = ros.Token.asString(this.getAtt('CustomEndpointIds'));
        this.attrDbClusterId = ros.Token.asString(this.getAtt('DBClusterId'));
        this.attrDbNodeIds = ros.Token.asString(this.getAtt('DBNodeIds'));
        this.attrOrderId = ros.Token.asString(this.getAtt('OrderId'));
        this.attrPrimaryConnectionString = ros.Token.asString(this.getAtt('PrimaryConnectionString'));
        this.attrPrimaryEndpointId = ros.Token.asString(this.getAtt('PrimaryEndpointId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbNodeClass = props.dbNodeClass;
        this.dbType = props.dbType;
        this.dbVersion = props.dbVersion;
        this.payType = props.payType;
        this.autoRenewPeriod = props.autoRenewPeriod;
        this.backupRetentionPolicyOnClusterDeletion = props.backupRetentionPolicyOnClusterDeletion;
        this.cloneDataPoint = props.cloneDataPoint;
        this.clusterNetworkType = props.clusterNetworkType;
        this.creationCategory = props.creationCategory;
        this.creationOption = props.creationOption;
        this.dbClusterDescription = props.dbClusterDescription;
        this.defaultTimeZone = props.defaultTimeZone;
        this.gdnId = props.gdnId;
        this.lowerCaseTableNames = props.lowerCaseTableNames;
        this.maintainTime = props.maintainTime;
        this.period = props.period;
        this.renewalStatus = props.renewalStatus;
        this.resourceGroupId = props.resourceGroupId;
        this.securityIpList = props.securityIpList;
        this.sourceResourceId = props.sourceResourceId;
        this.tdeStatus = props.tdeStatus;
        this.vpcId = props.vpcId;
        this.vSwitchId = props.vSwitchId;
        this.zoneId = props.zoneId;
    }
    get rosProperties() {
        return {
            dbNodeClass: this.dbNodeClass,
            dbType: this.dbType,
            dbVersion: this.dbVersion,
            payType: this.payType,
            autoRenewPeriod: this.autoRenewPeriod,
            backupRetentionPolicyOnClusterDeletion: this.backupRetentionPolicyOnClusterDeletion,
            cloneDataPoint: this.cloneDataPoint,
            clusterNetworkType: this.clusterNetworkType,
            creationCategory: this.creationCategory,
            creationOption: this.creationOption,
            dbClusterDescription: this.dbClusterDescription,
            defaultTimeZone: this.defaultTimeZone,
            gdnId: this.gdnId,
            lowerCaseTableNames: this.lowerCaseTableNames,
            maintainTime: this.maintainTime,
            period: this.period,
            renewalStatus: this.renewalStatus,
            resourceGroupId: this.resourceGroupId,
            securityIpList: this.securityIpList,
            sourceResourceId: this.sourceResourceId,
            tdeStatus: this.tdeStatus,
            vpcId: this.vpcId,
            vSwitchId: this.vSwitchId,
            zoneId: this.zoneId,
        };
    }
    renderProperties(props) {
        return rosDBClusterPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBCluster = RosDBCluster;
/**
 * The resource type name for this resource class.
 */
RosDBCluster.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBCluster";
/**
 * Determine whether the given properties match those of a `RosDBClusterAccessWhiteListProps`
 *
 * @param properties - the TypeScript properties of a `RosDBClusterAccessWhiteListProps`
 *
 * @returns the result of the validation.
 */
function RosDBClusterAccessWhiteListPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('securityIps', ros.requiredValidator)(properties.securityIps));
    errors.collect(ros.propertyValidator('securityIps', ros.validateString)(properties.securityIps));
    if (properties.dbClusterIpArrayName && (Array.isArray(properties.dbClusterIpArrayName) || (typeof properties.dbClusterIpArrayName) === 'string')) {
        errors.collect(ros.propertyValidator('dbClusterIpArrayName', ros.validateLength)({
            data: properties.dbClusterIpArrayName.length,
            min: 1,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('dbClusterIpArrayName', ros.validateString)(properties.dbClusterIpArrayName));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    return errors.wrap('supplied properties not correct for "RosDBClusterAccessWhiteListProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterAccessWhiteList` resource
 *
 * @param properties - the TypeScript properties of a `RosDBClusterAccessWhiteListProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterAccessWhiteList` resource.
 */
// @ts-ignore TS6133
function rosDBClusterAccessWhiteListPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBClusterAccessWhiteListPropsValidator(properties).assertSuccess();
    }
    return {
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        SecurityIps: ros.stringToRosTemplate(properties.securityIps),
        DBClusterIPArrayName: ros.stringToRosTemplate(properties.dbClusterIpArrayName),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBClusterAccessWhiteList`
 */
class RosDBClusterAccessWhiteList extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterAccessWhiteList`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBClusterAccessWhiteList.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDbClusterId = ros.Token.asString(this.getAtt('DBClusterId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbClusterId = props.dbClusterId;
        this.securityIps = props.securityIps;
        this.dbClusterIpArrayName = props.dbClusterIpArrayName;
    }
    get rosProperties() {
        return {
            dbClusterId: this.dbClusterId,
            securityIps: this.securityIps,
            dbClusterIpArrayName: this.dbClusterIpArrayName,
        };
    }
    renderProperties(props) {
        return rosDBClusterAccessWhiteListPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBClusterAccessWhiteList = RosDBClusterAccessWhiteList;
/**
 * The resource type name for this resource class.
 */
RosDBClusterAccessWhiteList.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBClusterAccessWhiteList";
/**
 * Determine whether the given properties match those of a `RosDBClusterEndpointProps`
 *
 * @param properties - the TypeScript properties of a `RosDBClusterEndpointProps`
 *
 * @returns the result of the validation.
 */
function RosDBClusterEndpointPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.autoAddNewNodes && (typeof properties.autoAddNewNodes) !== 'object') {
        errors.collect(ros.propertyValidator('autoAddNewNodes', ros.validateAllowedValues)({
            data: properties.autoAddNewNodes,
            allowedValues: ["Disable", "Enable"],
        }));
    }
    errors.collect(ros.propertyValidator('autoAddNewNodes', ros.validateString)(properties.autoAddNewNodes));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('endpointType', ros.validateString)(properties.endpointType));
    if (properties.readWriteMode && (typeof properties.readWriteMode) !== 'object') {
        errors.collect(ros.propertyValidator('readWriteMode', ros.validateAllowedValues)({
            data: properties.readWriteMode,
            allowedValues: ["ReadOnly", "ReadWrite"],
        }));
    }
    errors.collect(ros.propertyValidator('readWriteMode', ros.validateString)(properties.readWriteMode));
    errors.collect(ros.propertyValidator('endpointConfig', RosDBClusterEndpoint_EndpointConfigPropertyValidator)(properties.endpointConfig));
    if (properties.nodes && (Array.isArray(properties.nodes) || (typeof properties.nodes) === 'string')) {
        errors.collect(ros.propertyValidator('nodes', ros.validateLength)({
            data: properties.nodes.length,
            min: 2,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('nodes', ros.listValidator(ros.validateAny))(properties.nodes));
    return errors.wrap('supplied properties not correct for "RosDBClusterEndpointProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `RosDBClusterEndpointProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpoint` resource.
 */
// @ts-ignore TS6133
function rosDBClusterEndpointPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBClusterEndpointPropsValidator(properties).assertSuccess();
    }
    return {
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        AutoAddNewNodes: ros.stringToRosTemplate(properties.autoAddNewNodes),
        EndpointConfig: rosDBClusterEndpointEndpointConfigPropertyToRosTemplate(properties.endpointConfig),
        EndpointType: ros.stringToRosTemplate(properties.endpointType),
        Nodes: ros.listMapper(ros.objectToRosTemplate)(properties.nodes),
        ReadWriteMode: ros.stringToRosTemplate(properties.readWriteMode),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBClusterEndpoint`
 */
class RosDBClusterEndpoint extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBClusterEndpoint.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAddresses = ros.Token.asString(this.getAtt('Addresses'));
        this.attrConnectionString = ros.Token.asString(this.getAtt('ConnectionString'));
        this.attrDbEndpointId = ros.Token.asString(this.getAtt('DBEndpointId'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbClusterId = props.dbClusterId;
        this.autoAddNewNodes = props.autoAddNewNodes;
        this.endpointConfig = props.endpointConfig;
        this.endpointType = props.endpointType;
        this.nodes = props.nodes;
        this.readWriteMode = props.readWriteMode;
    }
    get rosProperties() {
        return {
            dbClusterId: this.dbClusterId,
            autoAddNewNodes: this.autoAddNewNodes,
            endpointConfig: this.endpointConfig,
            endpointType: this.endpointType,
            nodes: this.nodes,
            readWriteMode: this.readWriteMode,
        };
    }
    renderProperties(props) {
        return rosDBClusterEndpointPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBClusterEndpoint = RosDBClusterEndpoint;
/**
 * The resource type name for this resource class.
 */
RosDBClusterEndpoint.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBClusterEndpoint";
/**
 * Determine whether the given properties match those of a `EndpointConfigProperty`
 *
 * @param properties - the TypeScript properties of a `EndpointConfigProperty`
 *
 * @returns the result of the validation.
 */
function RosDBClusterEndpoint_EndpointConfigPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.consistLevel && (typeof properties.consistLevel) !== 'object') {
        errors.collect(ros.propertyValidator('consistLevel', ros.validateAllowedValues)({
            data: properties.consistLevel,
            allowedValues: ["0", "1"],
        }));
    }
    errors.collect(ros.propertyValidator('consistLevel', ros.validateString)(properties.consistLevel));
    return errors.wrap('supplied properties not correct for "EndpointConfigProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpoint.EndpointConfig` resource
 *
 * @param properties - the TypeScript properties of a `EndpointConfigProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpoint.EndpointConfig` resource.
 */
// @ts-ignore TS6133
function rosDBClusterEndpointEndpointConfigPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosDBClusterEndpoint_EndpointConfigPropertyValidator(properties).assertSuccess();
    return {
        ConsistLevel: ros.stringToRosTemplate(properties.consistLevel),
    };
}
/**
 * Determine whether the given properties match those of a `RosDBClusterEndpointAddressProps`
 *
 * @param properties - the TypeScript properties of a `RosDBClusterEndpointAddressProps`
 *
 * @returns the result of the validation.
 */
function RosDBClusterEndpointAddressPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('dbEndpointId', ros.requiredValidator)(properties.dbEndpointId));
    errors.collect(ros.propertyValidator('dbEndpointId', ros.validateString)(properties.dbEndpointId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    if (properties.connectionStringPrefix && (typeof properties.connectionStringPrefix) !== 'object') {
        errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateAllowedPattern)({
            data: properties.connectionStringPrefix,
            reg: /[a-z][-a-z0-9]{4,28}[a-z0-9]/
        }));
    }
    errors.collect(ros.propertyValidator('connectionStringPrefix', ros.validateString)(properties.connectionStringPrefix));
    if (properties.netType && (typeof properties.netType) !== 'object') {
        errors.collect(ros.propertyValidator('netType', ros.validateAllowedValues)({
            data: properties.netType,
            allowedValues: ["Public", "Private"],
        }));
    }
    errors.collect(ros.propertyValidator('netType', ros.validateString)(properties.netType));
    return errors.wrap('supplied properties not correct for "RosDBClusterEndpointAddressProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpointAddress` resource
 *
 * @param properties - the TypeScript properties of a `RosDBClusterEndpointAddressProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBClusterEndpointAddress` resource.
 */
// @ts-ignore TS6133
function rosDBClusterEndpointAddressPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBClusterEndpointAddressPropsValidator(properties).assertSuccess();
    }
    return {
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        DBEndpointId: ros.stringToRosTemplate(properties.dbEndpointId),
        ConnectionStringPrefix: ros.stringToRosTemplate(properties.connectionStringPrefix),
        NetType: ros.stringToRosTemplate(properties.netType),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBClusterEndpointAddress`
 */
class RosDBClusterEndpointAddress extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBClusterEndpointAddress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBClusterEndpointAddress.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAddress = ros.Token.asString(this.getAtt('Address'));
        this.attrConnectionString = ros.Token.asString(this.getAtt('ConnectionString'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dbClusterId = props.dbClusterId;
        this.dbEndpointId = props.dbEndpointId;
        this.connectionStringPrefix = props.connectionStringPrefix;
        this.netType = props.netType;
    }
    get rosProperties() {
        return {
            dbClusterId: this.dbClusterId,
            dbEndpointId: this.dbEndpointId,
            connectionStringPrefix: this.connectionStringPrefix,
            netType: this.netType,
        };
    }
    renderProperties(props) {
        return rosDBClusterEndpointAddressPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBClusterEndpointAddress = RosDBClusterEndpointAddress;
/**
 * The resource type name for this resource class.
 */
RosDBClusterEndpointAddress.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBClusterEndpointAddress";
/**
 * Determine whether the given properties match those of a `RosDBInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosDBInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('characterSetName', ros.requiredValidator)(properties.characterSetName));
    errors.collect(ros.propertyValidator('characterSetName', ros.validateString)(properties.characterSetName));
    if (properties.accountPrivilege && (typeof properties.accountPrivilege) !== 'object') {
        errors.collect(ros.propertyValidator('accountPrivilege', ros.validateAllowedValues)({
            data: properties.accountPrivilege,
            allowedValues: ["ReadWrite", "ReadOnly", "DMLOnly", "DDLOnly"],
        }));
    }
    errors.collect(ros.propertyValidator('accountPrivilege', ros.validateString)(properties.accountPrivilege));
    if (properties.dbDescription && (Array.isArray(properties.dbDescription) || (typeof properties.dbDescription) === 'string')) {
        errors.collect(ros.propertyValidator('dbDescription', ros.validateLength)({
            data: properties.dbDescription.length,
            min: 2,
            max: 256,
        }));
    }
    errors.collect(ros.propertyValidator('dbDescription', ros.validateString)(properties.dbDescription));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbName', ros.requiredValidator)(properties.dbName));
    if (properties.dbName && (typeof properties.dbName) !== 'object') {
        errors.collect(ros.propertyValidator('dbName', ros.validateAllowedPattern)({
            data: properties.dbName,
            reg: /^[a-z0-9][-_a-z0-9]{0,63}(?<![-_]$)$/
        }));
    }
    errors.collect(ros.propertyValidator('dbName', ros.validateString)(properties.dbName));
    errors.collect(ros.propertyValidator('accountName', ros.validateString)(properties.accountName));
    return errors.wrap('supplied properties not correct for "RosDBInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosDBInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBInstance` resource.
 */
// @ts-ignore TS6133
function rosDBInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBInstancePropsValidator(properties).assertSuccess();
    }
    return {
        CharacterSetName: ros.stringToRosTemplate(properties.characterSetName),
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
        DBName: ros.stringToRosTemplate(properties.dbName),
        AccountName: ros.stringToRosTemplate(properties.accountName),
        AccountPrivilege: ros.stringToRosTemplate(properties.accountPrivilege),
        DBDescription: ros.stringToRosTemplate(properties.dbDescription),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBInstance`
 */
class RosDBInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.characterSetName = props.characterSetName;
        this.dbClusterId = props.dbClusterId;
        this.dbName = props.dbName;
        this.accountName = props.accountName;
        this.accountPrivilege = props.accountPrivilege;
        this.dbDescription = props.dbDescription;
    }
    get rosProperties() {
        return {
            characterSetName: this.characterSetName,
            dbClusterId: this.dbClusterId,
            dbName: this.dbName,
            accountName: this.accountName,
            accountPrivilege: this.accountPrivilege,
            dbDescription: this.dbDescription,
        };
    }
    renderProperties(props) {
        return rosDBInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBInstance = RosDBInstance;
/**
 * The resource type name for this resource class.
 */
RosDBInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBInstance";
/**
 * Determine whether the given properties match those of a `RosDBNodesProps`
 *
 * @param properties - the TypeScript properties of a `RosDBNodesProps`
 *
 * @returns the result of the validation.
 */
function RosDBNodesPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('amount', ros.requiredValidator)(properties.amount));
    if (properties.amount && (typeof properties.amount) !== 'object') {
        errors.collect(ros.propertyValidator('amount', ros.validateRange)({
            data: properties.amount,
            min: 1,
            max: 16,
        }));
    }
    errors.collect(ros.propertyValidator('amount', ros.validateNumber)(properties.amount));
    errors.collect(ros.propertyValidator('dbClusterId', ros.requiredValidator)(properties.dbClusterId));
    errors.collect(ros.propertyValidator('dbClusterId', ros.validateString)(properties.dbClusterId));
    return errors.wrap('supplied properties not correct for "RosDBNodesProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBNodes` resource
 *
 * @param properties - the TypeScript properties of a `RosDBNodesProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::POLARDB::DBNodes` resource.
 */
// @ts-ignore TS6133
function rosDBNodesPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDBNodesPropsValidator(properties).assertSuccess();
    }
    return {
        Amount: ros.numberToRosTemplate(properties.amount),
        DBClusterId: ros.stringToRosTemplate(properties.dbClusterId),
    };
}
/**
 * A ROS template type:  `ALIYUN::POLARDB::DBNodes`
 */
class RosDBNodes extends ros.RosResource {
    /**
     * Create a new `ALIYUN::POLARDB::DBNodes`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDBNodes.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDbNodeIds = ros.Token.asString(this.getAtt('DBNodeIds'));
        this.attrOrderIds = ros.Token.asString(this.getAtt('OrderIds'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.amount = props.amount;
        this.dbClusterId = props.dbClusterId;
    }
    get rosProperties() {
        return {
            amount: this.amount,
            dbClusterId: this.dbClusterId,
        };
    }
    renderProperties(props) {
        return rosDBNodesPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDBNodes = RosDBNodes;
/**
 * The resource type name for this resource class.
 */
RosDBNodes.ROS_RESOURCE_TYPE_NAME = "ALIYUN::POLARDB::DBNodes";
//# sourceMappingURL=data:application/json;base64,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