"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Groundtruthlabeling = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazongroundtruthlabeling.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Groundtruthlabeling extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [groundtruthlabeling](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazongroundtruthlabeling.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'groundtruthlabeling';
        this.actionList = {
            "DescribeConsoleJob": {
                "url": "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file",
                "description": "Get status of GroundTruthLabeling Jobs.",
                "accessLevel": "Read"
            },
            "ListDatasetObjects": {
                "url": "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file",
                "description": "Paginated list API to list dataset objects in a manifest file.",
                "accessLevel": "Read"
            },
            "RunFilterOrSampleDatasetJob": {
                "url": "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering",
                "description": "Filter records from a manifest file using S3 select. Get sample entries based on random sampling.",
                "accessLevel": "Write"
            },
            "RunGenerateManifestByCrawlingJob": {
                "url": "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file",
                "description": "List a S3 prefix and create manifest files from objects in that location.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Get status of GroundTruthLabeling Jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toDescribeConsoleJob() {
        this.add('groundtruthlabeling:DescribeConsoleJob');
        return this;
    }
    /**
     * Paginated list API to list dataset objects in a manifest file.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toListDatasetObjects() {
        this.add('groundtruthlabeling:ListDatasetObjects');
        return this;
    }
    /**
     * Filter records from a manifest file using S3 select. Get sample entries based on random sampling.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-data-filtering
     */
    toRunFilterOrSampleDatasetJob() {
        this.add('groundtruthlabeling:RunFilterOrSampleDatasetJob');
        return this;
    }
    /**
     * List a S3 prefix and create manifest files from objects in that location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data-input.html#sms-console-create-manifest-file
     */
    toRunGenerateManifestByCrawlingJob() {
        this.add('groundtruthlabeling:RunGenerateManifestByCrawlingJob');
        return this;
    }
}
exports.Groundtruthlabeling = Groundtruthlabeling;
//# sourceMappingURL=data:application/json;base64,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