"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tag = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [tag](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonresourcegrouptaggingapi.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Tag extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [tag](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonresourcegrouptaggingapi.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'tag';
        this.actionList = {
            "DescribeReportCreation": {
                "url": "https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_DescribeReportCreation.html",
                "description": "Describe the status of the StartReportCreation operation.",
                "accessLevel": "Read"
            },
            "GetComplianceSummary": {
                "url": "https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetComplianceSummary.html",
                "description": "Get a table that shows counts of resources that are noncompliant with their effective tag policies.",
                "accessLevel": "Read"
            },
            "GetResources": {
                "url": "https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html",
                "description": "Get tagged AWS resources that match the given tag filters",
                "accessLevel": "Read"
            },
            "GetTagKeys": {
                "url": "https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagKeys.html",
                "description": "Get all tagKeys for the account in the specific region",
                "accessLevel": "Read"
            },
            "GetTagValues": {
                "url": "https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagValues.html",
                "description": "Get all tagValues for the account in the specific region",
                "accessLevel": "Read"
            },
            "StartReportCreation": {
                "url": "https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_StartReportCreation.html",
                "description": "Generate a report that lists all tagged resources in accounts across your organization, and whether each resource is compliant with the effective tag policy.",
                "accessLevel": "Write"
            },
            "TagResources": {
                "url": "https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_TagResources.html",
                "description": "Add tags to AWS resources",
                "accessLevel": "Tagging"
            },
            "UntagResources": {
                "url": "https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_UntagResources.html",
                "description": "Remove tags from AWS resources",
                "accessLevel": "Tagging"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Describe the status of the StartReportCreation operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_DescribeReportCreation.html
     */
    toDescribeReportCreation() {
        this.add('tag:DescribeReportCreation');
        return this;
    }
    /**
     * Get a table that shows counts of resources that are noncompliant with their effective tag policies.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetComplianceSummary.html
     */
    toGetComplianceSummary() {
        this.add('tag:GetComplianceSummary');
        return this;
    }
    /**
     * Get tagged AWS resources that match the given tag filters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html
     */
    toGetResources() {
        this.add('tag:GetResources');
        return this;
    }
    /**
     * Get all tagKeys for the account in the specific region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagKeys.html
     */
    toGetTagKeys() {
        this.add('tag:GetTagKeys');
        return this;
    }
    /**
     * Get all tagValues for the account in the specific region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagValues.html
     */
    toGetTagValues() {
        this.add('tag:GetTagValues');
        return this;
    }
    /**
     * Generate a report that lists all tagged resources in accounts across your organization, and whether each resource is compliant with the effective tag policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_StartReportCreation.html
     */
    toStartReportCreation() {
        this.add('tag:StartReportCreation');
        return this;
    }
    /**
     * Add tags to AWS resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_TagResources.html
     */
    toTagResources() {
        this.add('tag:TagResources');
        return this;
    }
    /**
     * Remove tags from AWS resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_UntagResources.html
     */
    toUntagResources() {
        this.add('tag:UntagResources');
        return this;
    }
}
exports.Tag = Tag;
//# sourceMappingURL=data:application/json;base64,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