"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Discovery = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [discovery](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscovery.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Discovery extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [discovery](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_applicationdiscovery.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'discovery';
        this.actionList = {
            "AssociateConfigurationItemsToApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html",
                "description": "Associates one or more configuration items with an application.",
                "accessLevel": "Write"
            },
            "BatchDeleteImportData": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html",
                "description": "Deletes one or more Migration Hub import tasks, each identified by their import ID. Each import task has a number of records, which can identify servers or applications.",
                "accessLevel": "Write"
            },
            "CreateApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html",
                "description": "Creates an application with the given name and description.",
                "accessLevel": "Write"
            },
            "CreateTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html",
                "description": "Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.",
                "accessLevel": "Tagging"
            },
            "DeleteApplications": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html",
                "description": "Deletes a list of applications and their associations with configuration items.",
                "accessLevel": "Write"
            },
            "DeleteTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html",
                "description": "Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.",
                "accessLevel": "Tagging"
            },
            "DescribeAgents": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html",
                "description": "Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID.",
                "accessLevel": "Read"
            },
            "DescribeConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html",
                "description": "Retrieves attributes for a list of configuration item IDs. All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards.",
                "accessLevel": "Read"
            },
            "DescribeContinuousExports": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html",
                "description": "Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.",
                "accessLevel": "Read"
            },
            "DescribeExportConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html",
                "description": "Retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes.",
                "accessLevel": "Read"
            },
            "DescribeExportTasks": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html",
                "description": "Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.",
                "accessLevel": "Read"
            },
            "DescribeImportTasks": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html",
                "description": "Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.",
                "accessLevel": "List"
            },
            "DescribeTags": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html",
                "description": "Retrieves a list of configuration items that are tagged with a specific tag. Or retrieves a list of all tags assigned to a specific configuration item.",
                "accessLevel": "Read"
            },
            "DisassociateConfigurationItemsFromApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html",
                "description": "Disassociates one or more configuration items from an application.",
                "accessLevel": "Write"
            },
            "ExportConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html",
                "description": "Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance.",
                "accessLevel": "Write"
            },
            "GetDiscoverySummary": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html",
                "description": "Retrieves a short summary of discovered assets.",
                "accessLevel": "Read"
            },
            "ListConfigurations": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html",
                "description": "Retrieves a list of configuration items according to criteria you specify in a filter. The filter criteria identify relationship requirements.",
                "accessLevel": "List"
            },
            "ListServerNeighbors": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html",
                "description": "Retrieves a list of servers which are one network hop away from a specified server.",
                "accessLevel": "List"
            },
            "StartContinuousExport": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html",
                "description": "Start the continuous flow of agent's discovered data into Amazon Athena.",
                "accessLevel": "Write"
            },
            "StartDataCollectionByAgentIds": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html",
                "description": "Instructs the specified agents or Connectors to start collecting data.",
                "accessLevel": "Write"
            },
            "StartExportTask": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html",
                "description": "Export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format.",
                "accessLevel": "Write"
            },
            "StartImportTask": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html",
                "description": "Starts an import task. The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status.",
                "accessLevel": "Write"
            },
            "StopContinuousExport": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html",
                "description": "Stop the continuous flow of agent's discovered data into Amazon Athena.",
                "accessLevel": "Write"
            },
            "StopDataCollectionByAgentIds": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html",
                "description": "Instructs the specified agents or Connectors to stop collecting data.",
                "accessLevel": "Write"
            },
            "UpdateApplication": {
                "url": "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html",
                "description": "Updates metadata about an application.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Associates one or more configuration items with an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_AssociateConfigurationItemsToApplication.html
     */
    toAssociateConfigurationItemsToApplication() {
        this.add('discovery:AssociateConfigurationItemsToApplication');
        return this;
    }
    /**
     * Deletes one or more Migration Hub import tasks, each identified by their import ID. Each import task has a number of records, which can identify servers or applications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_BatchDeleteImportData.html
     */
    toBatchDeleteImportData() {
        this.add('discovery:BatchDeleteImportData');
        return this;
    }
    /**
     * Creates an application with the given name and description.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication() {
        this.add('discovery:CreateApplication');
        return this;
    }
    /**
     * Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_CreateTags.html
     */
    toCreateTags() {
        this.add('discovery:CreateTags');
        return this;
    }
    /**
     * Deletes a list of applications and their associations with configuration items.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteApplications.html
     */
    toDeleteApplications() {
        this.add('discovery:DeleteApplications');
        return this;
    }
    /**
     * Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DeleteTags.html
     */
    toDeleteTags() {
        this.add('discovery:DeleteTags');
        return this;
    }
    /**
     * Lists agents or the Connector by ID or lists all agents/Connectors associated with your user account if you did not specify an ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html
     */
    toDescribeAgents() {
        this.add('discovery:DescribeAgents');
        return this;
    }
    /**
     * Retrieves attributes for a list of configuration item IDs. All of the supplied IDs must be for the same asset type (server, application, process, or connection). Output fields are specific to the asset type selected. For example, the output for a server configuration item includes a list of attributes about the server, such as host name, operating system, and number of network cards.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeConfigurations.html
     */
    toDescribeConfigurations() {
        this.add('discovery:DescribeConfigurations');
        return this;
    }
    /**
     * Lists exports as specified by ID. All continuous exports associated with your user account can be listed if you call DescribeContinuousExports as is without passing any parameters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeContinuousExports.html
     */
    toDescribeContinuousExports() {
        this.add('discovery:DescribeContinuousExports');
        return this;
    }
    /**
     * Retrieves the status of a given export process. You can retrieve status from a maximum of 100 processes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportConfigurations.html
     */
    toDescribeExportConfigurations() {
        this.add('discovery:DescribeExportConfigurations');
        return this;
    }
    /**
     * Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html
     */
    toDescribeExportTasks() {
        this.add('discovery:DescribeExportTasks');
        return this;
    }
    /**
     * Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeImportTasks.html
     */
    toDescribeImportTasks() {
        this.add('discovery:DescribeImportTasks');
        return this;
    }
    /**
     * Retrieves a list of configuration items that are tagged with a specific tag. Or retrieves a list of all tags assigned to a specific configuration item.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeTags.html
     */
    toDescribeTags() {
        this.add('discovery:DescribeTags');
        return this;
    }
    /**
     * Disassociates one or more configuration items from an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DisassociateConfigurationItemsFromApplication.html
     */
    toDisassociateConfigurationItemsFromApplication() {
        this.add('discovery:DisassociateConfigurationItemsFromApplication');
        return this;
    }
    /**
     * Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportConfigurations.html
     */
    toExportConfigurations() {
        this.add('discovery:ExportConfigurations');
        return this;
    }
    /**
     * Retrieves a short summary of discovered assets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_GetDiscoverySummary.html
     */
    toGetDiscoverySummary() {
        this.add('discovery:GetDiscoverySummary');
        return this;
    }
    /**
     * Retrieves a list of configuration items according to criteria you specify in a filter. The filter criteria identify relationship requirements.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListConfigurations.html
     */
    toListConfigurations() {
        this.add('discovery:ListConfigurations');
        return this;
    }
    /**
     * Retrieves a list of servers which are one network hop away from a specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ListServerNeighbors.html
     */
    toListServerNeighbors() {
        this.add('discovery:ListServerNeighbors');
        return this;
    }
    /**
     * Start the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartContinuousExport.html
     */
    toStartContinuousExport() {
        this.add('discovery:StartContinuousExport');
        return this;
    }
    /**
     * Instructs the specified agents or Connectors to start collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartDataCollectionByAgentIds.html
     */
    toStartDataCollectionByAgentIds() {
        this.add('discovery:StartDataCollectionByAgentIds');
        return this;
    }
    /**
     * Export the configuration data about discovered configuration items and relationships to an S3 bucket in a specified format.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html
     */
    toStartExportTask() {
        this.add('discovery:StartExportTask');
        return this;
    }
    /**
     * Starts an import task. The Migration Hub import feature allows you to import details of your on-premises environment directly into AWS without having to use the Application Discovery Service (ADS) tools such as the Discovery Connector or Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data including the ability to group your devices as applications and track their migration status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartImportTask.html
     */
    toStartImportTask() {
        this.add('discovery:StartImportTask');
        return this;
    }
    /**
     * Stop the continuous flow of agent's discovered data into Amazon Athena.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopContinuousExport.html
     */
    toStopContinuousExport() {
        this.add('discovery:StopContinuousExport');
        return this;
    }
    /**
     * Instructs the specified agents or Connectors to stop collecting data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StopDataCollectionByAgentIds.html
     */
    toStopDataCollectionByAgentIds() {
        this.add('discovery:StopDataCollectionByAgentIds');
        return this;
    }
    /**
     * Updates metadata about an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication() {
        this.add('discovery:UpdateApplication');
        return this;
    }
}
exports.Discovery = Discovery;
//# sourceMappingURL=data:application/json;base64,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