"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceImageBuildingService = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-image-building-service](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceimagebuildingservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceImageBuildingService extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-image-building-service](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceimagebuildingservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace-image-building-service';
        this.actionList = {
            "DescribeBuilds": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html",
                "description": "Describes Image Builds identified by a build Id",
                "accessLevel": "Read"
            },
            "ListBuilds": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html",
                "description": "Lists Image Builds.",
                "accessLevel": "Read"
            },
            "StartBuild": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html",
                "description": "Starts an Image Build",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Describes Image Builds identified by a build Id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html
     */
    toDescribeBuilds() {
        this.add('aws-marketplace-image-building-service:DescribeBuilds');
        return this;
    }
    /**
     * Lists Image Builds.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html
     */
    toListBuilds() {
        this.add('aws-marketplace-image-building-service:ListBuilds');
        return this;
    }
    /**
     * Starts an Image Build
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/api-reference.html
     */
    toStartBuild() {
        this.add('aws-marketplace-image-building-service:StartBuild');
        return this;
    }
}
exports.AwsMarketplaceImageBuildingService = AwsMarketplaceImageBuildingService;
//# sourceMappingURL=data:application/json;base64,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