"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceProcurementSystemsIntegration = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-procurement-systems-integration](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceprocurementsystemsintegration.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceProcurementSystemsIntegration extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-procurement-systems-integration](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsmarketplaceprocurementsystemsintegration.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace-procurement-systems-integration';
        this.actionList = {
            "DescribeProcurementSystemConfiguration": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html",
                "description": "Describes the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.",
                "accessLevel": "Read"
            },
            "PutProcurementSystemConfiguration": {
                "url": "https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html",
                "description": "Creates or updates the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Describes the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html
     */
    toDescribeProcurementSystemConfiguration() {
        this.add('aws-marketplace-procurement-systems-integration:DescribeProcurementSystemConfiguration');
        return this;
    }
    /**
     * Creates or updates the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html
     */
    toPutProcurementSystemConfiguration() {
        this.add('aws-marketplace-procurement-systems-integration:PutProcurementSystemConfiguration');
        return this;
    }
}
exports.AwsMarketplaceProcurementSystemsIntegration = AwsMarketplaceProcurementSystemsIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzbWFya2V0cGxhY2Vwcm9jdXJlbWVudHN5c3RlbXNpbnRlZ3JhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImF3c21hcmtldHBsYWNlcHJvY3VyZW1lbnRzeXN0ZW1zaW50ZWdyYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsc0NBQW9FO0FBRXBFOzs7O0dBSUc7QUFDSCxNQUFhLDJDQUE0QyxTQUFRLHdCQUFlO0lBZ0I5RTs7OztPQUlHO0lBQ0gsWUFBYSxHQUFZO1FBQ3ZCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQXJCTixrQkFBYSxHQUFHLGlEQUFpRCxDQUFDO1FBQy9ELGVBQVUsR0FBWTtZQUM5Qix3Q0FBd0MsRUFBRTtnQkFDeEMsS0FBSyxFQUFFLGdHQUFnRztnQkFDdkcsYUFBYSxFQUFFLDZPQUE2TztnQkFDNVAsYUFBYSxFQUFFLE1BQU07YUFDdEI7WUFDRCxtQ0FBbUMsRUFBRTtnQkFDbkMsS0FBSyxFQUFFLGdHQUFnRztnQkFDdkcsYUFBYSxFQUFFLHNQQUFzUDtnQkFDclEsYUFBYSxFQUFFLE9BQU87YUFDdkI7U0FDRixDQUFDO1FBQ1Esa0JBQWEsR0FBa0IsRUFBRSxDQUFDO0lBUzVDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3Q0FBd0M7UUFDN0MsSUFBSSxDQUFDLEdBQUcsQ0FBQyx3RkFBd0YsQ0FBQyxDQUFDO1FBQ25HLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1DQUFtQztRQUN4QyxJQUFJLENBQUMsR0FBRyxDQUFDLG1GQUFtRixDQUFDLENBQUM7UUFDOUYsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0NBQ0Y7QUFoREQsa0dBZ0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWN0aW9ucywgUG9saWN5U3RhdGVtZW50LCBSZXNvdXJjZVR5cGVzIH0gZnJvbSBcIi4uL3NoYXJlZFwiO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbYXdzLW1hcmtldHBsYWNlLXByb2N1cmVtZW50LXN5c3RlbXMtaW50ZWdyYXRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9saXN0X2F3c21hcmtldHBsYWNlcHJvY3VyZW1lbnRzeXN0ZW1zaW50ZWdyYXRpb24uaHRtbCkuXG4gKlxuICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gKi9cbmV4cG9ydCBjbGFzcyBBd3NNYXJrZXRwbGFjZVByb2N1cmVtZW50U3lzdGVtc0ludGVncmF0aW9uIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnYXdzLW1hcmtldHBsYWNlLXByb2N1cmVtZW50LXN5c3RlbXMtaW50ZWdyYXRpb24nO1xuICBwcm90ZWN0ZWQgYWN0aW9uTGlzdDogQWN0aW9ucyA9IHtcbiAgICBcIkRlc2NyaWJlUHJvY3VyZW1lbnRTeXN0ZW1Db25maWd1cmF0aW9uXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL21hcmtldHBsYWNlL2xhdGVzdC9idXllcmd1aWRlL3Byb2N1cmVtZW50LXN5c3RlbXMtaW50ZWdyYXRpb24uaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkRlc2NyaWJlcyB0aGUgUHJvY3VyZW1lbnQgU3lzdGVtIGludGVncmF0aW9uIGNvbmZpZ3VyYXRpb24gKGUuZy4gQ291cGEpIGZvciB0aGUgaW5kaXZpZHVhbCBhY2NvdW50LCBvciBmb3IgdGhlIGVudGlyZSBBV1MgT3JnYW5pemF0aW9uIGlmIG9uZSBleGlzdHMuIFRoaXMgYWN0aW9uIGNhbiBvbmx5IGJlIHBlcmZvcm1lZCBieSB0aGUgbWFzdGVyIGFjY291bnQgaWYgdXNpbmcgYW4gQVdTIE9yZ2FuaXphdGlvbi5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJSZWFkXCJcbiAgICB9LFxuICAgIFwiUHV0UHJvY3VyZW1lbnRTeXN0ZW1Db25maWd1cmF0aW9uXCI6IHtcbiAgICAgIFwidXJsXCI6IFwiaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL21hcmtldHBsYWNlL2xhdGVzdC9idXllcmd1aWRlL3Byb2N1cmVtZW50LXN5c3RlbXMtaW50ZWdyYXRpb24uaHRtbFwiLFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiBcIkNyZWF0ZXMgb3IgdXBkYXRlcyB0aGUgUHJvY3VyZW1lbnQgU3lzdGVtIGludGVncmF0aW9uIGNvbmZpZ3VyYXRpb24gKGUuZy4gQ291cGEpIGZvciB0aGUgaW5kaXZpZHVhbCBhY2NvdW50LCBvciBmb3IgdGhlIGVudGlyZSBBV1MgT3JnYW5pemF0aW9uIGlmIG9uZSBleGlzdHMuIFRoaXMgYWN0aW9uIGNhbiBvbmx5IGJlIHBlcmZvcm1lZCBieSB0aGUgbWFzdGVyIGFjY291bnQgaWYgdXNpbmcgYW4gQVdTIE9yZ2FuaXphdGlvbi5cIixcbiAgICAgIFwiYWNjZXNzTGV2ZWxcIjogXCJXcml0ZVwiXG4gICAgfVxuICB9O1xuICBwcm90ZWN0ZWQgcmVzb3VyY2VUeXBlczogUmVzb3VyY2VUeXBlcyA9IHt9O1xuXG4gIC8qKlxuICAgKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW2F3cy1tYXJrZXRwbGFjZS1wcm9jdXJlbWVudC1zeXN0ZW1zLWludGVncmF0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvbGlzdF9hd3NtYXJrZXRwbGFjZXByb2N1cmVtZW50c3lzdGVtc2ludGVncmF0aW9uLmh0bWwpLlxuICAgKlxuICAgKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAgICovXG4gIGNvbnN0cnVjdG9yIChzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIERlc2NyaWJlcyB0aGUgUHJvY3VyZW1lbnQgU3lzdGVtIGludGVncmF0aW9uIGNvbmZpZ3VyYXRpb24gKGUuZy4gQ291cGEpIGZvciB0aGUgaW5kaXZpZHVhbCBhY2NvdW50LCBvciBmb3IgdGhlIGVudGlyZSBBV1MgT3JnYW5pemF0aW9uIGlmIG9uZSBleGlzdHMuIFRoaXMgYWN0aW9uIGNhbiBvbmx5IGJlIHBlcmZvcm1lZCBieSB0aGUgbWFzdGVyIGFjY291bnQgaWYgdXNpbmcgYW4gQVdTIE9yZ2FuaXphdGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9tYXJrZXRwbGFjZS9sYXRlc3QvYnV5ZXJndWlkZS9wcm9jdXJlbWVudC1zeXN0ZW1zLWludGVncmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUHJvY3VyZW1lbnRTeXN0ZW1Db25maWd1cmF0aW9uKCkge1xuICAgIHRoaXMuYWRkKCdhd3MtbWFya2V0cGxhY2UtcHJvY3VyZW1lbnQtc3lzdGVtcy1pbnRlZ3JhdGlvbjpEZXNjcmliZVByb2N1cmVtZW50U3lzdGVtQ29uZmlndXJhdGlvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgb3IgdXBkYXRlcyB0aGUgUHJvY3VyZW1lbnQgU3lzdGVtIGludGVncmF0aW9uIGNvbmZpZ3VyYXRpb24gKGUuZy4gQ291cGEpIGZvciB0aGUgaW5kaXZpZHVhbCBhY2NvdW50LCBvciBmb3IgdGhlIGVudGlyZSBBV1MgT3JnYW5pemF0aW9uIGlmIG9uZSBleGlzdHMuIFRoaXMgYWN0aW9uIGNhbiBvbmx5IGJlIHBlcmZvcm1lZCBieSB0aGUgbWFzdGVyIGFjY291bnQgaWYgdXNpbmcgYW4gQVdTIE9yZ2FuaXphdGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vbWFya2V0cGxhY2UvbGF0ZXN0L2J1eWVyZ3VpZGUvcHJvY3VyZW1lbnQtc3lzdGVtcy1pbnRlZ3JhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9QdXRQcm9jdXJlbWVudFN5c3RlbUNvbmZpZ3VyYXRpb24oKSB7XG4gICAgdGhpcy5hZGQoJ2F3cy1tYXJrZXRwbGFjZS1wcm9jdXJlbWVudC1zeXN0ZW1zLWludGVncmF0aW9uOlB1dFByb2N1cmVtZW50U3lzdGVtQ29uZmlndXJhdGlvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG59XG4iXX0=