<header class="hero">

![Logo](_static/reacnetgen.svg)

# ReacNetGenerator

An automatic reaction network generator for reactive molecular dynamics simulation

<a href="/guide/install.html" class="nav-link action-button">Get Started</a>
</header>

<div class="features">

## Trajectory

Processing of MD trajectory containing atomic coordinates or bond orders

## Filtering

Hidden Markov Model (HMM) based noise filtering

## Isomers

Isomers identifying accoarding to SMILES

## Network

Generation of reaction network for visualization using force-directed algorithm

## HTML5

Showing an interactive web page

## Fast

Parallel computing and performance optimization

</div>

<div class="bilitube" data-youtube="TI21SI9YPfo" data-bvid="BV175411N7uG">Loading...</div>

# Citation and contact

ReacNetGenerator: an automatic reaction network generator for reactive molecular dynamic simulations, Phys. Chem. Chem. Phys., 2020, 22 (2): 683–691, doi: [10.1039/C9CP05091D](https://dx.doi.org/10.1039/C9CP05091D)

jinzhe.zeng@rutgers.edu (Jinzhe Zeng), tzhu@lps.ecnu.edu.cn (Tong Zhu)

# Guide and Tutorials

You can install ReacNetGenerator with `conda`:

```sh
conda install reacnetgenerator -c conda-forge
reacnetgenerator -h
```

See [the guide](guide/index) to learn how to install and use ReacNetGenerattor. We also provide [a series of tutorials](tutorial/index) to help you learn ReacNetGenerator.

# Awards
* The First Prize in 2019 (the 11th Session) Shanghai Computer Application Competition for College Students
* The First Prize in 2019 (the 12th Session) Chinese Computer Design Competition for College Students

# Acknowledge
* National Natural Science Foundation of China (Grants No. 91641116)
* National Innovation and Entrepreneurship Training Program for Undergraduate (201910269080)
* ECNU Multifunctional Platform for Innovation (No. 001)



