/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.ref;

import java.util.ArrayList;
import org.jpype.ref.JPypeReference;
import org.jpype.ref.JPypeReferenceQueue;

public class JPypeReferenceSet {
    static final int SIZE = 256;
    ArrayList<Pool> pools = new ArrayList();
    Pool current;
    long context;
    private int items;

    JPypeReferenceSet(long l) {
        this.context = l;
    }

    int size() {
        return this.items;
    }

    synchronized void add(JPypeReference jPypeReference) {
        if (jPypeReference.cleanup == 0L) {
            return;
        }
        ++this.items;
        if (this.current == null) {
            this.current = new Pool(this.pools.size());
            this.pools.add(this.current);
        }
        if (this.current.add(jPypeReference)) {
            this.current = null;
            for (Pool pool : this.pools) {
                if (pool.tail >= 256) continue;
                this.current = pool;
                return;
            }
        }
    }

    synchronized void remove(JPypeReference jPypeReference) {
        if (jPypeReference.cleanup == 0L) {
            return;
        }
        this.pools.get(jPypeReference.pool).remove(jPypeReference);
        --this.items;
        jPypeReference.cleanup = 0L;
        jPypeReference.pool = -1;
    }

    void flush() {
        for (Pool pool : this.pools) {
            for (int i = 0; i < pool.tail; ++i) {
                JPypeReference jPypeReference = pool.entries[i];
                long l = jPypeReference.hostReference;
                long l2 = jPypeReference.cleanup;
                if (l2 == 0L) continue;
                jPypeReference.cleanup = 0L;
                JPypeReferenceQueue.removeHostReference(this.context, l, l2);
            }
            pool.tail = 0;
        }
    }

    static class Pool {
        JPypeReference[] entries = new JPypeReference[256];
        int tail;
        int id;

        Pool(int n) {
            this.id = n;
        }

        boolean add(JPypeReference jPypeReference) {
            jPypeReference.pool = this.id;
            jPypeReference.index = this.tail;
            this.entries[this.tail++] = jPypeReference;
            return this.tail == this.entries.length;
        }

        void remove(JPypeReference jPypeReference) {
            this.entries[jPypeReference.index] = this.entries[--this.tail];
            this.entries[jPypeReference.index].index = jPypeReference.index;
        }
    }
}

