import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization.html#domain DataGoogleOrganization#domain}.
     *
     * @stability stable
     */
    readonly domain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/organization.html#organization DataGoogleOrganization#organization}.
     *
     * @stability stable
     */
    readonly organization?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/organization.html google_organization}.
 *
 * @stability stable
 */
export declare class DataGoogleOrganization extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/organization.html google_organization} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleOrganizationConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get directoryCustomerId(): string;
    private _domain?;
    /**
     * @stability stable
     */
    get domain(): string | undefined;
    /**
     * @stability stable
     */
    set domain(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomain(): void;
    /**
     * @stability stable
     */
    get domainInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lifecycleState(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get orgId(): string;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string | undefined;
    /**
     * @stability stable
     */
    set organization(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrganization(): void;
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
