import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of email addresses to which notifications relating to approval requests should be sent.
     *
     * Notifications relating to a resource will be sent to all emails in the settings of ancestor
     * resources of that resource. A maximum of 50 email addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#notification_emails ProjectAccessApprovalSettings#notification_emails}
     *
     * @stability stable
     */
    readonly notificationEmails?: string[];
    /**
     * Deprecated in favor of 'project_id'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#project ProjectAccessApprovalSettings#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * ID of the project of the access approval settings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#project_id ProjectAccessApprovalSettings#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
    /**
     * enrolled_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#enrolled_services ProjectAccessApprovalSettings#enrolled_services}
     *
     * @stability stable
     */
    readonly enrolledServices: ProjectAccessApprovalSettingsEnrolledServices[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#timeouts ProjectAccessApprovalSettings#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ProjectAccessApprovalSettingsTimeouts;
}
/**
 * @stability stable
 */
export interface ProjectAccessApprovalSettingsEnrolledServices {
    /**
     * The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive): all appengine.googleapis.com bigquery.googleapis.com bigtable.googleapis.com cloudkms.googleapis.com compute.googleapis.com dataflow.googleapis.com iam.googleapis.com pubsub.googleapis.com storage.googleapis.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#cloud_product ProjectAccessApprovalSettings#cloud_product}
     *
     * @stability stable
     */
    readonly cloudProduct: string;
    /**
     * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#enrollment_level ProjectAccessApprovalSettings#enrollment_level}
     *
     * @stability stable
     */
    readonly enrollmentLevel?: string;
}
/**
 * @stability stable
 */
export interface ProjectAccessApprovalSettingsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#create ProjectAccessApprovalSettings#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#delete ProjectAccessApprovalSettings#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html#update ProjectAccessApprovalSettings#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ProjectAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html google_project_access_approval_settings}.
 *
 * @stability stable
 */
export declare class ProjectAccessApprovalSettings extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_access_approval_settings.html google_project_access_approval_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectAccessApprovalSettingsConfig);
    /**
     * @stability stable
     */
    get enrolledAncestor(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _notificationEmails?;
    /**
     * @stability stable
     */
    get notificationEmails(): string[] | undefined;
    /**
     * @stability stable
     */
    set notificationEmails(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetNotificationEmails(): void;
    /**
     * @stability stable
     */
    get notificationEmailsInput(): string[] | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _enrolledServices?;
    /**
     * @stability stable
     */
    get enrolledServices(): ProjectAccessApprovalSettingsEnrolledServices[];
    /**
     * @stability stable
     */
    set enrolledServices(value: ProjectAccessApprovalSettingsEnrolledServices[]);
    /**
     * @stability stable
     */
    get enrolledServicesInput(): ProjectAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ProjectAccessApprovalSettingsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ProjectAccessApprovalSettingsTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ProjectAccessApprovalSettingsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
