"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
/*
 * Stack verification steps:
 * * Verify that the CloudFrontDistribution stack output is of the format 'xxxxxxxxxxxxxx.cloudfront.net'
 */
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-user-pool-domain-cfdist');
const userpool = new lib_1.UserPool(stack, 'UserPool');
const domain = userpool.addDomain('Domain', {
    cognitoDomain: {
        domainPrefix: 'cdk-integ-user-pool-domain',
    },
});
new core_1.CfnOutput(stack, 'Domain', {
    value: domain.domainName,
});
new core_1.CfnOutput(stack, 'CloudFrontDomainName', {
    value: domain.cloudFrontDomainName,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudXNlci1wb29sLWRvbWFpbi1jZmRpc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy51c2VyLXBvb2wtZG9tYWluLWNmZGlzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLHdDQUFzRDtBQUN0RCxnQ0FBa0M7QUFFbEM7OztHQUdHO0FBRUgsTUFBTSxHQUFHLEdBQUcsSUFBSSxVQUFHLEVBQUUsQ0FBQztBQUN0QixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssQ0FBQyxHQUFHLEVBQUUsK0JBQStCLENBQUMsQ0FBQztBQUU5RCxNQUFNLFFBQVEsR0FBRyxJQUFJLGNBQVEsQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLENBQUM7QUFFakQsTUFBTSxNQUFNLEdBQUcsUUFBUSxDQUFDLFNBQVMsQ0FBQyxRQUFRLEVBQUU7SUFDMUMsYUFBYSxFQUFFO1FBQ2IsWUFBWSxFQUFFLDRCQUE0QjtLQUMzQztDQUNGLENBQUMsQ0FBQztBQUVILElBQUksZ0JBQVMsQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFO0lBQzdCLEtBQUssRUFBRSxNQUFNLENBQUMsVUFBVTtDQUN6QixDQUFDLENBQUM7QUFFSCxJQUFJLGdCQUFTLENBQUMsS0FBSyxFQUFFLHNCQUFzQixFQUFFO0lBQzNDLEtBQUssRUFBRSxNQUFNLENBQUMsb0JBQW9CO0NBQ25DLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgQ2ZuT3V0cHV0LCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgVXNlclBvb2wgfSBmcm9tICcuLi9saWInO1xuXG4vKlxuICogU3RhY2sgdmVyaWZpY2F0aW9uIHN0ZXBzOlxuICogKiBWZXJpZnkgdGhhdCB0aGUgQ2xvdWRGcm9udERpc3RyaWJ1dGlvbiBzdGFjayBvdXRwdXQgaXMgb2YgdGhlIGZvcm1hdCAneHh4eHh4eHh4eHh4eHguY2xvdWRmcm9udC5uZXQnXG4gKi9cblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCAnaW50ZWctdXNlci1wb29sLWRvbWFpbi1jZmRpc3QnKTtcblxuY29uc3QgdXNlcnBvb2wgPSBuZXcgVXNlclBvb2woc3RhY2ssICdVc2VyUG9vbCcpO1xuXG5jb25zdCBkb21haW4gPSB1c2VycG9vbC5hZGREb21haW4oJ0RvbWFpbicsIHtcbiAgY29nbml0b0RvbWFpbjoge1xuICAgIGRvbWFpblByZWZpeDogJ2Nkay1pbnRlZy11c2VyLXBvb2wtZG9tYWluJyxcbiAgfSxcbn0pO1xuXG5uZXcgQ2ZuT3V0cHV0KHN0YWNrLCAnRG9tYWluJywge1xuICB2YWx1ZTogZG9tYWluLmRvbWFpbk5hbWUsXG59KTtcblxubmV3IENmbk91dHB1dChzdGFjaywgJ0Nsb3VkRnJvbnREb21haW5OYW1lJywge1xuICB2YWx1ZTogZG9tYWluLmNsb3VkRnJvbnREb21haW5OYW1lLFxufSk7Il19