# AUTOGENERATED! DO NOT EDIT! File to edit: 02_pandas.ipynb (unless otherwise specified).

__all__ = ['ends', 'group_by_summary', 'datetime_from_timestamp']

# Cell
import pandas as pd
import pandas_flavor
from datetime import datetime
import typing as T

# Cell
@pandas_flavor.register_dataframe_method
@pandas_flavor.register_series_method
def ends(self, n:int=3)-> pd.DataFrame:
    """
    Combines the .head and .tail methods to show both ends
    of a pd.DataFrame.

    Options:
    * n: number of rows to show for the head and tail. The resulting
         DataFrame will have 2*n rows, unless the df has <2*n rows.
    """
    return pd.concat([self.head(n), self.tail(n)], axis=0).drop_duplicates()

# Cell
@pandas_flavor.register_dataframe_method
def group_by_summary(self, by:T.Union[T.AnyStr, T.List], filter_cols:T.Union[None, T.List[str]]=None)-> pd.DataFrame:
    """

    """
    if not filter_cols:
        filter_cols = self.columns[~self.columns.isin([by] if isinstance(by, str) else by)]
    return self.groupby(by)[filter_cols].agg(['mean','median','sem','std','count'])

# Cell
def datetime_from_timestamp(s:pd.Series, ts_type:str='ms') -> pd.Series:
    lookup = {
        'ms':1e3,
        's':1,
        'ns': 1e6
    }
    return s.map(lambda x: datetime.fromtimestamp(x/lookup[ts_type]))