import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 */
export interface CfnAnalysisProps {
    /**
     * `AWS::QuickSight::Analysis.AnalysisId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-analysisid
     * @external
     */
    readonly analysisId: string;
    /**
     * `AWS::QuickSight::Analysis.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-awsaccountid
     * @external
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Analysis.Errors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-errors
     * @external
     */
    readonly errors?: Array<CfnAnalysis.AnalysisErrorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Analysis.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-parameters
     * @external
     */
    readonly parameters?: CfnAnalysis.ParametersProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-permissions
     * @external
     */
    readonly permissions?: Array<CfnAnalysis.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.SourceEntity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-sourceentity
     * @external
     */
    readonly sourceEntity?: CfnAnalysis.AnalysisSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Analysis.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Analysis.ThemeArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-themearn
     * @external
     */
    readonly themeArn?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare class CfnAnalysis extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Analysis";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAnalysis;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute DataSetArns
     */
    readonly attrDataSetArns: string[];
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @external
     * @cloudformationAttribute Sheets
     */
    readonly attrSheets: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Status
     */
    readonly attrStatus: string;
    /**
     * `AWS::QuickSight::Analysis.AnalysisId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-analysisid
     * @external
     */
    analysisId: string;
    /**
     * `AWS::QuickSight::Analysis.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-awsaccountid
     * @external
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Analysis.Errors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-errors
     * @external
     */
    errors: Array<CfnAnalysis.AnalysisErrorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Analysis.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-parameters
     * @external
     */
    parameters: CfnAnalysis.ParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-permissions
     * @external
     */
    permissions: Array<CfnAnalysis.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.SourceEntity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-sourceentity
     * @external
     */
    sourceEntity: CfnAnalysis.AnalysisSourceEntityProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Analysis.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Analysis.ThemeArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html#cfn-quicksight-analysis-themearn
     * @external
     */
    themeArn: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Analysis`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAnalysisProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html
     * @external
     */
    interface AnalysisErrorProperty {
        /**
         * `CfnAnalysis.AnalysisErrorProperty.Message`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-message
         * @external
         */
        readonly message?: string;
        /**
         * `CfnAnalysis.AnalysisErrorProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html#cfn-quicksight-analysis-analysiserror-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html
     * @external
     */
    interface AnalysisSourceEntityProperty {
        /**
         * `CfnAnalysis.AnalysisSourceEntityProperty.SourceTemplate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html#cfn-quicksight-analysis-analysissourceentity-sourcetemplate
         * @external
         */
        readonly sourceTemplate?: CfnAnalysis.AnalysisSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html
     * @external
     */
    interface AnalysisSourceTemplateProperty {
        /**
         * `CfnAnalysis.AnalysisSourceTemplateProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnAnalysis.AnalysisSourceTemplateProperty.DataSetReferences`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html#cfn-quicksight-analysis-analysissourcetemplate-datasetreferences
         * @external
         */
        readonly dataSetReferences: Array<CfnAnalysis.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html
     * @external
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnAnalysis.DataSetReferenceProperty.DataSetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetarn
         * @external
         */
        readonly dataSetArn: string;
        /**
         * `CfnAnalysis.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html#cfn-quicksight-analysis-datasetreference-datasetplaceholder
         * @external
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html
     * @external
     */
    interface DateTimeParameterProperty {
        /**
         * `CfnAnalysis.DateTimeParameterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnAnalysis.DateTimeParameterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html#cfn-quicksight-analysis-datetimeparameter-values
         * @external
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html
     * @external
     */
    interface DecimalParameterProperty {
        /**
         * `CfnAnalysis.DecimalParameterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnAnalysis.DecimalParameterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html#cfn-quicksight-analysis-decimalparameter-values
         * @external
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html
     * @external
     */
    interface IntegerParameterProperty {
        /**
         * `CfnAnalysis.IntegerParameterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html#cfn-quicksight-analysis-integerparameter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnAnalysis.IntegerParameterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html#cfn-quicksight-analysis-integerparameter-values
         * @external
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html
     * @external
     */
    interface ParametersProperty {
        /**
         * `CfnAnalysis.ParametersProperty.DateTimeParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-datetimeparameters
         * @external
         */
        readonly dateTimeParameters?: Array<CfnAnalysis.DateTimeParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.DecimalParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-decimalparameters
         * @external
         */
        readonly decimalParameters?: Array<CfnAnalysis.DecimalParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.IntegerParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-integerparameters
         * @external
         */
        readonly integerParameters?: Array<CfnAnalysis.IntegerParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAnalysis.ParametersProperty.StringParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html#cfn-quicksight-analysis-parameters-stringparameters
         * @external
         */
        readonly stringParameters?: Array<CfnAnalysis.StringParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html
     * @external
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnAnalysis.ResourcePermissionProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-actions
         * @external
         */
        readonly actions: string[];
        /**
         * `CfnAnalysis.ResourcePermissionProperty.Principal`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html#cfn-quicksight-analysis-resourcepermission-principal
         * @external
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html
     * @external
     */
    interface SheetProperty {
        /**
         * `CfnAnalysis.SheetProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html#cfn-quicksight-analysis-sheet-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnAnalysis.SheetProperty.SheetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html#cfn-quicksight-analysis-sheet-sheetid
         * @external
         */
        readonly sheetId?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Analysis`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html
 * @external
 * @cloudformationResource AWS::QuickSight::Analysis
 */
export declare namespace CfnAnalysis {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html
     * @external
     */
    interface StringParameterProperty {
        /**
         * `CfnAnalysis.StringParameterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html#cfn-quicksight-analysis-stringparameter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnAnalysis.StringParameterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html#cfn-quicksight-analysis-stringparameter-values
         * @external
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 */
export interface CfnDashboardProps {
    /**
     * `AWS::QuickSight::Dashboard.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-awsaccountid
     * @external
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardid
     * @external
     */
    readonly dashboardId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardPublishOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardpublishoptions
     * @external
     */
    readonly dashboardPublishOptions?: CfnDashboard.DashboardPublishOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Dashboard.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-parameters
     * @external
     */
    readonly parameters?: CfnDashboard.ParametersProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-permissions
     * @external
     */
    readonly permissions?: Array<CfnDashboard.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.SourceEntity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-sourceentity
     * @external
     */
    readonly sourceEntity?: CfnDashboard.DashboardSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Dashboard.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Dashboard.ThemeArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-themearn
     * @external
     */
    readonly themeArn?: string;
    /**
     * `AWS::QuickSight::Dashboard.VersionDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-versiondescription
     * @external
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare class CfnDashboard extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Dashboard";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDashboard;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastPublishedTime
     */
    readonly attrLastPublishedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * `AWS::QuickSight::Dashboard.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-awsaccountid
     * @external
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardid
     * @external
     */
    dashboardId: string;
    /**
     * `AWS::QuickSight::Dashboard.DashboardPublishOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-dashboardpublishoptions
     * @external
     */
    dashboardPublishOptions: CfnDashboard.DashboardPublishOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-parameters
     * @external
     */
    parameters: CfnDashboard.ParametersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-permissions
     * @external
     */
    permissions: Array<CfnDashboard.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.SourceEntity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-sourceentity
     * @external
     */
    sourceEntity: CfnDashboard.DashboardSourceEntityProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Dashboard.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Dashboard.ThemeArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-themearn
     * @external
     */
    themeArn: string | undefined;
    /**
     * `AWS::QuickSight::Dashboard.VersionDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html#cfn-quicksight-dashboard-versiondescription
     * @external
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Dashboard`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDashboardProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html
     * @external
     */
    interface AdHocFilteringOptionProperty {
        /**
         * `CfnDashboard.AdHocFilteringOptionProperty.AvailabilityStatus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-adhocfilteringoption.html#cfn-quicksight-dashboard-adhocfilteringoption-availabilitystatus
         * @external
         */
        readonly availabilityStatus?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboarderror.html
     * @external
     */
    interface DashboardErrorProperty {
        /**
         * `CfnDashboard.DashboardErrorProperty.Message`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboarderror.html#cfn-quicksight-dashboard-dashboarderror-message
         * @external
         */
        readonly message?: string;
        /**
         * `CfnDashboard.DashboardErrorProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboarderror.html#cfn-quicksight-dashboard-dashboarderror-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html
     * @external
     */
    interface DashboardPublishOptionsProperty {
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.AdHocFilteringOption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-adhocfilteringoption
         * @external
         */
        readonly adHocFilteringOption?: CfnDashboard.AdHocFilteringOptionProperty | cdk.IResolvable;
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.ExportToCSVOption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-exporttocsvoption
         * @external
         */
        readonly exportToCsvOption?: CfnDashboard.ExportToCSVOptionProperty | cdk.IResolvable;
        /**
         * `CfnDashboard.DashboardPublishOptionsProperty.SheetControlsOption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardpublishoptions.html#cfn-quicksight-dashboard-dashboardpublishoptions-sheetcontrolsoption
         * @external
         */
        readonly sheetControlsOption?: CfnDashboard.SheetControlsOptionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html
     * @external
     */
    interface DashboardSourceEntityProperty {
        /**
         * `CfnDashboard.DashboardSourceEntityProperty.SourceTemplate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourceentity.html#cfn-quicksight-dashboard-dashboardsourceentity-sourcetemplate
         * @external
         */
        readonly sourceTemplate?: CfnDashboard.DashboardSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html
     * @external
     */
    interface DashboardSourceTemplateProperty {
        /**
         * `CfnDashboard.DashboardSourceTemplateProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html#cfn-quicksight-dashboard-dashboardsourcetemplate-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnDashboard.DashboardSourceTemplateProperty.DataSetReferences`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardsourcetemplate.html#cfn-quicksight-dashboard-dashboardsourcetemplate-datasetreferences
         * @external
         */
        readonly dataSetReferences: Array<CfnDashboard.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html
     * @external
     */
    interface DashboardVersionProperty {
        /**
         * `CfnDashboard.DashboardVersionProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-arn
         * @external
         */
        readonly arn?: string;
        /**
         * `CfnDashboard.DashboardVersionProperty.CreatedTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-createdtime
         * @external
         */
        readonly createdTime?: string;
        /**
         * `CfnDashboard.DashboardVersionProperty.DataSetArns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-datasetarns
         * @external
         */
        readonly dataSetArns?: string[];
        /**
         * `CfnDashboard.DashboardVersionProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnDashboard.DashboardVersionProperty.Errors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-errors
         * @external
         */
        readonly errors?: Array<CfnDashboard.DashboardErrorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.DashboardVersionProperty.Sheets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-sheets
         * @external
         */
        readonly sheets?: Array<CfnDashboard.SheetProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.DashboardVersionProperty.SourceEntityArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-sourceentityarn
         * @external
         */
        readonly sourceEntityArn?: string;
        /**
         * `CfnDashboard.DashboardVersionProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-status
         * @external
         */
        readonly status?: string;
        /**
         * `CfnDashboard.DashboardVersionProperty.ThemeArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-themearn
         * @external
         */
        readonly themeArn?: string;
        /**
         * `CfnDashboard.DashboardVersionProperty.VersionNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-dashboardversion.html#cfn-quicksight-dashboard-dashboardversion-versionnumber
         * @external
         */
        readonly versionNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html
     * @external
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnDashboard.DataSetReferenceProperty.DataSetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html#cfn-quicksight-dashboard-datasetreference-datasetarn
         * @external
         */
        readonly dataSetArn: string;
        /**
         * `CfnDashboard.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datasetreference.html#cfn-quicksight-dashboard-datasetreference-datasetplaceholder
         * @external
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html
     * @external
     */
    interface DateTimeParameterProperty {
        /**
         * `CfnDashboard.DateTimeParameterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html#cfn-quicksight-dashboard-datetimeparameter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnDashboard.DateTimeParameterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-datetimeparameter.html#cfn-quicksight-dashboard-datetimeparameter-values
         * @external
         */
        readonly values: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html
     * @external
     */
    interface DecimalParameterProperty {
        /**
         * `CfnDashboard.DecimalParameterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html#cfn-quicksight-dashboard-decimalparameter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnDashboard.DecimalParameterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-decimalparameter.html#cfn-quicksight-dashboard-decimalparameter-values
         * @external
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html
     * @external
     */
    interface ExportToCSVOptionProperty {
        /**
         * `CfnDashboard.ExportToCSVOptionProperty.AvailabilityStatus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-exporttocsvoption.html#cfn-quicksight-dashboard-exporttocsvoption-availabilitystatus
         * @external
         */
        readonly availabilityStatus?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html
     * @external
     */
    interface IntegerParameterProperty {
        /**
         * `CfnDashboard.IntegerParameterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html#cfn-quicksight-dashboard-integerparameter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnDashboard.IntegerParameterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-integerparameter.html#cfn-quicksight-dashboard-integerparameter-values
         * @external
         */
        readonly values: number[] | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html
     * @external
     */
    interface ParametersProperty {
        /**
         * `CfnDashboard.ParametersProperty.DateTimeParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-datetimeparameters
         * @external
         */
        readonly dateTimeParameters?: Array<CfnDashboard.DateTimeParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.DecimalParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-decimalparameters
         * @external
         */
        readonly decimalParameters?: Array<CfnDashboard.DecimalParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.IntegerParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-integerparameters
         * @external
         */
        readonly integerParameters?: Array<CfnDashboard.IntegerParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDashboard.ParametersProperty.StringParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-parameters.html#cfn-quicksight-dashboard-parameters-stringparameters
         * @external
         */
        readonly stringParameters?: Array<CfnDashboard.StringParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html
     * @external
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnDashboard.ResourcePermissionProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html#cfn-quicksight-dashboard-resourcepermission-actions
         * @external
         */
        readonly actions: string[];
        /**
         * `CfnDashboard.ResourcePermissionProperty.Principal`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-resourcepermission.html#cfn-quicksight-dashboard-resourcepermission-principal
         * @external
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheet.html
     * @external
     */
    interface SheetProperty {
        /**
         * `CfnDashboard.SheetProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheet.html#cfn-quicksight-dashboard-sheet-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnDashboard.SheetProperty.SheetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheet.html#cfn-quicksight-dashboard-sheet-sheetid
         * @external
         */
        readonly sheetId?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html
     * @external
     */
    interface SheetControlsOptionProperty {
        /**
         * `CfnDashboard.SheetControlsOptionProperty.VisibilityState`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-sheetcontrolsoption.html#cfn-quicksight-dashboard-sheetcontrolsoption-visibilitystate
         * @external
         */
        readonly visibilityState?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Dashboard`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-dashboard.html
 * @external
 * @cloudformationResource AWS::QuickSight::Dashboard
 */
export declare namespace CfnDashboard {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html
     * @external
     */
    interface StringParameterProperty {
        /**
         * `CfnDashboard.StringParameterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html#cfn-quicksight-dashboard-stringparameter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnDashboard.StringParameterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-dashboard-stringparameter.html#cfn-quicksight-dashboard-stringparameter-values
         * @external
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 */
export interface CfnTemplateProps {
    /**
     * `AWS::QuickSight::Template.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-awsaccountid
     * @external
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Template.TemplateId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-templateid
     * @external
     */
    readonly templateId: string;
    /**
     * `AWS::QuickSight::Template.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Template.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-permissions
     * @external
     */
    readonly permissions?: Array<CfnTemplate.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Template.SourceEntity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-sourceentity
     * @external
     */
    readonly sourceEntity?: CfnTemplate.TemplateSourceEntityProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Template.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Template.VersionDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-versiondescription
     * @external
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare class CfnTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Template";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTemplate;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * `AWS::QuickSight::Template.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-awsaccountid
     * @external
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Template.TemplateId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-templateid
     * @external
     */
    templateId: string;
    /**
     * `AWS::QuickSight::Template.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Template.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-permissions
     * @external
     */
    permissions: Array<CfnTemplate.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Template.SourceEntity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-sourceentity
     * @external
     */
    sourceEntity: CfnTemplate.TemplateSourceEntityProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Template.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Template.VersionDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html#cfn-quicksight-template-versiondescription
     * @external
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Template`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTemplateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columngroupcolumnschema.html
     * @external
     */
    interface ColumnGroupColumnSchemaProperty {
        /**
         * `CfnTemplate.ColumnGroupColumnSchemaProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columngroupcolumnschema.html#cfn-quicksight-template-columngroupcolumnschema-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columngroupschema.html
     * @external
     */
    interface ColumnGroupSchemaProperty {
        /**
         * `CfnTemplate.ColumnGroupSchemaProperty.ColumnGroupColumnSchemaList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columngroupschema.html#cfn-quicksight-template-columngroupschema-columngroupcolumnschemalist
         * @external
         */
        readonly columnGroupColumnSchemaList?: Array<CfnTemplate.ColumnGroupColumnSchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTemplate.ColumnGroupSchemaProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columngroupschema.html#cfn-quicksight-template-columngroupschema-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columnschema.html
     * @external
     */
    interface ColumnSchemaProperty {
        /**
         * `CfnTemplate.ColumnSchemaProperty.DataType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columnschema.html#cfn-quicksight-template-columnschema-datatype
         * @external
         */
        readonly dataType?: string;
        /**
         * `CfnTemplate.ColumnSchemaProperty.GeographicRole`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columnschema.html#cfn-quicksight-template-columnschema-geographicrole
         * @external
         */
        readonly geographicRole?: string;
        /**
         * `CfnTemplate.ColumnSchemaProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-columnschema.html#cfn-quicksight-template-columnschema-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetconfiguration.html
     * @external
     */
    interface DataSetConfigurationProperty {
        /**
         * `CfnTemplate.DataSetConfigurationProperty.ColumnGroupSchemaList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetconfiguration.html#cfn-quicksight-template-datasetconfiguration-columngroupschemalist
         * @external
         */
        readonly columnGroupSchemaList?: Array<CfnTemplate.ColumnGroupSchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTemplate.DataSetConfigurationProperty.DataSetSchema`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetconfiguration.html#cfn-quicksight-template-datasetconfiguration-datasetschema
         * @external
         */
        readonly dataSetSchema?: CfnTemplate.DataSetSchemaProperty | cdk.IResolvable;
        /**
         * `CfnTemplate.DataSetConfigurationProperty.Placeholder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetconfiguration.html#cfn-quicksight-template-datasetconfiguration-placeholder
         * @external
         */
        readonly placeholder?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html
     * @external
     */
    interface DataSetReferenceProperty {
        /**
         * `CfnTemplate.DataSetReferenceProperty.DataSetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html#cfn-quicksight-template-datasetreference-datasetarn
         * @external
         */
        readonly dataSetArn: string;
        /**
         * `CfnTemplate.DataSetReferenceProperty.DataSetPlaceholder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetreference.html#cfn-quicksight-template-datasetreference-datasetplaceholder
         * @external
         */
        readonly dataSetPlaceholder: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetschema.html
     * @external
     */
    interface DataSetSchemaProperty {
        /**
         * `CfnTemplate.DataSetSchemaProperty.ColumnSchemaList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-datasetschema.html#cfn-quicksight-template-datasetschema-columnschemalist
         * @external
         */
        readonly columnSchemaList?: Array<CfnTemplate.ColumnSchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html
     * @external
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnTemplate.ResourcePermissionProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html#cfn-quicksight-template-resourcepermission-actions
         * @external
         */
        readonly actions: string[];
        /**
         * `CfnTemplate.ResourcePermissionProperty.Principal`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-resourcepermission.html#cfn-quicksight-template-resourcepermission-principal
         * @external
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-sheet.html
     * @external
     */
    interface SheetProperty {
        /**
         * `CfnTemplate.SheetProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-sheet.html#cfn-quicksight-template-sheet-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnTemplate.SheetProperty.SheetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-sheet.html#cfn-quicksight-template-sheet-sheetid
         * @external
         */
        readonly sheetId?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateerror.html
     * @external
     */
    interface TemplateErrorProperty {
        /**
         * `CfnTemplate.TemplateErrorProperty.Message`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateerror.html#cfn-quicksight-template-templateerror-message
         * @external
         */
        readonly message?: string;
        /**
         * `CfnTemplate.TemplateErrorProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateerror.html#cfn-quicksight-template-templateerror-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html
     * @external
     */
    interface TemplateSourceAnalysisProperty {
        /**
         * `CfnTemplate.TemplateSourceAnalysisProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html#cfn-quicksight-template-templatesourceanalysis-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnTemplate.TemplateSourceAnalysisProperty.DataSetReferences`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceanalysis.html#cfn-quicksight-template-templatesourceanalysis-datasetreferences
         * @external
         */
        readonly dataSetReferences: Array<CfnTemplate.DataSetReferenceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html
     * @external
     */
    interface TemplateSourceEntityProperty {
        /**
         * `CfnTemplate.TemplateSourceEntityProperty.SourceAnalysis`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html#cfn-quicksight-template-templatesourceentity-sourceanalysis
         * @external
         */
        readonly sourceAnalysis?: CfnTemplate.TemplateSourceAnalysisProperty | cdk.IResolvable;
        /**
         * `CfnTemplate.TemplateSourceEntityProperty.SourceTemplate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourceentity.html#cfn-quicksight-template-templatesourceentity-sourcetemplate
         * @external
         */
        readonly sourceTemplate?: CfnTemplate.TemplateSourceTemplateProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourcetemplate.html
     * @external
     */
    interface TemplateSourceTemplateProperty {
        /**
         * `CfnTemplate.TemplateSourceTemplateProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templatesourcetemplate.html#cfn-quicksight-template-templatesourcetemplate-arn
         * @external
         */
        readonly arn: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Template`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-template.html
 * @external
 * @cloudformationResource AWS::QuickSight::Template
 */
export declare namespace CfnTemplate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html
     * @external
     */
    interface TemplateVersionProperty {
        /**
         * `CfnTemplate.TemplateVersionProperty.CreatedTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-createdtime
         * @external
         */
        readonly createdTime?: string;
        /**
         * `CfnTemplate.TemplateVersionProperty.DataSetConfigurations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-datasetconfigurations
         * @external
         */
        readonly dataSetConfigurations?: Array<CfnTemplate.DataSetConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTemplate.TemplateVersionProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnTemplate.TemplateVersionProperty.Errors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-errors
         * @external
         */
        readonly errors?: Array<CfnTemplate.TemplateErrorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTemplate.TemplateVersionProperty.Sheets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-sheets
         * @external
         */
        readonly sheets?: Array<CfnTemplate.SheetProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTemplate.TemplateVersionProperty.SourceEntityArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-sourceentityarn
         * @external
         */
        readonly sourceEntityArn?: string;
        /**
         * `CfnTemplate.TemplateVersionProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-status
         * @external
         */
        readonly status?: string;
        /**
         * `CfnTemplate.TemplateVersionProperty.ThemeArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-themearn
         * @external
         */
        readonly themeArn?: string;
        /**
         * `CfnTemplate.TemplateVersionProperty.VersionNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-template-templateversion.html#cfn-quicksight-template-templateversion-versionnumber
         * @external
         */
        readonly versionNumber?: number;
    }
}
/**
 * Properties for defining a `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 */
export interface CfnThemeProps {
    /**
     * `AWS::QuickSight::Theme.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-awsaccountid
     * @external
     */
    readonly awsAccountId: string;
    /**
     * `AWS::QuickSight::Theme.ThemeId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-themeid
     * @external
     */
    readonly themeId: string;
    /**
     * `AWS::QuickSight::Theme.BaseThemeId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-basethemeid
     * @external
     */
    readonly baseThemeId?: string;
    /**
     * `AWS::QuickSight::Theme.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-configuration
     * @external
     */
    readonly configuration?: CfnTheme.ThemeConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Theme.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::QuickSight::Theme.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-permissions
     * @external
     */
    readonly permissions?: Array<CfnTheme.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::QuickSight::Theme.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::QuickSight::Theme.VersionDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-versiondescription
     * @external
     */
    readonly versionDescription?: string;
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare class CfnTheme extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::QuickSight::Theme";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTheme;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CreatedTime
     */
    readonly attrCreatedTime: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedTime
     */
    readonly attrLastUpdatedTime: string;
    /**
     * @external
     * @cloudformationAttribute Type
     */
    readonly attrType: string;
    /**
     * `AWS::QuickSight::Theme.AwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-awsaccountid
     * @external
     */
    awsAccountId: string;
    /**
     * `AWS::QuickSight::Theme.ThemeId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-themeid
     * @external
     */
    themeId: string;
    /**
     * `AWS::QuickSight::Theme.BaseThemeId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-basethemeid
     * @external
     */
    baseThemeId: string | undefined;
    /**
     * `AWS::QuickSight::Theme.Configuration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-configuration
     * @external
     */
    configuration: CfnTheme.ThemeConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Theme.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::QuickSight::Theme.Permissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-permissions
     * @external
     */
    permissions: Array<CfnTheme.ResourcePermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::QuickSight::Theme.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::QuickSight::Theme.VersionDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-versiondescription
     * @external
     */
    versionDescription: string | undefined;
    /**
     * Create a new `AWS::QuickSight::Theme`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnThemeProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-borderstyle.html
     * @external
     */
    interface BorderStyleProperty {
        /**
         * `CfnTheme.BorderStyleProperty.Show`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-borderstyle.html#cfn-quicksight-theme-borderstyle-show
         * @external
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html
     * @external
     */
    interface DataColorPaletteProperty {
        /**
         * `CfnTheme.DataColorPaletteProperty.Colors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-colors
         * @external
         */
        readonly colors?: string[];
        /**
         * `CfnTheme.DataColorPaletteProperty.EmptyFillColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-emptyfillcolor
         * @external
         */
        readonly emptyFillColor?: string;
        /**
         * `CfnTheme.DataColorPaletteProperty.MinMaxGradient`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-datacolorpalette.html#cfn-quicksight-theme-datacolorpalette-minmaxgradient
         * @external
         */
        readonly minMaxGradient?: string[];
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-font.html
     * @external
     */
    interface FontProperty {
        /**
         * `CfnTheme.FontProperty.FontFamily`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-font.html#cfn-quicksight-theme-font-fontfamily
         * @external
         */
        readonly fontFamily?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-gutterstyle.html
     * @external
     */
    interface GutterStyleProperty {
        /**
         * `CfnTheme.GutterStyleProperty.Show`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-gutterstyle.html#cfn-quicksight-theme-gutterstyle-show
         * @external
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-marginstyle.html
     * @external
     */
    interface MarginStyleProperty {
        /**
         * `CfnTheme.MarginStyleProperty.Show`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-marginstyle.html#cfn-quicksight-theme-marginstyle-show
         * @external
         */
        readonly show?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html
     * @external
     */
    interface ResourcePermissionProperty {
        /**
         * `CfnTheme.ResourcePermissionProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html#cfn-quicksight-theme-resourcepermission-actions
         * @external
         */
        readonly actions: string[];
        /**
         * `CfnTheme.ResourcePermissionProperty.Principal`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-resourcepermission.html#cfn-quicksight-theme-resourcepermission-principal
         * @external
         */
        readonly principal: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html
     * @external
     */
    interface SheetStyleProperty {
        /**
         * `CfnTheme.SheetStyleProperty.Tile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html#cfn-quicksight-theme-sheetstyle-tile
         * @external
         */
        readonly tile?: CfnTheme.TileStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.SheetStyleProperty.TileLayout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-sheetstyle.html#cfn-quicksight-theme-sheetstyle-tilelayout
         * @external
         */
        readonly tileLayout?: CfnTheme.TileLayoutStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html
     * @external
     */
    interface ThemeConfigurationProperty {
        /**
         * `CfnTheme.ThemeConfigurationProperty.DataColorPalette`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-datacolorpalette
         * @external
         */
        readonly dataColorPalette?: CfnTheme.DataColorPaletteProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.Sheet`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-sheet
         * @external
         */
        readonly sheet?: CfnTheme.SheetStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.Typography`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-typography
         * @external
         */
        readonly typography?: CfnTheme.TypographyProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeConfigurationProperty.UIColorPalette`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeconfiguration.html#cfn-quicksight-theme-themeconfiguration-uicolorpalette
         * @external
         */
        readonly uiColorPalette?: CfnTheme.UIColorPaletteProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeerror.html
     * @external
     */
    interface ThemeErrorProperty {
        /**
         * `CfnTheme.ThemeErrorProperty.Message`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeerror.html#cfn-quicksight-theme-themeerror-message
         * @external
         */
        readonly message?: string;
        /**
         * `CfnTheme.ThemeErrorProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeerror.html#cfn-quicksight-theme-themeerror-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html
     * @external
     */
    interface ThemeVersionProperty {
        /**
         * `CfnTheme.ThemeVersionProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html#cfn-quicksight-theme-themeversion-arn
         * @external
         */
        readonly arn?: string;
        /**
         * `CfnTheme.ThemeVersionProperty.BaseThemeId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html#cfn-quicksight-theme-themeversion-basethemeid
         * @external
         */
        readonly baseThemeId?: string;
        /**
         * `CfnTheme.ThemeVersionProperty.Configuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html#cfn-quicksight-theme-themeversion-configuration
         * @external
         */
        readonly configuration?: CfnTheme.ThemeConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeVersionProperty.CreatedTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html#cfn-quicksight-theme-themeversion-createdtime
         * @external
         */
        readonly createdTime?: string;
        /**
         * `CfnTheme.ThemeVersionProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html#cfn-quicksight-theme-themeversion-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnTheme.ThemeVersionProperty.Errors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html#cfn-quicksight-theme-themeversion-errors
         * @external
         */
        readonly errors?: Array<CfnTheme.ThemeErrorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTheme.ThemeVersionProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html#cfn-quicksight-theme-themeversion-status
         * @external
         */
        readonly status?: string;
        /**
         * `CfnTheme.ThemeVersionProperty.VersionNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-themeversion.html#cfn-quicksight-theme-themeversion-versionnumber
         * @external
         */
        readonly versionNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html
     * @external
     */
    interface TileLayoutStyleProperty {
        /**
         * `CfnTheme.TileLayoutStyleProperty.Gutter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html#cfn-quicksight-theme-tilelayoutstyle-gutter
         * @external
         */
        readonly gutter?: CfnTheme.GutterStyleProperty | cdk.IResolvable;
        /**
         * `CfnTheme.TileLayoutStyleProperty.Margin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilelayoutstyle.html#cfn-quicksight-theme-tilelayoutstyle-margin
         * @external
         */
        readonly margin?: CfnTheme.MarginStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilestyle.html
     * @external
     */
    interface TileStyleProperty {
        /**
         * `CfnTheme.TileStyleProperty.Border`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-tilestyle.html#cfn-quicksight-theme-tilestyle-border
         * @external
         */
        readonly border?: CfnTheme.BorderStyleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-typography.html
     * @external
     */
    interface TypographyProperty {
        /**
         * `CfnTheme.TypographyProperty.FontFamilies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-typography.html#cfn-quicksight-theme-typography-fontfamilies
         * @external
         */
        readonly fontFamilies?: Array<CfnTheme.FontProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::QuickSight::Theme`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html
 * @external
 * @cloudformationResource AWS::QuickSight::Theme
 */
export declare namespace CfnTheme {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html
     * @external
     */
    interface UIColorPaletteProperty {
        /**
         * `CfnTheme.UIColorPaletteProperty.Accent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-accent
         * @external
         */
        readonly accent?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.AccentForeground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-accentforeground
         * @external
         */
        readonly accentForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Danger`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-danger
         * @external
         */
        readonly danger?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.DangerForeground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dangerforeground
         * @external
         */
        readonly dangerForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Dimension`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dimension
         * @external
         */
        readonly dimension?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.DimensionForeground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-dimensionforeground
         * @external
         */
        readonly dimensionForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Measure`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-measure
         * @external
         */
        readonly measure?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.MeasureForeground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-measureforeground
         * @external
         */
        readonly measureForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.PrimaryBackground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-primarybackground
         * @external
         */
        readonly primaryBackground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.PrimaryForeground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-primaryforeground
         * @external
         */
        readonly primaryForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SecondaryBackground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-secondarybackground
         * @external
         */
        readonly secondaryBackground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SecondaryForeground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-secondaryforeground
         * @external
         */
        readonly secondaryForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Success`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-success
         * @external
         */
        readonly success?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.SuccessForeground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-successforeground
         * @external
         */
        readonly successForeground?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.Warning`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-warning
         * @external
         */
        readonly warning?: string;
        /**
         * `CfnTheme.UIColorPaletteProperty.WarningForeground`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-theme-uicolorpalette.html#cfn-quicksight-theme-uicolorpalette-warningforeground
         * @external
         */
        readonly warningForeground?: string;
    }
}
