# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['ServiceUser']


class ServiceUser(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Service User Resource

        The Service User resource allows the creation and management of an Aiven Service Users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        myserviceuser = aiven.ServiceUser("myserviceuser",
            project=aiven_project["myproject"]["project"],
            service_name=aiven_service["myservice"]["service_name"],
            username="<USERNAME>")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] project: and `service_name` - (Required) define the project and service the user belongs to.
               They should be defined using reference as shown above to set up dependencies correctly.
        :param pulumi.Input[str] service_name: Service to link the user to
        :param pulumi.Input[str] username: is the actual name of the user account.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            if username is None:
                raise TypeError("Missing required property 'username'")
            __props__['username'] = username
            __props__['access_cert'] = None
            __props__['access_key'] = None
            __props__['password'] = None
            __props__['type'] = None
        super(ServiceUser, __self__).__init__(
            'aiven:index/serviceUser:ServiceUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_cert: Optional[pulumi.Input[str]] = None,
            access_key: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'ServiceUser':
        """
        Get an existing ServiceUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_cert: is the access certificate of the user (not applicable for all services).
        :param pulumi.Input[str] access_key: is the access key of the user (not applicable for all services).
        :param pulumi.Input[str] password: is the password of the user (not applicable for all services).
        :param pulumi.Input[str] project: and `service_name` - (Required) define the project and service the user belongs to.
               They should be defined using reference as shown above to set up dependencies correctly.
        :param pulumi.Input[str] service_name: Service to link the user to
        :param pulumi.Input[str] type: tells whether the user is primary account or regular account.
        :param pulumi.Input[str] username: is the actual name of the user account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_cert"] = access_cert
        __props__["access_key"] = access_key
        __props__["password"] = password
        __props__["project"] = project
        __props__["service_name"] = service_name
        __props__["type"] = type
        __props__["username"] = username
        return ServiceUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessCert")
    def access_cert(self) -> pulumi.Output[str]:
        """
        is the access certificate of the user (not applicable for all services).
        """
        return pulumi.get(self, "access_cert")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[str]:
        """
        is the access key of the user (not applicable for all services).
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        is the password of the user (not applicable for all services).
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        and `service_name` - (Required) define the project and service the user belongs to.
        They should be defined using reference as shown above to set up dependencies correctly.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service to link the user to
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        tells whether the user is primary account or regular account.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        is the actual name of the user account.
        """
        return pulumi.get(self, "username")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

