/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import org.coode.owlapi.obo12.parser.OBO12DocumentFormat;
import org.coode.owlapi.obo12.parser.OBO12DocumentFormatFactory;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOFrame;
import org.coode.owlapi.obo12.parser.OBOParser;
import org.coode.owlapi.obo12.parser.OBOTagValuePair;
import org.coode.owlapi.obo12.parser.ParseException;
import org.coode.owlapi.obo12.parser.RawFrameHandler;
import org.coode.owlapi.obo12.parser.Token;
import org.coode.owlapi.obo12.parser.TokenMgrError;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

class OWLOBO12Parser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    OWLOBO12Parser() {
    }

    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        OBOParser parser;
        Reader reader = null;
        InputStream is = null;
        if (documentSource.isReaderAvailable()) {
            reader = documentSource.getReader();
            parser = new OBOParser(reader);
        } else if (documentSource.isInputStreamAvailable()) {
            is = documentSource.getInputStream();
            parser = new OBOParser(is);
        } else {
            Optional headers = documentSource.getAcceptHeaders();
            is = headers.isPresent() ? this.getInputStream(documentSource.getDocumentIRI(), configuration, (String)headers.get()) : this.getInputStream(documentSource.getDocumentIRI(), configuration, "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09");
            parser = new OBOParser(is);
        }
        RawFrameHandler rawFrameHandler = new RawFrameHandler();
        OBOConsumer oboConsumer = new OBOConsumer(ontology, configuration, documentSource.getDocumentIRI());
        parser.setHandler(rawFrameHandler);
        try {
            parser.parse();
            OWLOBO12Parser.parseFrames(rawFrameHandler, oboConsumer);
        }
        catch (ParseException e) {
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyChangeException) {
                throw (OWLOntologyChangeException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyAlreadyExistsException) {
                OWLOntologyAlreadyExistsException ex = (OWLOntologyAlreadyExistsException)e.getCause();
                IRI importedOntologyIRI = (IRI)ex.getOntologyID().getOntologyIRI().get();
                assert (importedOntologyIRI != null);
                throw new UnloadableImportException((OWLOntologyCreationException)ex, ontology.getOWLOntologyManager().getOWLDataFactory().getOWLImportsDeclaration(importedOntologyIRI));
            }
            Token currentToken = e.currentToken;
            if (currentToken != null) {
                int beginLine = currentToken.beginLine;
                int beginColumn = currentToken.beginColumn;
                throw new OWLParserException((Throwable)((Object)e), beginLine, beginColumn);
            }
            throw new OWLParserException((Throwable)((Object)e));
        }
        catch (TokenMgrError e) {
            throw new OWLParserException((Throwable)((Object)e));
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        OBO12DocumentFormat format = new OBO12DocumentFormat();
        format.setIDSpaceManager(oboConsumer.getIdSpaceManager());
        return format;
    }

    private static void parseFrames(RawFrameHandler rawFrameHandler, OBOConsumer oboConsumer) {
        OWLOBO12Parser.parseHeaderFrame(rawFrameHandler, oboConsumer);
        OWLOBO12Parser.parseFrames(oboConsumer, rawFrameHandler.getTypeDefFrames());
        OWLOBO12Parser.parseFrames(oboConsumer, rawFrameHandler.getNonTypeDefFrames());
    }

    private static void parseHeaderFrame(RawFrameHandler rawFrameHandler, OBOConsumer consumer) {
        consumer.startHeader();
        OWLOBO12Parser.parseFrameTagValuePairs(consumer, rawFrameHandler.getHeaderFrame());
        consumer.endHeader();
    }

    private static void parseFrames(OBOConsumer oboConsumer, List<OBOFrame> frames) {
        for (OBOFrame frame : frames) {
            OWLOBO12Parser.parseFrame(oboConsumer, frame);
        }
    }

    private static void parseFrame(OBOConsumer oboConsumer, OBOFrame frame) {
        oboConsumer.startFrame(frame.getFrameType());
        OWLOBO12Parser.parseFrameTagValuePairs(oboConsumer, frame);
        oboConsumer.endFrame();
    }

    private static void parseFrameTagValuePairs(OBOConsumer oboConsumer, OBOFrame frame) {
        for (OBOTagValuePair tagValuePair : frame.getTagValuePairs()) {
            oboConsumer.handleTagValue(tagValuePair.getTagName(), tagValuePair.getValue(), tagValuePair.getQualifier(), tagValuePair.getComment());
        }
    }

    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OBO12DocumentFormatFactory();
    }
}

