/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;

public class StrMaxLengthConstraint
extends ConstraintTerm {
    private final int maxLength;

    public StrMaxLengthConstraint(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        if (n.isBlank()) {
            String msg = this.toString() + ": Blank node: " + ShLib.displayStr(n);
            return new ReportItem(msg, n);
        }
        String str = NodeFunctions.str((Node)n);
        if (str.length() <= this.maxLength) {
            return null;
        }
        String msg = this.toString() + ": String too long: " + str;
        return new ReportItem(msg, n);
    }

    @Override
    public Node getComponent() {
        return SHACL.MaxLengthConstraintComponent;
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compact(out, "maxLength", this.maxLength);
    }

    public String toString() {
        return "MaxLengthConstraint[" + this.maxLength + "]";
    }

    public int hashCode() {
        return Objects.hash(this.maxLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrMaxLengthConstraint)) {
            return false;
        }
        StrMaxLengthConstraint other = (StrMaxLengthConstraint)obj;
        return this.maxLength == other.maxLength;
    }
}

