/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphCollection;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TxnDataset2Graph;
import org.apache.jena.sparql.graph.GraphUnionRead;
import org.apache.jena.sparql.graph.GraphZero;

public class DatasetGraphMapLink
extends DatasetGraphCollection {
    private final DatasetGraphFactory.GraphMaker graphMaker;
    private final Map<Node, Graph> graphs = new HashMap<Node, Graph>();
    private Graph defaultGraph;
    private final Transactional txn;
    private final TxnDataset2Graph txnDsg2Graph;
    private static DatasetGraphFactory.GraphMaker dftGraphMaker = DatasetGraphFactory.graphMakerMem;

    public static DatasetGraph cloneStructure(DatasetGraph dsg) {
        return DatasetGraphMapLink.cloneStructure(dsg, dftGraphMaker);
    }

    public static DatasetGraph cloneStructure(DatasetGraph dsg, DatasetGraphFactory.GraphMaker graphMaker) {
        DatasetGraphMapLink dsg2 = new DatasetGraphMapLink(null, graphMaker);
        DatasetGraphMapLink.linkGraphs(dsg, dsg2);
        return dsg2;
    }

    private static void linkGraphs(DatasetGraph srcDsg, DatasetGraphMapLink dstDsg) {
        dstDsg.defaultGraph = srcDsg.getDefaultGraph();
        Iterator<Node> names = srcDsg.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            dstDsg.addGraph(gn, srcDsg.getGraph(gn));
        }
    }

    public DatasetGraphMapLink(Graph dftGraph) {
        this(dftGraph, dftGraphMaker);
    }

    DatasetGraphMapLink(Graph dftGraph, DatasetGraphFactory.GraphMaker graphMaker) {
        this.graphMaker = graphMaker;
        this.defaultGraph = dftGraph;
        this.txnDsg2Graph = new TxnDataset2Graph(dftGraph, new Graph[0]);
        this.txn = this.txnDsg2Graph;
    }

    @Override
    public void commit() {
        if (this.txnDsg2Graph == null) {
            SystemARQ.sync(this);
        }
        this.txn.commit();
    }

    @Override
    public void begin() {
        this.txn.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.txn.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        return this.txn.promote(txnType);
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txn.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.txn.transactionType();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        if (Quad.isDefaultGraph(graphNode) || Quad.isUnionGraph(graphNode)) {
            return true;
        }
        return this.graphs.containsKey(graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public Graph getGraph(Node graphNode) {
        if (Quad.isUnionGraph(graphNode)) {
            return new GraphUnionRead(this);
        }
        if (Quad.isDefaultGraph(graphNode)) {
            return this.getDefaultGraph();
        }
        Graph g = this.graphs.get(graphNode);
        if (g == null && (g = this.getGraphCreate(graphNode)) != null) {
            this.addGraph(graphNode, g);
        }
        return g;
    }

    protected Graph getGraphCreate(Node graphNode) {
        return this.graphMaker.create(graphNode);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        if (this.txnDsg2Graph != null) {
            this.txnDsg2Graph.addGraph(graph);
        }
        this.graphs.put(graphName, graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        Graph g = this.graphs.remove(graphName);
        if (g != null && this.txnDsg2Graph != null) {
            this.txnDsg2Graph.removeGraph(g);
        }
    }

    @Override
    public void setDefaultGraph(Graph g) {
        if (g == null) {
            g = GraphZero.instance();
        }
        if (this.txnDsg2Graph != null) {
            this.txnDsg2Graph.addGraph(g);
        }
        this.defaultGraph = g;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.graphs.keySet().iterator();
    }

    @Override
    public long size() {
        return this.graphs.size();
    }

    @Override
    public void close() {
        this.defaultGraph.close();
        for (Graph graph : this.graphs.values()) {
            graph.close();
        }
        super.close();
    }
}

