/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang.arq;

import java.util.Map;
import org.apache.jena.atlas.json.io.JSONHandler;
import org.apache.jena.atlas.json.io.JSONHandlerBase;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.lang.SPARQLParserBase;
import org.apache.jena.sparql.lang.arq.ARQParserConstants;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.Template;

class ARQParserBase
extends SPARQLParserBase
implements ARQParserConstants {
    JSONHandler handler = new JSONHandlerBase();

    ARQParserBase() {
    }

    public void setHandler(JSONHandler handler) {
        this.handler = handler == null ? new JSONHandlerBase() : handler;
    }

    protected void jsonStartParse(long currLine, long currCol) {
        this.handler.startParse(currLine, currCol);
    }

    protected void jsonFinishParse(long currLine, long currCol) {
        this.handler.finishParse(currLine, currCol);
    }

    protected void jsonStartObject(long currLine, long currCol) {
        this.handler.startObject(currLine, currCol);
    }

    protected void jsonFinishObject(long currLine, long currCol) {
        this.handler.finishObject(currLine, currCol);
    }

    protected void jsonStartPair(long currLine, long currCol) {
        this.handler.startPair(currLine, currCol);
    }

    protected void jsonKeyPair(long currLine, long currCol) {
        this.handler.keyPair(currLine, currCol);
    }

    protected void jsonFinishPair(long currLine, long currCol) {
        this.handler.finishPair(currLine, currCol);
    }

    protected void jsonStartArray(long currLine, long currCol) {
        this.handler.startArray(currLine, currCol);
    }

    protected void jsonElement(long currLine, long currCol) {
        this.handler.element(currLine, currCol);
    }

    protected void jsonFinishArray(long currLine, long currCol) {
        this.handler.finishArray(currLine, currCol);
    }

    protected void jsonValueString(String image, long currLine, long currCol) {
        image = image.substring(1, image.length() - 1);
        this.handler.valueString(image, currLine, currCol);
    }

    protected void jsonValueKeyString(String image, long currLine, long currCol) {
        this.handler.valueString(image, currLine, currCol);
    }

    protected void jsonValueInteger(String image, long currLine, long currCol) {
        this.handler.valueInteger(image, currLine, currCol);
    }

    protected void jsonValueDecimal(String image, long currLine, long currCol) {
        this.handler.valueDecimal(image, currLine, currCol);
    }

    protected void jsonValueDouble(String image, long currLine, long currCol) {
        this.handler.valueDouble(image, currLine, currCol);
    }

    protected void jsonValueBoolean(boolean b, long currLine, long currCol) {
        this.handler.valueBoolean(b, currLine, currCol);
    }

    protected void jsonValueNull(long currLine, long currCol) {
        this.handler.valueNull(currLine, currCol);
    }

    protected void jsonValueVar(String image, long currLine, long currCol) {
        throw new NotImplemented("yet");
    }

    protected ElementGroup createQueryPattern(Template t) {
        ElementGroup elg = new ElementGroup();
        Map<Node, BasicPattern> graphs = t.getGraphPattern();
        for (Node n : graphs.keySet()) {
            Element el = new ElementPathBlock(graphs.get(n));
            if (!Quad.defaultGraphNodeGenerated.equals((Object)n)) {
                ElementGroup e2 = new ElementGroup();
                e2.addElement(el);
                el = new ElementNamedGraph(n, e2);
            }
            elg.addElement(el);
        }
        return elg;
    }
}

