/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.serializer;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.query.QueryVisitor;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.modify.request.UpdateSerializer;
import org.apache.jena.sparql.modify.request.UpdateWriter;
import org.apache.jena.sparql.serializer.FmtExprSPARQL;
import org.apache.jena.sparql.serializer.FmtTemplate;
import org.apache.jena.sparql.serializer.FormatterElement;
import org.apache.jena.sparql.serializer.FormatterTemplate;
import org.apache.jena.sparql.serializer.QuerySerializer;
import org.apache.jena.sparql.serializer.QuerySerializerFactory;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.serializer.UpdateSerializerFactory;
import org.apache.jena.sparql.util.NodeToLabelMap;
import org.apache.jena.sparql.util.NodeToLabelMapBNode;

public class SerializerRegistry {
    private Map<Syntax, QuerySerializerFactory> querySerializers = new HashMap<Syntax, QuerySerializerFactory>();
    private Map<Syntax, UpdateSerializerFactory> updateSerializers = new HashMap<Syntax, UpdateSerializerFactory>();
    private static SerializerRegistry registry;

    private SerializerRegistry() {
    }

    private static synchronized void init() {
        SerializerRegistry reg = new SerializerRegistry();
        QuerySerializerFactory arqQuerySerializerFactory = new QuerySerializerFactory(){

            @Override
            public QueryVisitor create(Syntax syntax, Prologue prologue, IndentedWriter writer) {
                SerializationContext cxt1 = new SerializationContext(prologue, (NodeToLabelMap)new NodeToLabelMapBNode("b", false));
                SerializationContext cxt2 = new SerializationContext(prologue, (NodeToLabelMap)new NodeToLabelMapBNode("c", false));
                return new QuerySerializer(writer, new FormatterElement(writer, cxt1), new FmtExprSPARQL(writer, cxt1), (FormatterTemplate)new FmtTemplate(writer, cxt2));
            }

            @Override
            public QueryVisitor create(Syntax syntax, SerializationContext context2, IndentedWriter writer) {
                return new QuerySerializer(writer, new FormatterElement(writer, context2), new FmtExprSPARQL(writer, context2), (FormatterTemplate)new FmtTemplate(writer, context2));
            }

            @Override
            public boolean accept(Syntax syntax) {
                return Syntax.syntaxARQ.equals(syntax) || Syntax.syntaxSPARQL_10.equals(syntax) || Syntax.syntaxSPARQL_11.equals(syntax);
            }
        };
        reg.addQuerySerializer(Syntax.syntaxARQ, arqQuerySerializerFactory);
        reg.addQuerySerializer(Syntax.syntaxSPARQL_10, arqQuerySerializerFactory);
        reg.addQuerySerializer(Syntax.syntaxSPARQL_11, arqQuerySerializerFactory);
        UpdateSerializerFactory arqUpdateSerializerFactory = new UpdateSerializerFactory(){

            @Override
            public UpdateSerializer create(Syntax syntax, Prologue prologue, IndentedWriter writer) {
                if (!prologue.explicitlySetBaseURI()) {
                    prologue = new Prologue(prologue.getPrefixMapping(), (IRIResolver)null);
                }
                SerializationContext context2 = new SerializationContext(prologue);
                return new UpdateWriter(writer, context2);
            }

            @Override
            public boolean accept(Syntax syntax) {
                return Syntax.syntaxARQ.equals(syntax) || Syntax.syntaxSPARQL_10.equals(syntax) || Syntax.syntaxSPARQL_11.equals(syntax);
            }
        };
        reg.addUpdateSerializer(Syntax.syntaxARQ, arqUpdateSerializerFactory);
        reg.addUpdateSerializer(Syntax.syntaxSPARQL_10, arqUpdateSerializerFactory);
        reg.addUpdateSerializer(Syntax.syntaxSPARQL_11, arqUpdateSerializerFactory);
        registry = reg;
    }

    public static SerializerRegistry get() {
        if (registry == null) {
            SerializerRegistry.init();
        }
        return registry;
    }

    public void addQuerySerializer(Syntax syntax, QuerySerializerFactory factory) {
        if (!factory.accept(syntax)) {
            throw new IllegalArgumentException("Factory does not accept the specified syntax");
        }
        this.querySerializers.put(syntax, factory);
    }

    public void addUpdateSerializer(Syntax syntax, UpdateSerializerFactory factory) {
        if (!factory.accept(syntax)) {
            throw new IllegalArgumentException("Factory does not accept the specified syntax");
        }
        this.updateSerializers.put(syntax, factory);
    }

    public boolean containsQuerySerializer(Syntax syntax) {
        return this.querySerializers.containsKey(syntax) && this.querySerializers.get(syntax) != null;
    }

    public boolean containsUpdateSerializer(Syntax syntax) {
        return this.updateSerializers.containsKey(syntax) && this.updateSerializers.get(syntax) != null;
    }

    public QuerySerializerFactory getQuerySerializerFactory(Syntax syntax) {
        return this.querySerializers.get(syntax);
    }

    public UpdateSerializerFactory getUpdateSerializerFactory(Syntax syntax) {
        return this.updateSerializers.get(syntax);
    }

    public void removeQuerySerializer(Syntax syntax) {
        this.querySerializers.remove(syntax);
    }

    public void removeUpdateSerializer(Syntax syntax) {
        this.updateSerializers.remove(syntax);
    }
}

