/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementDataset;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementFind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.ElementVisitor;

public class ElementWalker {
    public static void walk(Element el, ElementVisitor visitor) {
        ElementWalker.walk(el, visitor, null, null);
    }

    public static void walk(Element el, ElementVisitor visitor, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
        EltWalker w = new EltWalker(visitor, beforeVisitor, afterVisitor);
        el.visit(w);
    }

    protected static void walk$(Element el, EltWalker walker) {
        el.visit(walker);
    }

    static class EltWalker
    implements ElementVisitor {
        protected final ElementVisitor proc;
        protected final ElementVisitor beforeVisitor;
        protected final ElementVisitor afterVisitor;

        protected EltWalker(ElementVisitor visitor, ElementVisitor beforeVisitor, ElementVisitor afterVisitor) {
            this.proc = visitor;
            this.beforeVisitor = beforeVisitor;
            this.afterVisitor = afterVisitor;
        }

        private void before(Element elt) {
            if (this.beforeVisitor != null) {
                elt.visit(this.beforeVisitor);
            }
        }

        private void after(Element elt) {
            if (this.afterVisitor != null) {
                elt.visit(this.afterVisitor);
            }
        }

        @Override
        public void visit(ElementTriplesBlock el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementFilter el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementAssign el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementBind el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementFind el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementData el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementUnion el) {
            this.before(el);
            for (Element e2 : el.getElements()) {
                e2.visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementGroup el) {
            this.before(el);
            for (Element e2 : el.getElements()) {
                e2.visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementOptional el) {
            this.before(el);
            if (el.getOptionalElement() != null) {
                el.getOptionalElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementDataset el) {
            this.before(el);
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementNamedGraph el) {
            this.before(el);
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementService el) {
            this.before(el);
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementExists el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementNotExists el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementMinus el) {
            this.before(el);
            if (el.getMinusElement() != null) {
                el.getMinusElement().visit(this);
            }
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementSubQuery el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }

        @Override
        public void visit(ElementPathBlock el) {
            this.before(el);
            this.proc.visit(el);
            this.after(el);
        }
    }
}

