/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.console;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class OutputStreamHandler
extends Handler {
    private final BufferedWriter output;
    private final Date start;

    public OutputStreamHandler(OutputStream output) throws IOException {
        Objects.requireNonNull(output);
        this.output = new BufferedWriter(new OutputStreamWriter(output));
        this.start = new Date();
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.output.close();
        }
        catch (IOException e) {
            throw new SecurityException(e);
        }
    }

    private String createMessage(String originalMessage) {
        long difference = new Date().getTime() - this.start.getTime();
        long totalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("(");
        sbuf.append("" + difference);
        sbuf.append(" ms) ([X]:");
        sbuf.append("" + (totalMemory - freeMemory));
        sbuf.append(" MB, [ ]:");
        sbuf.append("" + freeMemory);
        sbuf.append(" MB) ");
        sbuf.append(originalMessage);
        return sbuf.toString();
    }

    @Override
    public void flush() {
        try {
            this.output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void publish(LogRecord record) {
        Objects.requireNonNull(record);
        try {
            this.output.write(this.createMessage(record.getMessage()));
            this.output.newLine();
            this.output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

