/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.translator;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotationImpl;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerClassAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerClassDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDataPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDataPropertyDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDifferentIndividualsAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDisjointClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerFunctionalObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseFunctionalObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerNamedIndividualDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerNegativeObjectPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerObjectPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerObjectPropertyDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerPropertyRangeAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerReflexiveObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSameIndividualAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubObjectPropertyOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubPropertyChainOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerTransitiveObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataTypeFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectProperty;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectSomeValuesFrom;
import de.tudresden.inf.lat.jcel.owlapi.translator.ClassExpressionTranslator;
import de.tudresden.inf.lat.jcel.owlapi.translator.TranslationException;
import de.tudresden.inf.lat.jcel.owlapi.translator.TranslationRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class AxiomTranslator
implements OWLAxiomVisitorEx<Set<ComplexIntegerAxiom>> {
    private final ClassExpressionTranslator classExpressionTranslator;
    private final IntegerOntologyObjectFactory factory;

    public AxiomTranslator(ClassExpressionTranslator translator, IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(translator);
        Objects.requireNonNull(factory);
        this.factory = factory;
        this.classExpressionTranslator = translator;
    }

    private ComplexIntegerAxiomFactory getAxiomFactory() {
        return this.factory.getComplexAxiomFactory();
    }

    public ClassExpressionTranslator getClassExpressionTranslator() {
        return this.classExpressionTranslator;
    }

    public IntegerDataTypeFactory getDataTypeFactory() {
        return this.factory.getDataTypeFactory();
    }

    public TranslationRepository getTranslationRepository() {
        return this.classExpressionTranslator.getTranslationRepository();
    }

    private OWLDataProperty asOWLDataProperty(OWLDataPropertyExpression expression) {
        if (!(expression instanceof OWLDataProperty)) {
            throw new TranslationException("Data property expression cannot be translated: '" + expression + "'.");
        }
        return expression.asOWLDataProperty();
    }

    private OWLObjectProperty asOWLObjectProperty(OWLObjectPropertyExpression expression) {
        if (!(expression instanceof OWLObjectProperty)) {
            throw new TranslationException("Object property expression cannot be translated: '" + expression + "'.");
        }
        return expression.asOWLObjectProperty();
    }

    private OWLNamedIndividual asOWLNamedIndividual(OWLIndividual individual) {
        if (!(individual instanceof OWLNamedIndividual)) {
            throw new TranslationException("Individual cannot be translated: '" + individual + "'.");
        }
        return individual.asOWLNamedIndividual();
    }

    public IntegerClassExpression translateClassExpression(OWLClassExpression owlClassExpression) throws TranslationException {
        return (IntegerClassExpression)owlClassExpression.accept((OWLClassExpressionVisitorEx)this.getClassExpressionTranslator());
    }

    public Integer translateObjectProperty(OWLObjectProperty objectProperty) throws TranslationException {
        this.getClassExpressionTranslator().getTranslationRepository().addObjectProperty(objectProperty);
        return this.getClassExpressionTranslator().getTranslationRepository().getId(objectProperty);
    }

    public IntegerObjectPropertyExpression translateObjectPropertyExpression(OWLObjectPropertyExpression objectPropertyExpr) throws TranslationException {
        return (IntegerObjectPropertyExpression)objectPropertyExpr.accept((OWLPropertyExpressionVisitorEx)this.getClassExpressionTranslator().getObjectPropertyExpressionTranslator());
    }

    public Integer translateDataProperty(OWLDataProperty dataPropertyExpr) throws TranslationException {
        OWLDataProperty dataProperty = this.asOWLDataProperty((OWLDataPropertyExpression)dataPropertyExpr);
        this.getClassExpressionTranslator().getTranslationRepository().addDataProperty(dataProperty);
        return this.getClassExpressionTranslator().getTranslationRepository().getId(dataProperty);
    }

    public Integer translateIndividual(OWLIndividual individual) throws TranslationException {
        OWLNamedIndividual namedIndividual = this.asOWLNamedIndividual(individual);
        this.getClassExpressionTranslator().getTranslationRepository().addNamedIndividual(namedIndividual);
        return this.getClassExpressionTranslator().getTranslationRepository().getId(individual);
    }

    public Integer translateLiteral(OWLLiteral literal) throws TranslationException {
        this.getClassExpressionTranslator().getTranslationRepository().addLiteral(literal);
        return this.getClassExpressionTranslator().getTranslationRepository().getId(literal);
    }

    public IntegerAnnotation translateAnnotation(OWLAnnotation owlAnnotation) {
        this.getClassExpressionTranslator().getTranslationRepository().addAnnotationProperty(owlAnnotation.getProperty());
        int property = this.getClassExpressionTranslator().getTranslationRepository().getId(owlAnnotation.getProperty());
        this.getClassExpressionTranslator().getTranslationRepository().addAnnotationValue(owlAnnotation.getValue());
        int value = this.getClassExpressionTranslator().getTranslationRepository().getId(owlAnnotation.getValue());
        IntegerAnnotationImpl ret = new IntegerAnnotationImpl(property, value);
        return ret;
    }

    public Set<IntegerAnnotation> translateAnnotations(Set<OWLAnnotation> owlAnnotations) {
        TreeSet<IntegerAnnotation> ret = new TreeSet<IntegerAnnotation>();
        owlAnnotations.forEach(owlAnnotation -> ret.add(this.translateAnnotation((OWLAnnotation)owlAnnotation)));
        return ret;
    }

    public Set<ComplexIntegerAxiom> visit(OWLAnnotationAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    public Set<ComplexIntegerAxiom> visit(OWLAnnotationPropertyDomainAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    public Set<ComplexIntegerAxiom> visit(OWLAnnotationPropertyRangeAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    public Set<ComplexIntegerAxiom> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLClassAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        Integer individualId = this.translateIndividual(axiom.getIndividual());
        IntegerClassAssertionAxiom ret = this.getAxiomFactory().createClassAssertionAxiom(this.translateClassExpression(axiom.getClassExpression()), individualId.intValue(), this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDataPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        Integer propertyId = this.translateDataProperty(this.asOWLDataProperty((OWLDataPropertyExpression)axiom.getProperty()));
        Integer subjectId = this.translateIndividual(axiom.getSubject());
        Integer objectId = this.translateLiteral((OWLLiteral)axiom.getObject());
        IntegerDataPropertyAssertionAxiom ret = this.getAxiomFactory().createDataPropertyAssertionAxiom(propertyId.intValue(), subjectId.intValue(), objectId.intValue(), this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDataPropertyDomainAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDataPropertyRangeAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDatatypeDefinitionAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    private Set<ComplexIntegerAxiom> declare(OWLClass owlClass, Set<OWLAnnotation> annotations) {
        this.getTranslationRepository().addClass(owlClass);
        IntegerClassDeclarationAxiom elem = this.getAxiomFactory().createClassDeclarationAxiom(this.getTranslationRepository().getId(owlClass).intValue(), this.translateAnnotations(annotations));
        return Collections.singleton(elem);
    }

    private Set<ComplexIntegerAxiom> declare(OWLObjectProperty owlObjectProperty, Set<OWLAnnotation> annotations) {
        this.getTranslationRepository().addObjectProperty(owlObjectProperty);
        IntegerObjectPropertyDeclarationAxiom elem = this.getAxiomFactory().createObjectPropertyDeclarationAxiom(this.getTranslationRepository().getId(owlObjectProperty).intValue(), this.translateAnnotations(annotations));
        return Collections.singleton(elem);
    }

    private Set<ComplexIntegerAxiom> declare(OWLNamedIndividual owlNamedIndividual, Set<OWLAnnotation> annotations) {
        this.getTranslationRepository().addNamedIndividual(owlNamedIndividual);
        IntegerNamedIndividualDeclarationAxiom elem = this.getAxiomFactory().createNamedIndividualDeclarationAxiom(this.getTranslationRepository().getId((OWLIndividual)owlNamedIndividual).intValue(), this.translateAnnotations(annotations));
        return Collections.singleton(elem);
    }

    private Set<ComplexIntegerAxiom> declare(OWLDataProperty owlDataProperty, Set<OWLAnnotation> annotations) {
        this.getTranslationRepository().addDataProperty(owlDataProperty);
        IntegerDataPropertyDeclarationAxiom elem = this.getAxiomFactory().createDataPropertyDeclarationAxiom(this.getTranslationRepository().getId(owlDataProperty).intValue(), this.translateAnnotations(annotations));
        return Collections.singleton(elem);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        OWLEntity entity = axiom.getEntity();
        if (entity.isOWLClass()) {
            return this.declare(entity.asOWLClass(), (Set<OWLAnnotation>)axiom.getAnnotations());
        }
        if (entity.isOWLObjectProperty()) {
            return this.declare(entity.asOWLObjectProperty(), (Set<OWLAnnotation>)axiom.getAnnotations());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.declare(entity.asOWLNamedIndividual(), (Set<OWLAnnotation>)axiom.getAnnotations());
        }
        if (entity.isOWLDataProperty()) {
            return this.declare(entity.asOWLDataProperty(), (Set<OWLAnnotation>)axiom.getAnnotations());
        }
        if (entity.isOWLAnnotationProperty()) {
            return Collections.emptySet();
        }
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDifferentIndividualsAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set individualSet = axiom.getIndividuals();
        HashSet individualIdSet = new HashSet();
        individualSet.forEach(individual -> {
            this.getTranslationRepository().addNamedIndividual(individual.asOWLNamedIndividual());
            individualIdSet.add(this.translateIndividual((OWLIndividual)individual));
        });
        IntegerDifferentIndividualsAxiom ret = this.getAxiomFactory().createDifferentIndividualsAxiom(individualIdSet, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDisjointClassesAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        Set classExpressionSet = axiom.getClassExpressions();
        HashSet classIdSet = new HashSet();
        classExpressionSet.forEach(classExpression -> classIdSet.add(this.translateClassExpression((OWLClassExpression)classExpression)));
        IntegerDisjointClassesAxiom ret = this.getAxiomFactory().createDisjointClassesAxiom(classIdSet, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDisjointDataPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDisjointObjectPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLDisjointUnionAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLEquivalentClassesAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        Set classExpressionSet = axiom.getClassExpressions();
        HashSet classIdSet = new HashSet();
        classExpressionSet.forEach(classExpression -> classIdSet.add(this.translateClassExpression((OWLClassExpression)classExpression)));
        IntegerEquivalentClassesAxiom ret = this.getAxiomFactory().createEquivalentClassesAxiom(classIdSet, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLEquivalentDataPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLEquivalentObjectPropertiesAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        Set propertySet = axiom.getProperties();
        HashSet propertyExprSet = new HashSet();
        propertySet.forEach(propertyExpr -> {
            if (!(propertyExpr instanceof OWLObjectProperty)) {
                throw new IllegalStateException();
            }
            OWLObjectProperty property = this.asOWLObjectProperty((OWLObjectPropertyExpression)propertyExpr);
            propertyExprSet.add(this.getDataTypeFactory().createObjectProperty(this.translateObjectProperty(property).intValue()));
        });
        IntegerEquivalentObjectPropertiesAxiom ret = this.getAxiomFactory().createEquivalentObjectPropertiesAxiom(propertyExprSet, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLFunctionalDataPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLFunctionalObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty property = this.asOWLObjectProperty((OWLObjectPropertyExpression)axiom.getProperty());
        IntegerObjectProperty propExpr = this.getDataTypeFactory().createObjectProperty(this.translateObjectProperty(property).intValue());
        IntegerFunctionalObjectPropertyAxiom ret = this.getAxiomFactory().createFunctionalObjectPropertyAxiom((IntegerObjectPropertyExpression)propExpr, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLHasKeyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty property = this.asOWLObjectProperty((OWLObjectPropertyExpression)axiom.getProperty());
        IntegerObjectProperty propExpr = this.getDataTypeFactory().createObjectProperty(this.translateObjectProperty(property).intValue());
        IntegerInverseFunctionalObjectPropertyAxiom ret = this.getAxiomFactory().createInverseFunctionalObjectPropertyAxiom((IntegerObjectPropertyExpression)propExpr, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLInverseObjectPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty firstProperty = this.asOWLObjectProperty(axiom.getFirstProperty());
        OWLObjectProperty secondProperty = this.asOWLObjectProperty(axiom.getSecondProperty());
        IntegerObjectProperty firstPropertyExpr = this.getDataTypeFactory().createObjectProperty(this.translateObjectProperty(firstProperty).intValue());
        IntegerObjectProperty secondPropertyExpr = this.getDataTypeFactory().createObjectProperty(this.translateObjectProperty(secondProperty).intValue());
        IntegerInverseObjectPropertiesAxiom ret = this.getAxiomFactory().createInverseObjectPropertiesAxiom((IntegerObjectPropertyExpression)firstPropertyExpr, (IntegerObjectPropertyExpression)secondPropertyExpr, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        IntegerObjectPropertyExpression propertyExpr = this.translateObjectPropertyExpression((OWLObjectPropertyExpression)axiom.getProperty());
        Integer subjectId = this.translateIndividual(axiom.getSubject());
        Integer objectId = this.translateIndividual((OWLIndividual)axiom.getObject());
        IntegerNegativeObjectPropertyAssertionAxiom ret = this.getAxiomFactory().createNegativeObjectPropertyAssertionAxiom(propertyExpr, subjectId.intValue(), objectId.intValue(), this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLObjectPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        IntegerObjectPropertyExpression propertyExpr = this.translateObjectPropertyExpression((OWLObjectPropertyExpression)axiom.getProperty());
        Integer subjectId = this.translateIndividual(axiom.getSubject());
        Integer objectId = this.translateIndividual((OWLIndividual)axiom.getObject());
        IntegerObjectPropertyAssertionAxiom ret = this.getAxiomFactory().createObjectPropertyAssertionAxiom(propertyExpr, subjectId.intValue(), objectId.intValue(), this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLObjectPropertyDomainAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        IntegerObjectPropertyExpression propertyExpr = this.translateObjectPropertyExpression((OWLObjectPropertyExpression)axiom.getProperty());
        OWLClassExpression classExpression = axiom.getDomain();
        IntegerClassExpression superClassExpression = this.translateClassExpression(classExpression);
        IntegerObjectSomeValuesFrom subClassExpression = this.getDataTypeFactory().createObjectSomeValuesFrom(propertyExpr, (IntegerClassExpression)this.getDataTypeFactory().createClass(IntegerEntityManager.topClassId.intValue()));
        IntegerSubClassOfAxiom ret = this.getAxiomFactory().createSubClassOfAxiom((IntegerClassExpression)subClassExpression, superClassExpression, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLObjectPropertyRangeAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        OWLObjectProperty property = this.asOWLObjectProperty((OWLObjectPropertyExpression)axiom.getProperty());
        OWLClassExpression classExpression = (OWLClassExpression)axiom.getRange();
        IntegerObjectProperty propExpr = this.getDataTypeFactory().createObjectProperty(this.translateObjectProperty(property).intValue());
        IntegerPropertyRangeAxiom ret = this.getAxiomFactory().createPropertyRangeAxiom((IntegerObjectPropertyExpression)propExpr, this.translateClassExpression(classExpression), this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLReflexiveObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        OWLObjectProperty property = this.asOWLObjectProperty((OWLObjectPropertyExpression)axiom.getProperty());
        IntegerObjectProperty propertyExpr = this.getDataTypeFactory().createObjectProperty(this.translateObjectProperty(property).intValue());
        IntegerReflexiveObjectPropertyAxiom ret = this.getAxiomFactory().createReflexiveObjectPropertyAxiom((IntegerObjectPropertyExpression)propertyExpr, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLSameIndividualAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set individualSet = axiom.getIndividuals();
        HashSet individualIdSet = new HashSet();
        individualSet.forEach(individual -> individualIdSet.add(this.translateIndividual((OWLIndividual)individual)));
        IntegerSameIndividualAxiom ret = this.getAxiomFactory().createSameIndividualAxiom(individualIdSet, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        return Collections.emptySet();
    }

    public Set<ComplexIntegerAxiom> visit(OWLSubClassOfAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        OWLClassExpression owlSubClass = axiom.getSubClass();
        OWLClassExpression owlSuperClass = axiom.getSuperClass();
        IntegerClassExpression leftDescription = this.translateClassExpression(owlSubClass);
        IntegerClassExpression rightDescription = this.translateClassExpression(owlSuperClass);
        IntegerSubClassOfAxiom ret = this.getAxiomFactory().createSubClassOfAxiom(leftDescription, rightDescription, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLSubDataPropertyOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLSubObjectPropertyOfAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        OWLObjectPropertyExpression leftPropExpr = (OWLObjectPropertyExpression)axiom.getSubProperty();
        OWLObjectPropertyExpression rightPropExpr = (OWLObjectPropertyExpression)axiom.getSuperProperty();
        IntegerSubObjectPropertyOfAxiom ret = this.getAxiomFactory().createSubObjectPropertyOfAxiom(this.translateObjectPropertyExpression(leftPropExpr), this.translateObjectPropertyExpression(rightPropExpr), this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLSubPropertyChainOfAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        List propChain = axiom.getPropertyChain();
        OWLObjectPropertyExpression superProperty = axiom.getSuperProperty();
        ArrayList chain = new ArrayList();
        propChain.forEach(property -> chain.add(this.translateObjectPropertyExpression((OWLObjectPropertyExpression)property)));
        IntegerSubPropertyChainOfAxiom ret = this.getAxiomFactory().createSubPropertyChainOfAxiom(chain, this.translateObjectPropertyExpression(superProperty), this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(OWLSymmetricObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }

    public Set<ComplexIntegerAxiom> visit(OWLTransitiveObjectPropertyAxiom axiom) throws TranslationException {
        Objects.requireNonNull(axiom);
        OWLObjectProperty property = ((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty();
        IntegerObjectProperty propExpr = this.getDataTypeFactory().createObjectProperty(this.translateObjectProperty(property).intValue());
        IntegerTransitiveObjectPropertyAxiom ret = this.getAxiomFactory().createTransitiveObjectPropertyAxiom((IntegerObjectPropertyExpression)propExpr, this.translateAnnotations(axiom.getAnnotations()));
        return Collections.singleton(ret);
    }

    public Set<ComplexIntegerAxiom> visit(SWRLRule axiom) {
        Objects.requireNonNull(axiom);
        throw TranslationException.newUnsupportedAxiomException((OWLAxiom)axiom);
    }
}

