/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.reasoner.main;

import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerClassAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerClassDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDataPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDataPropertyDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDifferentIndividualsAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDisjointClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerFunctionalObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseFunctionalObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerNamedIndividualDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerNegativeObjectPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerObjectPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerObjectPropertyDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerPropertyRangeAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerReflexiveObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSameIndividualAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubObjectPropertyOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubPropertyChainOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerTransitiveObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.reasoner.main.RuleBasedReasoner;
import de.tudresden.inf.lat.jcel.reasoner.main.UnsupportedQueryException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class OntologyEntailmentChecker
implements ComplexIntegerAxiomVisitor<Boolean> {
    private static final String errorMsg = "Unsupported entailment with axiom:";
    private final RuleBasedReasoner reasoner;

    public OntologyEntailmentChecker(RuleBasedReasoner reasoner) {
        Objects.requireNonNull(reasoner);
        this.reasoner = reasoner;
    }

    public RuleBasedReasoner getReasoner() {
        return this.reasoner;
    }

    public Boolean visit(IntegerClassAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerClassDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        boolean ret = this.getReasoner().getProcessor().getClassHierarchy().getElements().contains(axiom.getEntity());
        return ret;
    }

    public Boolean visit(IntegerDataPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerDataPropertyDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerDifferentIndividualsAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerDisjointClassesAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerEquivalentClassesAxiom axiom) {
        Objects.requireNonNull(axiom);
        boolean ret = true;
        Set set = axiom.getClassExpressions();
        if (!set.isEmpty()) {
            IntegerClass representative = this.getReasoner().flattenClassExpression((IntegerClassExpression)set.iterator().next());
            HashSet classSet = new HashSet();
            set.forEach(classExpr -> classSet.add(this.getReasoner().flattenClassExpression((IntegerClassExpression)classExpr)));
            this.getReasoner().classify();
            ret = ret && classSet.stream().allMatch(currentClass -> this.getReasoner().getProcessor().getClassHierarchy().getEquivalents(currentClass.getId()).contains(representative.getId()));
        }
        return ret;
    }

    public Boolean visit(IntegerEquivalentObjectPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerFunctionalObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerInverseFunctionalObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerInverseObjectPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerNamedIndividualDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerNegativeObjectPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerObjectPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerObjectPropertyDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        return this.getReasoner().getProcessor().getObjectPropertyHierarchy().getElements().contains(axiom.getEntity());
    }

    public Boolean visit(IntegerPropertyRangeAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerReflexiveObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerSameIndividualAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerSubClassOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        IntegerClassExpression subClassExpr = axiom.getSubClass();
        IntegerClassExpression superClassExpr = axiom.getSuperClass();
        IntegerClass subClass = this.getReasoner().flattenClassExpression(subClassExpr);
        IntegerClass superClass = this.getReasoner().flattenClassExpression(superClassExpr);
        this.getReasoner().classify();
        boolean isEquivalent = this.getReasoner().getEquivalentClasses((IntegerClassExpression)subClass).contains(superClass);
        boolean isAncestor = false;
        if (!isEquivalent) {
            Set<Set<IntegerClass>> setsOfAncestors = this.getReasoner().getSuperClasses(subClassExpr, false);
            isAncestor = isAncestor || setsOfAncestors.stream().anyMatch(ancestor -> ancestor.contains(superClass));
        }
        return isAncestor || isEquivalent;
    }

    public Boolean visit(IntegerSubObjectPropertyOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        IntegerObjectPropertyExpression subObjectPropExpr = axiom.getSubProperty();
        IntegerObjectPropertyExpression superObjectPropExpr = axiom.getSuperProperty();
        this.getReasoner().classify();
        boolean isEquivalent = this.getReasoner().getEquivalentObjectProperties(subObjectPropExpr).contains(superObjectPropExpr);
        boolean isAncestor = false;
        if (!isEquivalent) {
            Set<Set<IntegerObjectPropertyExpression>> setsOfAncestors = this.getReasoner().getSuperObjectProperties(subObjectPropExpr, false);
            isAncestor = isAncestor || setsOfAncestors.stream().anyMatch(ancestor -> ancestor.contains(superObjectPropExpr));
        }
        return isAncestor || isEquivalent;
    }

    public Boolean visit(IntegerSubPropertyChainOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(IntegerTransitiveObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        throw new UnsupportedQueryException(errorMsg + axiom);
    }
}

