/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.reasoner.module;

import de.tudresden.inf.lat.jcel.core.algorithm.common.Processor;
import de.tudresden.inf.lat.jcel.core.algorithm.common.UnclassifiedOntologyException;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraph;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraphImpl;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraphImpl;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.reasoner.module.ModuleProcessorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.IntStream;

public class ModuleProcessor
implements Processor {
    private static final Logger logger = Logger.getLogger(ModuleProcessor.class.getName());
    private IntegerHierarchicalGraphImpl classHierarchy = null;
    private IntegerHierarchicalGraphImpl dataPropertyHierarchy = null;
    private Map<Integer, Set<Integer>> directTypes = null;
    private boolean isReady = false;
    private Integer moduleIndex = 0;
    private List<Set<ComplexIntegerAxiom>> moduleList = null;
    private IntegerHierarchicalGraphImpl objectPropertyHierarchy = null;
    private Processor processor = null;
    private final ModuleProcessorFactory processorFactory;
    private Map<Integer, Set<Integer>> sameIndividualMap = null;

    public ModuleProcessor(Set<ComplexIntegerAxiom> axiomSet, ModuleProcessorFactory factory) {
        Objects.requireNonNull(axiomSet);
        Objects.requireNonNull(factory);
        this.processorFactory = factory;
        this.preProcess(axiomSet);
    }

    private boolean containsAnyClass(Set<Integer> a, Set<Integer> b) {
        return b.stream().filter(elem -> !elem.equals(IntegerEntityManager.bottomClassId) && !elem.equals(IntegerEntityManager.topClassId)).anyMatch(elem -> a.contains(elem));
    }

    private boolean containsAnyProperty(Set<Integer> a, Set<Integer> b) {
        return b.stream().filter(elem -> !elem.equals(IntegerEntityManager.bottomObjectPropertyId) && !elem.equals(IntegerEntityManager.topObjectPropertyId)).anyMatch(elem -> a.contains(elem));
    }

    private List<Set<ComplexIntegerAxiom>> findModules(Set<ComplexIntegerAxiom> axiomSet) {
        ArrayList<Set<ComplexIntegerAxiom>> ret = new ArrayList<Set<ComplexIntegerAxiom>>();
        HashSet<ComplexIntegerAxiom> toBeGrouped = new HashSet<ComplexIntegerAxiom>();
        toBeGrouped.addAll(axiomSet);
        while (!toBeGrouped.isEmpty()) {
            ComplexIntegerAxiom firstAxiom = (ComplexIntegerAxiom)toBeGrouped.iterator().next();
            toBeGrouped.remove(firstAxiom);
            HashSet<ComplexIntegerAxiom> group = new HashSet<ComplexIntegerAxiom>();
            group.add(firstAxiom);
            HashSet<Integer> classSet = new HashSet<Integer>();
            classSet.addAll(firstAxiom.getClassesInSignature());
            HashSet<Integer> propertySet = new HashSet<Integer>();
            propertySet.addAll(firstAxiom.getObjectPropertiesInSignature());
            boolean found = true;
            while (found) {
                found = false;
                HashSet<ComplexIntegerAxiom> toVisit = new HashSet<ComplexIntegerAxiom>();
                toVisit.addAll(toBeGrouped);
                for (ComplexIntegerAxiom currentAxiom : toVisit) {
                    Set classesInSignature = currentAxiom.getClassesInSignature();
                    Set propertiesInSignature = currentAxiom.getObjectPropertiesInSignature();
                    if (!this.containsAnyClass(classSet, classesInSignature) && !this.containsAnyProperty(propertySet, propertiesInSignature)) continue;
                    toBeGrouped.remove(currentAxiom);
                    propertySet.addAll(propertiesInSignature);
                    classSet.addAll(classesInSignature);
                    group.add(currentAxiom);
                    found = true;
                }
            }
            ret.add(group);
        }
        return ret;
    }

    @Override
    public IntegerHierarchicalGraph getClassHierarchy() {
        IntegerHierarchicalGraphImpl ret = null;
        if (this.isReady()) {
            ret = this.classHierarchy;
        }
        return ret;
    }

    @Override
    public IntegerHierarchicalGraph getDataPropertyHierarchy() throws UnclassifiedOntologyException {
        IntegerHierarchicalGraphImpl ret = null;
        if (this.isReady()) {
            ret = this.dataPropertyHierarchy;
        }
        return ret;
    }

    @Override
    public Map<Integer, Set<Integer>> getDirectTypes() {
        Map<Integer, Set<Integer>> ret = null;
        if (this.isReady()) {
            ret = this.directTypes;
        }
        return ret;
    }

    @Override
    public IntegerHierarchicalGraph getObjectPropertyHierarchy() {
        IntegerHierarchicalGraphImpl ret = null;
        if (this.isReady()) {
            ret = this.objectPropertyHierarchy;
        }
        return ret;
    }

    @Override
    public Map<Integer, Set<Integer>> getSameIndividualMap() {
        Map<Integer, Set<Integer>> ret = null;
        if (this.isReady()) {
            ret = this.sameIndividualMap;
        }
        return ret;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    private void preProcess(Set<ComplexIntegerAxiom> originalAxiomSet) {
        this.isReady = false;
        logger.fine("using " + this.getClass().getSimpleName() + " ...");
        this.dataPropertyHierarchy = new IntegerHierarchicalGraphImpl(new IntegerSubsumerGraphImpl(IntegerEntityManager.bottomDataPropertyId, IntegerEntityManager.topDataPropertyId));
        this.moduleList = this.findModules(originalAxiomSet);
        logger.fine("modules found : " + this.moduleList.size());
        IntStream.range(0, this.moduleList.size()).forEach(index -> logger.fine("module " + index + " has " + this.moduleList.get(index).size() + " axioms"));
        this.moduleIndex = 0;
        this.classHierarchy = new IntegerHierarchicalGraphImpl(IntegerEntityManager.bottomClassId, IntegerEntityManager.topClassId);
        this.objectPropertyHierarchy = new IntegerHierarchicalGraphImpl(IntegerEntityManager.bottomObjectPropertyId, IntegerEntityManager.topObjectPropertyId);
        this.directTypes = new HashMap<Integer, Set<Integer>>();
        this.sameIndividualMap = new HashMap<Integer, Set<Integer>>();
        logger.fine("");
        logger.fine("");
        logger.fine("classifying module " + this.moduleIndex + " ...");
        this.processor = this.processorFactory.createProcessor(this.moduleList.get(this.moduleIndex));
    }

    @Override
    public boolean process() {
        boolean hasMoreEntries;
        if (!this.isReady && !(hasMoreEntries = this.processor.process())) {
            this.classHierarchy.disjointUnion(this.processor.getClassHierarchy());
            this.objectPropertyHierarchy.disjointUnion(this.processor.getObjectPropertyHierarchy());
            this.directTypes.putAll(this.processor.getDirectTypes());
            this.sameIndividualMap.putAll(this.processor.getSameIndividualMap());
            this.processor = null;
            logger.fine("module " + this.moduleIndex + " has been classified.");
            logger.fine("");
            ModuleProcessor moduleProcessor = this;
            Integer n = moduleProcessor.moduleIndex;
            Integer n2 = moduleProcessor.moduleIndex = Integer.valueOf(moduleProcessor.moduleIndex + 1);
            if (this.moduleIndex < this.moduleList.size()) {
                hasMoreEntries = true;
                logger.fine("classifying module " + this.moduleIndex + " ...");
                this.processor = this.processorFactory.createProcessor(this.moduleList.get(this.moduleIndex));
            }
            if (!hasMoreEntries) {
                this.isReady = true;
            }
        }
        return !this.isReady;
    }
}

