/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class IntegerClassAssertionAxiom
implements ComplexIntegerAxiom {
    private final IntegerClassExpression classExpression;
    private final int individual;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerClassAssertionAxiom(IntegerClassExpression classExpr, int individualId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(classExpr);
        Objects.requireNonNull(annotations);
        this.classExpression = classExpr;
        this.individual = individualId;
        this.annotations = annotations;
        this.hashCode = this.classExpression.hashCode() + 31 * (this.individual + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerClassAssertionAxiom) {
            IntegerClassAssertionAxiom other = (IntegerClassAssertionAxiom)obj;
            ret = this.getClassExpression().equals(other.getClassExpression()) && this.getIndividual().equals(other.getIndividual()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return this.classExpression.getClassesInSignature();
    }

    public IntegerClassExpression getClassExpression() {
        return this.classExpression;
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    public Integer getIndividual() {
        return this.individual;
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.singleton(this.individual);
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("ClassAssertion");
        sbuf.append("(");
        sbuf.append(this.getClassExpression());
        sbuf.append(" ");
        sbuf.append(this.getIndividual());
        sbuf.append(")");
        return sbuf.toString();
    }
}

