/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerEquivalentClassesAxiom
implements ComplexIntegerAxiom {
    private final Set<Integer> classesInSignature;
    private final Set<IntegerClassExpression> classExpressions;
    private final Set<Integer> objectPropertiesInSignature;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerEquivalentClassesAxiom(Set<IntegerClassExpression> descSet, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(descSet);
        Objects.requireNonNull(annotations);
        this.classExpressions = Collections.unmodifiableSet(descSet);
        HashSet classesInSignature = new HashSet();
        this.classExpressions.forEach(expression -> classesInSignature.addAll(expression.getClassesInSignature()));
        this.classesInSignature = Collections.unmodifiableSet(classesInSignature);
        HashSet objectPropertiesInSignature = new HashSet();
        this.classExpressions.forEach(expression -> objectPropertiesInSignature.addAll(expression.getObjectPropertiesInSignature()));
        this.objectPropertiesInSignature = Collections.unmodifiableSet(objectPropertiesInSignature);
        this.annotations = annotations;
        this.hashCode = this.classExpressions.hashCode() + 31 * this.annotations.hashCode();
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerEquivalentClassesAxiom) {
            IntegerEquivalentClassesAxiom other = (IntegerEquivalentClassesAxiom)obj;
            ret = this.getClassExpressions().equals(other.getClassExpressions()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.unmodifiableSet(this.classesInSignature);
    }

    public Set<IntegerClassExpression> getClassExpressions() {
        return Collections.unmodifiableSet(this.classExpressions);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.unmodifiableSet(this.objectPropertiesInSignature);
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("EquivalentClasses");
        sbuf.append("(");
        Set<IntegerClassExpression> classExpressionSet = this.getClassExpressions();
        classExpressionSet.forEach(classExpression -> {
            sbuf.append(classExpression.toString());
            sbuf.append(" ");
        });
        sbuf.append(")");
        return sbuf.toString();
    }
}

