/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerEquivalentObjectPropertiesAxiom
implements ComplexIntegerAxiom {
    private final Set<IntegerObjectPropertyExpression> objectProperties;
    private final Set<Integer> objectPropertiesInSignature;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerEquivalentObjectPropertiesAxiom(Set<IntegerObjectPropertyExpression> propSet, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(propSet);
        Objects.requireNonNull(annotations);
        this.objectProperties = Collections.unmodifiableSet(propSet);
        HashSet objectPropertiesInSignature = new HashSet();
        this.objectProperties.forEach(expression -> objectPropertiesInSignature.addAll(expression.getObjectPropertiesInSignature()));
        this.objectPropertiesInSignature = Collections.unmodifiableSet(objectPropertiesInSignature);
        this.annotations = annotations;
        this.hashCode = this.objectProperties.hashCode() + 31 * this.annotations.hashCode();
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerEquivalentObjectPropertiesAxiom) {
            IntegerEquivalentObjectPropertiesAxiom other = (IntegerEquivalentObjectPropertiesAxiom)obj;
            ret = this.getProperties().equals(other.getProperties()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.unmodifiableSet(this.objectPropertiesInSignature);
    }

    public Set<IntegerObjectPropertyExpression> getProperties() {
        return Collections.unmodifiableSet(this.objectProperties);
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("EquivalentProperties");
        sbuf.append("(");
        Set<IntegerObjectPropertyExpression> propertySet = this.getProperties();
        propertySet.forEach(property -> {
            sbuf.append(property);
            sbuf.append(" ");
        });
        sbuf.append(")");
        return sbuf.toString();
    }
}

