/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerPropertyRangeAxiom
implements ComplexIntegerAxiom {
    private final Set<Integer> classesInSignature;
    private final Set<Integer> objectPropertiesInSignature;
    private final IntegerObjectPropertyExpression property;
    private final IntegerClassExpression range;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerPropertyRangeAxiom(IntegerObjectPropertyExpression prop, IntegerClassExpression clExpr, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(prop);
        Objects.requireNonNull(clExpr);
        Objects.requireNonNull(annotations);
        this.property = prop;
        this.range = clExpr;
        HashSet<Integer> classesInSignature = new HashSet<Integer>();
        classesInSignature.addAll(this.range.getClassesInSignature());
        this.classesInSignature = Collections.unmodifiableSet(classesInSignature);
        HashSet<Integer> objectPropertiesInSignature = new HashSet<Integer>();
        objectPropertiesInSignature.addAll(this.range.getObjectPropertiesInSignature());
        objectPropertiesInSignature.addAll(this.property.getObjectPropertiesInSignature());
        this.objectPropertiesInSignature = Collections.unmodifiableSet(objectPropertiesInSignature);
        this.annotations = annotations;
        this.hashCode = this.property.hashCode() + 31 * (this.range.hashCode() + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerPropertyRangeAxiom) {
            IntegerPropertyRangeAxiom other = (IntegerPropertyRangeAxiom)obj;
            ret = this.getProperty().equals(other.getProperty()) && this.getRange().equals(other.getRange()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.unmodifiableSet(this.classesInSignature);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.unmodifiableSet(this.objectPropertiesInSignature);
    }

    public IntegerObjectPropertyExpression getProperty() {
        return this.property;
    }

    public IntegerClassExpression getRange() {
        return this.range;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("RangeAxiom");
        sbuf.append("(");
        sbuf.append(this.getProperty());
        sbuf.append(" ");
        sbuf.append(this.getRange().toString());
        sbuf.append(")");
        return sbuf.toString();
    }
}

