/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.datatype;

import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpressionVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerObjectSomeValuesFrom
implements IntegerClassExpression {
    private final IntegerClassExpression filler;
    private final int hashCode;
    private final boolean normalized;
    private final IntegerObjectPropertyExpression property;

    protected IntegerObjectSomeValuesFrom(IntegerObjectPropertyExpression propertyExpression, IntegerClassExpression classExpression) {
        Objects.requireNonNull(propertyExpression);
        Objects.requireNonNull(classExpression);
        this.property = propertyExpression;
        this.filler = classExpression;
        this.normalized = classExpression.isLiteral();
        this.hashCode = propertyExpression.hashCode() + 31 * classExpression.hashCode();
    }

    @Override
    public <T> T accept(IntegerClassExpressionVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    @Override
    public boolean containsBottom() {
        return this.filler.containsBottom();
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerObjectSomeValuesFrom) {
            IntegerObjectSomeValuesFrom other = (IntegerObjectSomeValuesFrom)o;
            ret = this.getProperty().equals(other.getProperty()) && this.getFiller().equals(other.getFiller());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.getFiller().getClassesInSignature());
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    public IntegerClassExpression getFiller() {
        return this.filler;
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.getFiller().getObjectPropertiesInSignature());
        ret.addAll(this.getProperty().getObjectPropertiesInSignature());
        return Collections.unmodifiableSet(ret);
    }

    public IntegerObjectPropertyExpression getProperty() {
        return this.property;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean hasOnlyClasses() {
        return this.normalized;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("ObjectSomeValuesFrom");
        sbuf.append("(");
        sbuf.append(this.getProperty().toString());
        sbuf.append(" ");
        sbuf.append(this.getFiller().toString());
        sbuf.append(")");
        return sbuf.toString();
    }
}

