/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import de.tudresden.inf.lat.jcel.ontology.normalization.ObjectPropertyIdFinder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NormalizerEquivProperties
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerEquivProperties(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerEquivalentObjectPropertiesAxiom) {
            ret = this.applyRule((IntegerEquivalentObjectPropertiesAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerEquivalentObjectPropertiesAxiom equivPropAxiom) {
        Set<IntegerObjectPropertyExpression> expressionSet = equivPropAxiom.getProperties();
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        expressionSet.forEach(integerObjectPropertyExpression -> {
            Integer firstExpression = this.getObjectPropertyId((IntegerObjectPropertyExpression)integerObjectPropertyExpression);
            expressionSet.forEach(integerObjectPropertyExpression2 -> {
                Integer secondExpression = this.getObjectPropertyId((IntegerObjectPropertyExpression)integerObjectPropertyExpression2);
                RI2Axiom subPropertyAxiom = this.getOntologyObjectFactory().getNormalizedAxiomFactory().createRI2Axiom(firstExpression, secondExpression, equivPropAxiom.getAnnotations());
                ret.add(subPropertyAxiom);
            });
        });
        return ret;
    }

    private Integer getObjectPropertyId(IntegerObjectPropertyExpression propExpr) {
        return propExpr.accept(new ObjectPropertyIdFinder(this.getOntologyObjectFactory().getEntityManager()));
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

