/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NormalizerNR1_5
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerNR1_5(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerEquivalentClassesAxiom) {
            ret = this.applyRule((IntegerEquivalentClassesAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerEquivalentClassesAxiom equivalentAxiom) {
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        Set<IntegerClassExpression> classExpressionSet = equivalentAxiom.getClassExpressions();
        classExpressionSet.forEach(firstClassExpression -> classExpressionSet.forEach(secondClassExpression -> {
            if (!firstClassExpression.equals(secondClassExpression)) {
                IntegerSubClassOfAxiom subClassAxiom = this.getOntologyObjectFactory().getComplexAxiomFactory().createSubClassOfAxiom((IntegerClassExpression)firstClassExpression, (IntegerClassExpression)secondClassExpression, equivalentAxiom.getAnnotations());
                ret.add(subClassAxiom);
            }
        }));
        return ret;
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

