/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectIntersectionOf;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NormalizerNR2_2
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerNR2_2(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerSubClassOfAxiom) {
            ret = this.applyRule((IntegerSubClassOfAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerSubClassOfAxiom classAxiom) {
        Set<IntegerAxiom> ret = Collections.emptySet();
        IntegerClassExpression subClass = classAxiom.getSubClass();
        if (!subClass.isLiteral()) {
            IntegerObjectIntersectionOf intersection;
            Set<IntegerClassExpression> operands;
            Set<IntegerAxiom> newSet;
            IntegerClassExpression superClass = classAxiom.getSuperClass();
            if (subClass instanceof IntegerObjectIntersectionOf && (newSet = this.applyRule(operands = (intersection = (IntegerObjectIntersectionOf)subClass).getOperands(), superClass, classAxiom.getAnnotations())).size() > 1) {
                ret = newSet;
            }
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(Set<IntegerClassExpression> operands, IntegerClassExpression superClass, Set<IntegerAnnotation> annotations) {
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        HashSet<IntegerClassExpression> newOperands = new HashSet<IntegerClassExpression>();
        boolean[] applied = new boolean[]{false};
        operands.forEach(classExpression -> {
            if (classExpression.isLiteral()) {
                newOperands.add((IntegerClassExpression)classExpression);
            } else {
                applied[0] = true;
                IntegerClass newClass = this.getOntologyObjectFactory().getDataTypeFactory().createClass(this.getOntologyObjectFactory().getEntityManager().createAnonymousEntity(IntegerEntityType.CLASS, true));
                ret.add(this.getOntologyObjectFactory().getComplexAxiomFactory().createSubClassOfAxiom((IntegerClassExpression)classExpression, newClass, annotations));
                newOperands.add(newClass);
            }
        });
        if (applied[0]) {
            IntegerObjectIntersectionOf newIntersection = this.getOntologyObjectFactory().getDataTypeFactory().createObjectIntersectionOf(newOperands);
            ret.add(this.getOntologyObjectFactory().getComplexAxiomFactory().createSubClassOfAxiom(newIntersection, superClass, annotations));
        }
        return ret;
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

