/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectIntersectionOf;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectSomeValuesFrom;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import de.tudresden.inf.lat.jcel.ontology.normalization.ObjectPropertyIdFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class NormalizerSubClassOf
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerSubClassOf(IntegerOntologyObjectFactory factory) {
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        if (axiom instanceof IntegerSubClassOfAxiom) {
            Collection<NormalizedIntegerAxiom> normalizedAxioms = this.simplify((IntegerSubClassOfAxiom)axiom);
            normalizedAxioms.forEach(normalizedAxiom -> ret.add((IntegerAxiom)normalizedAxiom));
        }
        return ret;
    }

    private IntegerEntityManager getIdGenerator() {
        return this.getOntologyObjectFactory().getEntityManager();
    }

    private NormalizedIntegerAxiomFactory getNormalizedAxiomFactory() {
        return this.getOntologyObjectFactory().getNormalizedAxiomFactory();
    }

    private Integer getObjectPropertyId(IntegerObjectPropertyExpression propExpr) {
        return propExpr.accept(new ObjectPropertyIdFinder(this.getIdGenerator()));
    }

    public IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }

    private Collection<NormalizedIntegerAxiom> simplify(IntegerSubClassOfAxiom axiom) {
        ArrayList<NormalizedIntegerAxiom> ret = new ArrayList<NormalizedIntegerAxiom>();
        IntegerClassExpression subClass = axiom.getSubClass();
        IntegerClassExpression superClass = axiom.getSuperClass();
        if (subClass.isLiteral() && superClass.isLiteral()) {
            ret.add(this.getNormalizedAxiomFactory().createGCI0Axiom(((IntegerClass)subClass).getId(), ((IntegerClass)superClass).getId(), axiom.getAnnotations()));
        } else if (!subClass.isLiteral() && superClass.isLiteral() && subClass instanceof IntegerObjectIntersectionOf && subClass.hasOnlyClasses()) {
            IntegerObjectIntersectionOf intersection = (IntegerObjectIntersectionOf)subClass;
            Set<IntegerClassExpression> operands = intersection.getOperands();
            if (operands.size() == 0) {
                ret.add(this.getNormalizedAxiomFactory().createGCI0Axiom(IntegerEntityManager.topClassId, ((IntegerClass)superClass).getId(), axiom.getAnnotations()));
            } else if (operands.size() == 1) {
                ret.add(this.getNormalizedAxiomFactory().createGCI0Axiom(((IntegerClass)operands.iterator().next()).getId(), ((IntegerClass)superClass).getId(), axiom.getAnnotations()));
            } else if (operands.size() == 2) {
                Iterator<IntegerClassExpression> it = operands.iterator();
                int leftSubClassId = ((IntegerClass)it.next()).getId();
                int rightSubClassId = ((IntegerClass)it.next()).getId();
                int superClassId = ((IntegerClass)superClass).getId();
                ret.add(this.getNormalizedAxiomFactory().createGCI1Axiom(leftSubClassId, rightSubClassId, superClassId, axiom.getAnnotations()));
            }
        } else if (subClass.isLiteral() && !superClass.isLiteral() && superClass instanceof IntegerObjectSomeValuesFrom && superClass.hasOnlyClasses()) {
            IntegerObjectSomeValuesFrom restriction = (IntegerObjectSomeValuesFrom)superClass;
            IntegerClass filler = (IntegerClass)restriction.getFiller();
            Integer property = this.getObjectPropertyId(restriction.getProperty());
            ret.add(this.getNormalizedAxiomFactory().createGCI2Axiom(((IntegerClass)subClass).getId(), property, filler.getId(), axiom.getAnnotations()));
        } else if (!subClass.isLiteral() && superClass.isLiteral() && subClass instanceof IntegerObjectSomeValuesFrom && subClass.hasOnlyClasses()) {
            IntegerObjectSomeValuesFrom restriction = (IntegerObjectSomeValuesFrom)subClass;
            IntegerClass filler = (IntegerClass)restriction.getFiller();
            Integer property = this.getObjectPropertyId(restriction.getProperty());
            ret.add(this.getNormalizedAxiomFactory().createGCI3Axiom(property, filler.getId(), ((IntegerClass)superClass).getId(), axiom.getAnnotations()));
        }
        return ret;
    }
}

