/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubPropertyChainOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import de.tudresden.inf.lat.jcel.ontology.normalization.ObjectPropertyIdFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NormalizerSubPropertyChainOf
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerSubPropertyChainOf(IntegerOntologyObjectFactory factory) {
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        if (axiom instanceof IntegerSubPropertyChainOfAxiom) {
            Collection<NormalizedIntegerAxiom> normalizedAxioms = this.simplify((IntegerSubPropertyChainOfAxiom)axiom);
            normalizedAxioms.forEach(normalizedAxiom -> ret.add((IntegerAxiom)normalizedAxiom));
        }
        return ret;
    }

    private IntegerEntityManager getIdGenerator() {
        return this.getOntologyObjectFactory().getEntityManager();
    }

    private NormalizedIntegerAxiomFactory getNormalizedAxiomFactory() {
        return this.getOntologyObjectFactory().getNormalizedAxiomFactory();
    }

    private Integer getObjectPropertyId(IntegerObjectPropertyExpression propExpr) {
        return propExpr.accept(new ObjectPropertyIdFinder(this.getIdGenerator()));
    }

    public IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }

    private Collection<NormalizedIntegerAxiom> simplify(IntegerSubPropertyChainOfAxiom axiom) {
        ArrayList<NormalizedIntegerAxiom> ret = new ArrayList<NormalizedIntegerAxiom>();
        List<IntegerObjectPropertyExpression> propChain = axiom.getPropertyChain();
        IntegerObjectPropertyExpression rightPart = axiom.getSuperProperty();
        if (propChain.size() == 0) {
            ret.add(this.getNormalizedAxiomFactory().createRI1Axiom(this.getObjectPropertyId(rightPart), axiom.getAnnotations()));
        } else if (propChain.size() == 1) {
            Iterator<IntegerObjectPropertyExpression> it = propChain.iterator();
            IntegerObjectPropertyExpression leftPropExpr = it.next();
            ret.add(this.getNormalizedAxiomFactory().createRI2Axiom(this.getObjectPropertyId(leftPropExpr), this.getObjectPropertyId(rightPart), axiom.getAnnotations()));
        } else if (propChain.size() == 2) {
            Iterator<IntegerObjectPropertyExpression> it = propChain.iterator();
            IntegerObjectPropertyExpression leftLeftProp = it.next();
            IntegerObjectPropertyExpression leftRightProp = it.next();
            ret.add(this.getNormalizedAxiomFactory().createRI3Axiom(this.getObjectPropertyId(leftLeftProp), this.getObjectPropertyId(leftRightProp), this.getObjectPropertyId(rightPart), axiom.getAnnotations()));
        }
        return ret;
    }
}

