/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.dlsyntax.parser.DLSyntaxParser;
import org.semanticweb.owlapi.dlsyntax.parser.ParseException;
import org.semanticweb.owlapi.formats.DLSyntaxHTMLDocumentFormat;
import org.semanticweb.owlapi.formats.DLSyntaxHTMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class DLSyntaxOWLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Nonnull
    public String getName() {
        return "DLSyntaxOWLParser";
    }

    public OWLDocumentFormatFactory getSupportedFormat() {
        return new DLSyntaxHTMLDocumentFormatFactory();
    }

    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        Reader reader = null;
        InputStream is = null;
        try {
            DLSyntaxParser parser;
            if (documentSource.isReaderAvailable()) {
                reader = documentSource.getReader();
                parser = new DLSyntaxParser(reader);
            } else if (documentSource.isInputStreamAvailable()) {
                is = documentSource.getInputStream();
                parser = new DLSyntaxParser(is);
            } else {
                if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:")) {
                    if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:!")) {
                        String name = documentSource.getDocumentIRI().toString().substring(5);
                        if (!name.startsWith("/")) {
                            name = "/" + name;
                        }
                        is = ((Object)((Object)this)).getClass().getResourceAsStream(name);
                    } else {
                        try {
                            is = ((JarURLConnection)new URL(documentSource.getDocumentIRI().toString()).openConnection()).getInputStream();
                        }
                        catch (IOException e) {
                            throw new OWLParserException((Throwable)e);
                        }
                    }
                } else {
                    Optional headers = documentSource.getAcceptHeaders();
                    is = headers.isPresent() ? this.getInputStream(documentSource.getDocumentIRI(), configuration, (String)headers.get()) : this.getInputStream(documentSource.getDocumentIRI(), configuration, "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09");
                }
                parser = new DLSyntaxParser(is);
            }
            Set<OWLAxiom> set = parser.parseAxioms();
            ontology.getOWLOntologyManager().addAxioms(ontology, set);
            DLSyntaxHTMLDocumentFormat dLSyntaxHTMLDocumentFormat = new DLSyntaxHTMLDocumentFormat();
            return dLSyntaxHTMLDocumentFormat;
        }
        catch (ParseException e) {
            throw new OWLParserException(e.getMessage(), (Throwable)((Object)e), e.currentToken.beginLine, e.currentToken.beginColumn);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

