/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.owlxml.parser.AbstractClassExpressionElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLAxiomElementHandler;
import org.semanticweb.owlapi.owlxml.parser.AbstractOWLDataRangeHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLAnnotationElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLElementHandler;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserHandler;

class OWLOntologyHandler
extends OWLElementHandler<OWLOntology> {
    OWLOntologyHandler(@Nonnull OWLXMLParserHandler handler) {
        super(handler);
    }

    @Override
    void startElement(String name) {
    }

    @Override
    void attribute(@Nonnull String localName, String value) {
        OWLOntologyID newID;
        if (localName.equals("ontologyIRI")) {
            newID = new OWLOntologyID(IRI.create((String)value), (IRI)this.handler.getOntology().getOntologyID().getVersionIRI().orNull());
            this.handler.getOWLOntologyManager().applyChange((OWLOntologyChange)new SetOntologyID(this.handler.getOntology(), newID));
        }
        if (localName.equals("versionIRI")) {
            newID = new OWLOntologyID((IRI)this.handler.getOntology().getOntologyID().getOntologyIRI().orNull(), IRI.create((String)value));
            this.handler.getOWLOntologyManager().applyChange((OWLOntologyChange)new SetOntologyID(this.handler.getOntology(), newID));
        }
    }

    @Override
    void handleChild(@Nonnull AbstractOWLAxiomElementHandler h) {
        OWLAxiom axiom = h.getOWLObject();
        if (!axiom.isAnnotationAxiom() || this.handler.getConfiguration().isLoadAnnotationAxioms()) {
            this.handler.getOWLOntologyManager().applyChange((OWLOntologyChange)new AddAxiom(this.handler.getOntology(), axiom));
        }
    }

    @Override
    void handleChild(AbstractOWLDataRangeHandler h) {
    }

    @Override
    void handleChild(AbstractClassExpressionElementHandler h) {
    }

    @Override
    void handleChild(@Nonnull OWLAnnotationElementHandler h) {
        this.handler.getOWLOntologyManager().applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.handler.getOntology(), h.getOWLObject()));
    }

    @Override
    void endElement() {
    }

    @Override
    OWLOntology getOWLObject() {
        return this.handler.getOntology();
    }

    @Override
    void setParentHandler(OWLElementHandler<?> handler) {
    }
}

