/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;

public class AlphaExplanationOrderer
implements ExplanationOrderer {
    protected final OWLObjectRenderer renderer;

    public AlphaExplanationOrderer(@Nonnull OWLObjectRenderer renderer) {
        this.renderer = (OWLObjectRenderer)OWLAPIPreconditions.checkNotNull((Object)renderer, (String)"renderer cannot be null");
    }

    @Override
    @Nonnull
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, @Nonnull Set<OWLAxiom> axioms) {
        EntailedAxiomTree root = new EntailedAxiomTree(entailment);
        ArrayList<OWLAxiom> sortedAxioms = new ArrayList<OWLAxiom>(axioms);
        Collections.sort(sortedAxioms, new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                assert (o1 != null);
                assert (o2 != null);
                return AlphaExplanationOrderer.this.renderer.render((OWLObject)o1).compareTo(AlphaExplanationOrderer.this.renderer.render((OWLObject)o2));
            }
        });
        for (OWLAxiom ax : sortedAxioms) {
            assert (ax != null);
            root.addChild(new ExplanationTree(ax));
        }
        return root;
    }
}

