/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.protege;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.semanticweb.elk.config.BaseConfiguration;
import org.semanticweb.elk.config.ConfigurationFactory;
import org.semanticweb.elk.io.IOUtils;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;

public class ElkProtegeConfigurationUtils {
    private static final String CONFIG_PATH = "/.Protege/org.semanticweb.elk/";
    private static final String CONFIG_FILENAME = "elk.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReasonerConfiguration loadConfiguration() {
        ReasonerConfiguration reasonerConfiguration;
        String homeDir = System.getProperty("user.home");
        File configFile = new File(homeDir + CONFIG_PATH + CONFIG_FILENAME);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            reasonerConfiguration = (ReasonerConfiguration)new ConfigurationFactory().getConfiguration((InputStream)stream, "elk.reasoner", ReasonerConfiguration.class);
        }
        catch (IOException e) {
            ReasonerConfiguration reasonerConfiguration2;
            try {
                reasonerConfiguration2 = ReasonerConfiguration.getConfiguration();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
            return reasonerConfiguration2;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return reasonerConfiguration;
    }

    public static void saveConfiguration(ReasonerConfiguration elkConfig) throws Exception {
        if (elkConfig != null) {
            String homeDir = System.getProperty("user.home");
            File saveDir = new File(homeDir + CONFIG_PATH);
            if (!saveDir.exists() && !saveDir.mkdirs()) {
                return;
            }
            File configFile = new File(homeDir + CONFIG_PATH + CONFIG_FILENAME);
            new ConfigurationFactory().saveConfiguration(configFile, (BaseConfiguration)elkConfig);
        }
    }
}

