/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.protege;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.semanticweb.elk.owlapi.ElkReasoner;
import org.semanticweb.elk.protege.ui.MessageDialogAppender;
import org.slf4j.LoggerFactory;

public class ProtegeMessageAppender
extends MessageDialogAppender {
    private static ProtegeMessageAppender INSTANCE_ = new ProtegeMessageAppender();
    private boolean showUnsupportedOwlApiMethodInfo = true;

    public static ProtegeMessageAppender getInstance() {
        return INSTANCE_;
    }

    private ProtegeMessageAppender() {
    }

    @Override
    protected String getCheckboxMessage(ILoggingEvent event) {
        return "<html><div style=\"width:%dpx;\"><p>Do not show further messages of this kind in this session</p><p>(the messages can still be seen in the console if Prot&eacute;g&eacute; was started from the command line)</p></div></html>";
    }

    @Override
    protected boolean showMessage(ILoggingEvent event) {
        if (!super.showMessage(event)) {
            return false;
        }
        if (this.showUnsupportedOwlApiMethodInfo && event.getLevel().isGreaterOrEqual(Level.WARN) && event.getLoggerName().equals(LoggerFactory.getLogger(ElkReasoner.class).getName())) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            String displayLabel = String.format("<html><div style=\"width:%dpx;\"><p>Prot&eacute;g&eacute; has just called an OWL API method that ELK currently does not fully support. In order to minimize the number of error messages, it is recommended to switch off some of the inference types.</p><p>Please go to <b>Reasoner -> Configure -> Displayed Inferences</b> and uncheck:<li><b>Disjoint Classes</b> in <b>Displayed Class Inferences</b><li>All <b>Displayed Object Property Inferences</b><li>All <b>Displayed Data Property Inferences</b><li>Everything except <b>Types</b> in <b>Displayed Individual Inferences</b></ul></p></div></html>", 500);
            panel.add(new JLabel(displayLabel));
            JCheckBox ignoreMessageButton = new JCheckBox("Do not show this message again in this session");
            panel.add(Box.createRigidArea(new Dimension(0, 10)));
            panel.add(ignoreMessageButton);
            JOptionPane.showMessageDialog(null, panel, "Unsupported Inference Types", 1);
            if (ignoreMessageButton.isSelected()) {
                this.showUnsupportedOwlApiMethodInfo = false;
            }
        }
        return true;
    }
}

