/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class OWLReasonerBase
implements OWLReasoner {
    @Nonnull
    private final OWLOntologyManager manager;
    @Nonnull
    private final OWLOntology rootOntology;
    @Nonnull
    private final BufferingMode bufferingMode;
    private final List<OWLOntologyChange> rawChanges = new ArrayList<OWLOntologyChange>();
    @Nonnull
    private final Set<OWLAxiom> reasonerAxioms;
    private final long timeOut;
    @Nonnull
    private final OWLReasonerConfiguration configuration;
    @Nonnull
    private final OWLOntologyChangeListener ontologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            OWLReasonerBase.this.handleRawOntologyChanges(changes);
        }
    };

    protected OWLReasonerBase(@Nonnull OWLOntology rootOntology, @Nonnull OWLReasonerConfiguration configuration, @Nonnull BufferingMode bufferingMode) {
        this.rootOntology = (OWLOntology)OWLAPIPreconditions.checkNotNull((Object)rootOntology, (String)"rootOntology cannot be null");
        this.bufferingMode = (BufferingMode)OWLAPIPreconditions.checkNotNull((Object)bufferingMode, (String)"bufferingMode cannot be null");
        this.configuration = (OWLReasonerConfiguration)OWLAPIPreconditions.checkNotNull((Object)configuration, (String)"configuration cannot be null");
        this.timeOut = configuration.getTimeOut();
        this.manager = rootOntology.getOWLOntologyManager();
        this.manager.addOntologyChangeListener(this.ontologyChangeListener);
        this.reasonerAxioms = new HashSet<OWLAxiom>();
        for (OWLOntology ont : rootOntology.getImportsClosure()) {
            for (OWLAxiom ax : ont.getLogicalAxioms()) {
                this.reasonerAxioms.add(ax.getAxiomWithoutAnnotations());
            }
            for (OWLAxiom ax : ont.getAxioms(AxiomType.DECLARATION)) {
                this.reasonerAxioms.add(ax.getAxiomWithoutAnnotations());
            }
        }
    }

    @Nonnull
    public OWLReasonerConfiguration getReasonerConfiguration() {
        return this.configuration;
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public OWLOntology getRootOntology() {
        return this.rootOntology;
    }

    protected synchronized void handleRawOntologyChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        this.rawChanges.addAll(changes);
        if (this.bufferingMode.equals((Object)BufferingMode.NON_BUFFERING)) {
            this.flush();
        }
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return new ArrayList<OWLOntologyChange>(this.rawChanges);
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
        this.computeDiff(added, new HashSet<OWLAxiom>());
        return added;
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
        this.computeDiff(new HashSet<OWLAxiom>(), removed);
        return removed;
    }

    public void flush() {
        HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
        this.computeDiff(added, removed);
        this.reasonerAxioms.removeAll(removed);
        this.reasonerAxioms.addAll(added);
        this.rawChanges.clear();
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.handleChanges(added, removed);
        }
    }

    private void computeDiff(@Nonnull Set<OWLAxiom> added, @Nonnull Set<OWLAxiom> removed) {
        if (this.rawChanges.isEmpty()) {
            return;
        }
        for (OWLOntology ont : this.rootOntology.getImportsClosure()) {
            for (OWLAxiom ax : ont.getLogicalAxioms()) {
                if (this.reasonerAxioms.contains(ax.getAxiomWithoutAnnotations())) continue;
                added.add(ax);
            }
            for (OWLAxiom ax : ont.getAxioms(AxiomType.DECLARATION)) {
                if (this.reasonerAxioms.contains(ax.getAxiomWithoutAnnotations())) continue;
                added.add(ax);
            }
        }
        for (OWLAxiom ax : this.reasonerAxioms) {
            assert (ax != null);
            if (this.rootOntology.containsAxiom(ax, Imports.INCLUDED, AxiomAnnotations.CONSIDER_AXIOM_ANNOTATIONS)) continue;
            removed.add(ax);
        }
    }

    @Nonnull
    public Collection<OWLAxiom> getReasonerAxioms() {
        return new ArrayList<OWLAxiom>(this.reasonerAxioms);
    }

    protected abstract void handleChanges(@Nonnull Set<OWLAxiom> var1, @Nonnull Set<OWLAxiom> var2);

    public void dispose() {
        this.manager.removeOntologyChangeListener(this.ontologyChangeListener);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.configuration.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.configuration.getIndividualNodeSetPolicy();
    }

    @Nonnull
    public OWLDataFactory getOWLDataFactory() {
        return this.rootOntology.getOWLOntologyManager().getOWLDataFactory();
    }
}

