/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.maps.ObjectObjectHashMap;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.HPPCSet;
import uk.ac.manchester.cs.owl.owlapi.InitVisitorFactory;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.util.collections.SmallSet;

public class MapPointer<K, V extends OWLAxiom> {
    @Nullable
    private final AxiomType<?> type;
    @Nullable
    private final OWLAxiomVisitorEx<?> visitor;
    private boolean initialized;
    @Nonnull
    protected final Internals i;
    private SoftReference<Set<IRI>> iris;
    private int size = 0;
    private final ObjectObjectHashMap<K, Collection<V>> map = new ObjectObjectHashMap(17, 0.75);

    public MapPointer(@Nullable AxiomType<?> t, @Nullable OWLAxiomVisitorEx<?> v, boolean initialized, @Nonnull Internals i) {
        this.type = t;
        this.visitor = v;
        this.initialized = initialized;
        this.i = (Internals)OWLAPIPreconditions.checkNotNull((Object)i, (String)"i cannot be null");
    }

    public synchronized boolean containsReference(K e) {
        return this.map.containsKey(e);
    }

    public synchronized boolean containsReference(IRI e) {
        Set<IRI> set = null;
        if (this.iris != null) {
            set = this.iris.get();
        }
        if (set == null) {
            set = this.initSet();
        }
        return set.contains(e);
    }

    private Set<IRI> initSet() {
        Set set = CollectionFactory.createSet();
        Consumer<ObjectCursor> k = q -> this.consumer(set, (ObjectCursor<K>)q);
        this.map.keys().forEach(k);
        this.iris = new SoftReference<Set>(set);
        return set;
    }

    protected void consumer(Set<IRI> set, ObjectCursor<K> k) {
        if (k.value instanceof OWLEntity) {
            set.add(((OWLEntity)k.value).getIRI());
        } else if (k.value instanceof IRI) {
            set.add((IRI)k.value);
        }
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized MapPointer<K, V> init() {
        if (this.initialized) {
            return this;
        }
        this.initialized = true;
        if (this.visitor == null) {
            return this;
        }
        if (this.visitor instanceof InitVisitorFactory.InitVisitor) {
            for (OWLAxiom ax : this.i.getAxiomsByType().getValues(this.type)) {
                Object key = ax.accept((OWLAxiomVisitorEx)((InitVisitorFactory.InitVisitor)this.visitor));
                if (key == null) continue;
                this.putInternal(key, ax);
            }
        } else {
            for (OWLAxiom ax : this.i.getAxiomsByType().getValues(this.type)) {
                Collection keys = (Collection)ax.accept((OWLAxiomVisitorEx)((InitVisitorFactory.InitCollectionVisitor)this.visitor));
                for (Object key : keys) {
                    this.putInternal(key, ax);
                }
            }
        }
        return this;
    }

    @Nonnull
    public synchronized String toString() {
        return this.initialized + this.map.toString();
    }

    @Nonnull
    public synchronized List<K> keySet() {
        this.init();
        ArrayList keySet = new ArrayList();
        ObjectProcedure predicate = keySet::add;
        this.map.keys().forEach(predicate);
        assert (keySet != null);
        return keySet;
    }

    @Nonnull
    public synchronized List<V> getValues(K key) {
        this.init();
        return this.get(key);
    }

    @Nonnull
    public synchronized <T> Collection<OWLAxiom> filterAxioms(@Nonnull OWLAxiomSearchFilter filter, @Nonnull T key) {
        this.init();
        ArrayList<OWLAxiom> toReturn = new ArrayList<OWLAxiom>();
        for (AxiomType at : filter.getAxiomTypes()) {
            Collection collection = (Collection)this.map.get((Object)at);
            if (collection == null) continue;
            for (OWLAxiom ax : collection) {
                assert (ax != null);
                if (!filter.pass(ax, key)) continue;
                toReturn.add(ax);
            }
        }
        return toReturn;
    }

    public synchronized boolean hasValues(K key) {
        this.init();
        return this.map.containsKey(key);
    }

    public synchronized boolean put(K key, V value) {
        if (!this.initialized) {
            return false;
        }
        this.iris = null;
        return this.putInternal(key, value);
    }

    public synchronized boolean remove(K key, V value) {
        if (!this.initialized) {
            return false;
        }
        this.iris = null;
        return this.removeInternal(key, value);
    }

    public synchronized boolean containsKey(K key) {
        this.init();
        return this.map.containsKey(key);
    }

    public synchronized boolean contains(K key, V value) {
        this.init();
        return this.containsEntry(key, value);
    }

    @Nonnull
    public synchronized List<V> getAllValues() {
        this.init();
        return this.values();
    }

    public synchronized int size() {
        this.init();
        return this.size;
    }

    public synchronized boolean isEmpty() {
        this.init();
        return this.size == 0;
    }

    private boolean putInternal(@Nullable K k, V v) {
        if (k == null) {
            return false;
        }
        Collection<V> set = (Set<V>)this.map.get(k);
        if (set == null) {
            set = Collections.singleton(v);
            this.map.put(k, set);
            ++this.size;
            return true;
        }
        if (set.size() == 1) {
            if (set.contains(v)) {
                return false;
            }
            set = new SmallSet<V>(set);
            this.map.put(k, set);
        } else if (set.size() == 3) {
            if (set.contains(v)) {
                return false;
            }
            set = new HPPCSet<V>(set, v);
            this.map.put(k, set);
            ++this.size;
            return true;
        }
        boolean added = set.add(v);
        if (added) {
            ++this.size;
        }
        return added;
    }

    private boolean containsEntry(K k, V v) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return false;
        }
        return t.contains(v);
    }

    private boolean removeInternal(K k, V v) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return false;
        }
        if (t.size() == 1) {
            if (t.contains(v)) {
                this.map.remove(k);
                --this.size;
                return true;
            }
            return false;
        }
        boolean removed = t.remove(v);
        if (removed) {
            --this.size;
        }
        if (t.isEmpty()) {
            this.map.remove(k);
        }
        return removed;
    }

    @Nonnull
    private List<V> values() {
        ArrayList values = new ArrayList();
        ObjectProcedure p = values::addAll;
        this.map.values().forEach(p);
        return values;
    }

    @Nonnull
    private List<V> get(K k) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return CollectionFactory.emptyList();
        }
        return new ArrayList(t);
    }

    public synchronized void trimToSize() {
    }
}

