/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.DataRangeType;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataRangeVisitor;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLDataOneOfImpl
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLDataOneOf {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<OWLLiteral> values;

    @Override
    protected int index() {
        return 4003;
    }

    public OWLDataOneOfImpl(@Nonnull Set<? extends OWLLiteral> values) {
        OWLAPIPreconditions.checkNotNull(values, (String)"values cannot be null");
        this.values = CollectionFactory.sortOptionally(values);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        for (OWLLiteral value : this.values) {
            entities.add((OWLEntity)value.getDatatype());
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    public DataRangeType getDataRangeType() {
        return DataRangeType.DATA_ONE_OF;
    }

    public Set<OWLLiteral> getValues() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.values);
    }

    public boolean isDatatype() {
        return false;
    }

    public boolean isTopDatatype() {
        return false;
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a data type!");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OWLDataOneOf)) {
            return false;
        }
        if (obj instanceof OWLDataOneOfImpl) {
            return this.values.equals(((OWLDataOneOfImpl)obj).values);
        }
        return ((OWLDataOneOf)obj).getValues().equals(this.getValues());
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLDataOneOf)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLDataOneOf)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataOneOf)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataOneOf)this);
    }

    public void accept(OWLDataRangeVisitor visitor) {
        visitor.visit((OWLDataOneOf)this);
    }

    public <O> O accept(OWLDataRangeVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataOneOf)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLDataOneOfImpl.compareSets(this.values, ((OWLDataOneOf)object).getValues());
    }
}

